/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp_new2.parser;

import com.cognos.i18n.NumericFormat;
import com.cognos.xqe.ast.v5Exp_new2.parser.INameBinding;
import com.cognos.xqe.ast.v5Exp_new2.parser.JavaCharStream;
import com.cognos.xqe.ast.v5Exp_new2.parser.ParseException;
import com.cognos.xqe.ast.v5Exp_new2.parser.SimpleNode;
import com.cognos.xqe.ast.v5Exp_new2.parser.Token;
import com.cognos.xqe.ast.v5Exp_new2.parser.TokenMgrError;
import com.cognos.xqe.ast.v5Exp_new2.parser.V5ExpressionBindingVisitor;
import com.cognos.xqe.ast.v5Exp_new2.parser.V5ExpressionParser;
import com.cognos.xqe.ast.v5Exp_new2.parser.V5ExpressionParserPool;
import com.cognos.xqe.ast.v5Exp_new2.parser.V5ExpressionParserTokenManager;
import java.util.Locale;

public final class V5ExpressionParserUtil {
    private static final String SEPARATOR_XML = "-";
    private static final String SEPARATOR_JAVA = "_";
    private static final String SPLIT_REGEX = "[-_]";

    private V5ExpressionParserUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleNode parseExpression(String expression, Locale locale) throws Exception, ParseException {
        NumericFormat f = new NumericFormat(locale);
        char decSP = f.getDecimalSeparator();
        int dialect = 5;
        if (decSP == ',' || decSP == '\u066b') {
            dialect = 4;
        }
        JavaCharStream inputStream = new JavaCharStream(expression);
        V5ExpressionParserTokenManager tm = V5ExpressionParserPool.getInstance().borrowTokenManager();
        SimpleNode node = null;
        try {
            tm.ReInit(inputStream, dialect);
            V5ExpressionParser parser = new V5ExpressionParser(tm);
            node = parser.expression();
        }
        finally {
            V5ExpressionParserPool.getInstance().returnTokenManager(tm);
        }
        return node;
    }

    public static void bindExpression(SimpleNode node, INameBinding bindingImpl) {
        V5ExpressionBindingVisitor visitor = new V5ExpressionBindingVisitor(bindingImpl);
        node.jjtAccept(visitor, null);
    }

    public static String[] getInvalidTokenImageAndValidSyntax(String expression, ParseException exception) {
        Token invalidToken = exception.currentToken.next;
        if (invalidToken.kind == 0) {
            return new String[0];
        }
        String invalidTokenImage = exception.currentToken.next.image;
        String validSyntax = "";
        int endIndex = exception.currentToken.next.beginColumn - 1;
        if (endIndex > 0) {
            validSyntax = validSyntax + expression.substring(0, endIndex);
        }
        String[] result = new String[]{invalidTokenImage, validSyntax};
        return result;
    }

    public static String[] getInvalidTokenImageAndValidSyntax(String expression, TokenMgrError exception) {
        String validSyntax = "";
        int endIndex = exception.getErrorColumn() - 1;
        if (endIndex > 0) {
            validSyntax = validSyntax + expression.substring(0, endIndex);
        }
        String[] result = new String[]{String.valueOf(exception.getCurChar()), validSyntax};
        return result;
    }

    public static Locale strToLocale(String aLocale) {
        if (aLocale == null || aLocale.length() == 0) {
            return null;
        }
        String[] codes = aLocale.split(SPLIT_REGEX, 2);
        if (codes.length == 1) {
            return new Locale(codes[0].toLowerCase());
        }
        return new Locale(codes[0].toLowerCase(), codes[1].toUpperCase());
    }
}

