/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler;

import com.cognos.xqe.bibushandler.CubeRequestMetrics;
import com.cognos.xqe.bibushandler.SQLQueryMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQueryExecuteMetrics;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class BaseCubeRequestMetrics
extends CubeRequestMetrics {
    private int aggregateCacheNumberOfRequests = 0;
    private long aggregateCacheTotalTime = 0L;
    private BigInteger aggregateCacheCellsRequested = BigInteger.ZERO;
    private BigInteger aggregateCacheCellsNotFound = BigInteger.ZERO;
    private long aggregateCacheNonNullCellsSolved = 0L;
    private final List<SQLQueryMetrics> sqlQueryMetrics = new ArrayList<SQLQueryMetrics>();

    public BaseCubeRequestMetrics(String theCubeName) {
        super(theCubeName);
    }

    public int getAggregateCacheNumberOfRequests() {
        return this.aggregateCacheNumberOfRequests;
    }

    public long getAggregateCacheTotalTime() {
        return this.aggregateCacheTotalTime;
    }

    public BigInteger getAggregateCacheCellsRequested() {
        return this.aggregateCacheCellsRequested;
    }

    public BigInteger getAggregateCacheCellsNotFound() {
        return this.aggregateCacheCellsNotFound;
    }

    public long getAggregateCacheNonNullCellsSolved() {
        return this.aggregateCacheNonNullCellsSolved;
    }

    public List<SQLQueryMetrics> getSqlQueryMetrics() {
        return this.sqlQueryMetrics;
    }

    @Override
    public void update(ROLAPQueryExecuteMetrics qsMetrics) {
        super.update(qsMetrics);
        this.sqlQueryMetrics.addAll(qsMetrics.getSqlQueryMetrics());
        if (qsMetrics.hadAggregateCacheRequest()) {
            this.aggregateCacheTotalTime += qsMetrics.getTotalInMemoryAggregateTime();
            this.aggregateCacheNonNullCellsSolved += (long)qsMetrics.getAggrCacheHits();
            this.aggregateCacheCellsRequested = this.aggregateCacheCellsRequested.add(qsMetrics.getAggregateCacheRequestSetSize());
            this.aggregateCacheCellsNotFound = this.aggregateCacheCellsNotFound.add(qsMetrics.getAggregateCacheReturnSetSize());
            ++this.aggregateCacheNumberOfRequests;
        }
    }

    public String toString() {
        String formatString = "Cube %s\nCache threads waited %,dms enqueing cells to the pipelineResultSet.\nResultSetCache: %,d requests in %,dms with %,d hits.\nExpressionCache: %,d requests in %,dms with %,d hits.\nDataCache: %,d requests in %,dms solved %,d (%,d non null) out of %,d tuples.\nAggregateCache: %,d requests in %,dms solved %,d (%,d non null) out of %,d tuples.\nSQL Statement Summary: %,d calls took %,dms to execute, %,dms to fetch %,d rows, %,d rows discarded, resulting in %,d values.";
        long totalSqlExecuteTime = 0L;
        long totalSqlFetchTime = 0L;
        long totalSqlRowsFetched = 0L;
        long totalSqlRowsDiscarded = 0L;
        long totalValuesCreated = 0L;
        for (SQLQueryMetrics sqlQueryMetric : this.sqlQueryMetrics) {
            totalSqlExecuteTime += sqlQueryMetric.getSqlExectuteTime();
            totalSqlFetchTime += sqlQueryMetric.getSqlFetchTime();
            totalSqlRowsFetched += sqlQueryMetric.getNumberOfRowsFetched();
            totalSqlRowsDiscarded += sqlQueryMetric.getNumberOfRowsDiscarded();
            totalValuesCreated += sqlQueryMetric.getNumberOfValues();
        }
        String txt = String.format(formatString, this.getCubeName(), this.getTotalPipelineWaitTime(), this.getResultSetCacheNumberOfRequests(), this.getResultSetCacheTotalTime(), this.getResultSetCacheNumberOfHits(), this.getExprCacheNumberOfRequests(), this.getExprCacheTotalTime(), this.getExprCacheNumberOfHits(), this.getDataCacheNumberOfRequests(), this.getDataCacheTotalTime(), this.getDataCacheCellsRequested().subtract(this.getDataCacheCellsNotFound()), this.getDataCacheNonNullCellsSolved(), this.getDataCacheCellsRequested(), this.aggregateCacheNumberOfRequests, this.aggregateCacheTotalTime, this.aggregateCacheCellsRequested.subtract(this.aggregateCacheCellsNotFound), this.aggregateCacheNonNullCellsSolved, this.aggregateCacheCellsRequested, this.sqlQueryMetrics.size(), totalSqlExecuteTime, totalSqlFetchTime, totalSqlRowsFetched, totalSqlRowsDiscarded, totalValuesCreated);
        StringBuilder sb = new StringBuilder(txt);
        for (int i = 0; i < this.sqlQueryMetrics.size(); ++i) {
            sb.append("\n #");
            sb.append(String.valueOf(i + 1));
            sb.append(": ");
            sb.append(this.sqlQueryMetrics.get(i).toString());
        }
        return sb.toString();
    }
}

