/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler;

import com.cognos.xqe.bibushandler.CancelRequestSourceEnum;
import com.cognos.xqe.bibushandler.CancelUnsuccessfulException;
import com.cognos.xqe.bibushandler.ICancelable;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.ArrayList;

public class CancelManager
implements ICancelable {
    private static final String INVALID_CANCEL_HANDLER = "Invalid cancel handler.";
    private final ArrayList<ICancelable> mCancelHandlers = new ArrayList();
    private volatile boolean mCanceled = false;
    private CancelRequestSourceEnum mCancelSource = CancelRequestSourceEnum.NONE;
    private static XQELogger mCancelLogger = null;
    private static final String FOR_REQUEST = " for request ";
    private String mRequestID;

    public CancelManager(String requestID) {
        this.mRequestID = requestID;
    }

    private static XQELogger getLogger() {
        if (mCancelLogger == null) {
            mCancelLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Cancel", LogLevel.INFO);
        }
        return mCancelLogger;
    }

    public synchronized void addCancelHandler(ICancelable handler) {
        if (this.mCanceled) {
            throw new OperationCanceledException();
        }
        if (handler == null) {
            throw new IllegalStateException(INVALID_CANCEL_HANDLER);
        }
        if (this.mCancelHandlers.contains(handler)) {
            throw new IllegalStateException("The cancel handler " + handler.getClass().getName() + " is already registered and has not been released");
        }
        this.mCancelHandlers.add(handler);
        if (CancelManager.getLogger().isOn()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Adding cancel handler ").append(handler.getClass().getName());
            buffer.append(FOR_REQUEST).append(this.mRequestID);
            CancelManager.getLogger().log(buffer.toString());
        }
    }

    public synchronized void removeCancelHandler(ICancelable handler) {
        if (handler == null) {
            throw new IllegalStateException(INVALID_CANCEL_HANDLER);
        }
        if (!this.mCancelHandlers.contains(handler)) {
            throw new IllegalStateException("Cancel handler has not been registered");
        }
        if (CancelManager.getLogger().isOn()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Removing cancel handler ").append(handler.getClass().getName());
            buffer.append(FOR_REQUEST).append(this.mRequestID);
            CancelManager.getLogger().log(buffer.toString());
        }
        this.mCancelHandlers.remove(handler);
    }

    @Override
    public synchronized void cancel() throws CancelUnsuccessfulException {
        this.cancel(CancelRequestSourceEnum.USER);
    }

    @Override
    public synchronized void cancel(CancelRequestSourceEnum cancelSource) throws CancelUnsuccessfulException {
        this.mCancelSource = cancelSource;
        this.mCanceled = true;
        RuntimeException savedException = null;
        for (ICancelable i : this.mCancelHandlers) {
            try {
                i.cancel();
            }
            catch (RuntimeException e) {
                if (savedException != null) continue;
                savedException = e;
            }
        }
        if (savedException != null) {
            if (savedException instanceof CancelUnsuccessfulException) {
                throw savedException;
            }
            throw new CancelUnsuccessfulException(savedException);
        }
    }

    public boolean isRequestCancelled() {
        return this.mCanceled;
    }

    public CancelRequestSourceEnum getCancelSource() {
        boolean isReqCanceled = this.isRequestCancelled();
        if (!isReqCanceled) {
            return CancelRequestSourceEnum.NONE;
        }
        return this.mCancelSource;
    }
}

