/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler;

import com.cognos.xqe.bibushandler.CancelRequestSourceEnum;
import com.cognos.xqe.bibushandler.ICancelable;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.CollectionCast;
import java.util.Set;
import org.apache.commons.collections.map.ReferenceMap;

public class CancelableRequestRegistry {
    private final ReferenceMap mCancelableSet = new ReferenceMap(2, 2);
    private static XQELogger mLogger = null;

    private static XQELogger getLogger() {
        if (mLogger == null) {
            mLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Cancel", LogLevel.ERROR);
        }
        return mLogger;
    }

    public int cancel(String requestID) {
        return this.cancel(requestID, CancelRequestSourceEnum.USER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cancel(String requestID, CancelRequestSourceEnum cancelSource) {
        int result = 0;
        ReferenceMap referenceMap = this.mCancelableSet;
        synchronized (referenceMap) {
            Set<ICancelable> cancelableSet = CollectionCast.uncheckedCast(this.mCancelableSet.keySet());
            for (ICancelable cancelable : cancelableSet) {
                try {
                    if (null == cancelable) continue;
                    cancelable.cancel(cancelSource);
                    ++result;
                }
                catch (RuntimeException e) {
                    CancelableRequestRegistry.getLogger().log("Cancel failed for request " + requestID);
                    CancelableRequestRegistry.getLogger().log(e);
                    throw e;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCancelable(String requestID, ICancelable handler) {
        ReferenceMap referenceMap = this.mCancelableSet;
        synchronized (referenceMap) {
            if (this.mCancelableSet.isEmpty() && CancelableRequestRegistry.getLogger().isOn(LogLevel.INFO)) {
                CancelableRequestRegistry.getLogger().log(LogLevel.INFO, "Registering request " + requestID);
            }
            this.mCancelableSet.put((Object)handler, (Object)handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterCancelable(String requestID, ICancelable handler) {
        ReferenceMap referenceMap = this.mCancelableSet;
        synchronized (referenceMap) {
            this.mCancelableSet.remove((Object)handler);
            if (this.mCancelableSet.isEmpty() && CancelableRequestRegistry.getLogger().isOn(LogLevel.INFO)) {
                CancelableRequestRegistry.getLogger().log(LogLevel.INFO, "De-registered request " + requestID);
            }
        }
    }
}

