/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.checksum.ICheckSum;
import com.cognos.xqe.bibushandler.DQWarmupResultSet;
import com.cognos.xqe.bibushandler.DQWarmupSession;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIPartialDataset;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;
import java.util.List;

public class DQWarmupQuery {
    protected DQWarmupSession session;
    protected QueryEngine queryEngine = QueryEngine.getInstance();
    protected IExecutionEnvironment executionEnv;
    protected IXQEQueryNode plan;

    DQWarmupQuery(DQWarmupSession theSession) {
        this.session = theSession;
        this.executionEnv = this.session.getExecutionEnvironment();
    }

    DQWarmupQuery(DQWarmupSession theSession, IXQEQueryNode thePlan) {
        this(theSession);
        this.plan = thePlan;
    }

    public DQWarmupQuery() {
    }

    public IRequestEnvironment getRequestEnvironment() {
        return this.session.getRequestEnvironment();
    }

    public IXQEQueryNode getPlan() {
        return this.plan;
    }

    public IXQEQueryNode[] getAllDatasets() {
        List<IXQEQueryNode> datasets = this.plan.getDescendantsOfTypeOrdered(401005, false);
        return datasets.toArray(new IXQEQueryNode[datasets.size()]);
    }

    public IXQEQueryNode[] getRootDatasets() {
        return this.plan.getChildrenOfType(401005);
    }

    public Parameters getRequestParameters() {
        return ((PlannedV5QuerySet)this.plan).getRequestParameters();
    }

    public void setupRequestParameters() {
        this.getRequestEnvironment().setRequestParameters(this.getRequestParameters());
    }

    public IValue execute() {
        throw new UnsupportedOperationException();
    }

    public DQWarmupResultSet getResultSet() {
        List<IXQEQueryNode> plannedDatasets = this.plan.getDescendantsOfTypeOrdered(401005, false);
        ArrayList<RSAPIDataset> datasets = new ArrayList<RSAPIDataset>(plannedDatasets.size());
        for (IXQEQueryNode planDescendant : plannedDatasets) {
            if (planDescendant.getTypeObject() != 401005) continue;
            RSAPIDataset dataset = (RSAPIDataset)planDescendant;
            datasets.add(dataset);
        }
        RSAPIDataset dataset = (RSAPIDataset)datasets.get(0);
        int nEdges = dataset.getNumEdges();
        int[] startRowNumbers = new int[nEdges];
        int[] numRows = new int[nEdges];
        for (int i = 0; i < nEdges; ++i) {
            startRowNumbers[i] = 1;
            numRows[i] = 0;
        }
        RSAPIPartialDataset partialDataset = this.queryEngine.getPartialDataset(dataset, startRowNumbers, numRows, true, true, this.session.getExecutionEnvironment());
        return new DQWarmupResultSet(this.session, partialDataset);
    }

    public void dumpFormattedXMLQuery(XQETrace trace) {
        this.plan.dumpFormattedXMLQuery(trace);
    }

    public String dumpToString(boolean includeRuntimeSpecifics) {
        return this.plan.dumpToString(includeRuntimeSpecifics);
    }

    public ICheckSum getCheckSum() {
        return this.plan.getCheckSum();
    }

    public List<IXQEQueryNode> getSQLQueries() {
        return this.plan.getDescendantsOfCategory(501013, false);
    }

    public List<IXQEQueryNode> getMDXQueries() {
        return this.plan.getDescendantsOfCategory(501017, false);
    }

    public boolean isValid() {
        return true;
    }

    public void release() {
    }
}

