/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler;

import com.cognos.pogo.pdk.Fault;
import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.CancelRequestSourceEnum;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;

public class OperationCanceledException
extends XQERuntimeException {
    static final long serialVersionUID = 1L;

    public OperationCanceledException() {
        this((CancelRequestSourceEnum)null);
    }

    public OperationCanceledException(CancelRequestSourceEnum cancelSource) {
        super(XQEMessageKeys.GEN_RequestCancelled);
        IExecutionEnvironment execEnv = ExecutionEnvironmentContext.getExecutionEnvironment();
        if (cancelSource == null) {
            cancelSource = this.getCancelSource(execEnv);
        }
        switch (cancelSource) {
            case RESOURCE_MONITOR: {
                XQELogger resourceMonitorLogger = ROLAPLog.getLogger("Resources.Monitor");
                resourceMonitorLogger.log("Canceled request " + execEnv.getRequestID() + " due to low memory condition.");
                this.setMessageKey(new Object[0], XQEMessageKeys.GEN_RequestCancelledByResourceMonitor);
                break;
            }
            case EXCESSIVE_GARBAGE_COLLECTION: {
                this.setMessageKey(new Object[0], XQEMessageKeys.GEN_RequestCancelledByExcessiveGarbageCollection);
                break;
            }
            case USER: {
                break;
            }
        }
        this.setLogLevel(LogLevel.INFO);
    }

    private CancelRequestSourceEnum getCancelSource(IExecutionEnvironment execEnv) {
        CancelManager cancelManager;
        if (execEnv != null && (cancelManager = execEnv.getCancelManager()) != null) {
            return cancelManager.getCancelSource();
        }
        return CancelRequestSourceEnum.USER;
    }

    @Override
    public String getFaultCode() {
        return "RSA-ERR-0007";
    }

    @Override
    public Fault getFault() {
        return this.getFaultFromEnvelope();
    }
}

