/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler;

import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.mfw4j.utilities.IMFWCMRequestExecutor;
import com.cognos.mfw4j.utilities.MFWSimpleCMRequestExecutor;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.ast.v5Exp.V5MemberUniqueName;
import com.cognos.xqe.bibushandler.BaseRequestEnvironment;
import com.cognos.xqe.bibushandler.CancelableRequestRegistry;
import com.cognos.xqe.bibushandler.RequestMetrics;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.ma4j.framework.IMAAttributeTransformer;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.masterdetail.MasterDetailProvider;
import com.cognos.xqe.query.missingMember.MissingMember;
import com.cognos.xqe.query.parameters.GlobalParametersUtil;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.trace.CollectXQELogs;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.TraceLogManager;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.config.LoggingOverrides;
import com.cognos.xqe.util.IParameterMaps;
import com.cognos.xqe.util.IQueryReuseManager;
import com.cognos.xqe.util.ParameterAccessCoordinator;
import com.cognos.xqe.util.ParameterMapCM;
import com.cognos.xqe.util.ParameterMapsApp;
import com.cognos.xqe.util.QueryReuseManager;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import com.cognos.xqemoser.ReportService;
import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;

public final class RequestEnvironment
extends BaseRequestEnvironment<ExecutionEnvironment> {
    private static final Namespace SOAP_ENV_NS = new Namespace("SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/");
    private static final QName HEADER_NAME = new QName("Header", SOAP_ENV_NS);
    private static final String CM_CACHE_CONTEXT_ELEMENT_NAME = "CMCacheContext";
    private static final String CONNECTION_ELEMENT_NAME = "connection";
    private static final String EXECUTE_DETAIL_QUERY_ELEMENT_NAME = "executeDetailQuery";
    private static final String GET_DETAIL_QUERIES_ELEMENT_NAME = "getDetailQueries";
    private static final String GET_PARTIAL_DATASET_ELEMENT_NAME = "getPartialDataset";
    private static final String METADATA = "Metadata";
    private static final String MODELPATH = "modelPath";
    private static final String PROVIDER_METADATA = "providerMetadata";
    private static final String QUERY_RESULT_DEFINITIONS = "queryResultDefinitions";
    private static final String QUERY_SET = "querySet";
    private static final String REF_QUERY = "refQuery";
    private static final String RELEASE_DATASET_ELEMENT_NAME = "releaseDataset";
    private static final String REQUEST_HINTS = "requestHints";
    private static final String RETRIEVE_DATASET = "retrieveDataset";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String NAME_ATTRIBUTE = "name";
    public static final String UNKNOWN = "unknown";
    private static final String[] SUPPORTED_COMMAND_NAMES = new String[]{"prepare", "execute", "Metadata", "getParameters", "getPartialDataset", "releaseDataset", "validate", "migrate", "getDetailQueries", "executeDetailQuery", "cancel", "describeDataSourceQuery", "fmCommand", "testConnection", "update", "providerMetadata", "moserCommand"};
    private static final String CAM_ELEMENT_NAME = "CAM";
    public static final String CAM_PASSPORT_ELEMENT_NAME = "CAMPassport";
    private static final String CAM_CAPABILITY_PASSPORT_ELEMENT_NAME = "CAMCapabilityPassport";
    private static final String TRACKING_ELEM_NAME = "tracking";
    private static final String SESSION_CONTEXT_ELEM_NAME = "sessionContext";
    public static final String REPORT_ELEMENT_NAME = "report";
    public static final String REPORT_PATH_ELEMENT_NAME = "reportPath";
    private static final String ID_ELEMENT_NAME = "id";
    private static final String HEADER_SESSION_ELEMENT_NAME = "hdrSession";
    private static final String COOKIE_VARS_ELEMENT_NAME = "cookieVars";
    private static final String ITEM_ELEMENT_NAME = "item";
    private static final String SAP_COOKIE_NAME = "MYSAPSSO2";
    private static final String SERVICE_ID = "serviceID";
    private BIBusEnvelope mRequestEnvelope;
    private final Map<String, MissingMember> missingMuns = new TreeMap<String, MissingMember>();
    private final Map<String, V5MemberUniqueName> v5MunMap = new HashMap<String, V5MemberUniqueName>();
    private static final int DEFAULT_PRIORITY = 1000;
    private static final String SUPPORTED_MIGRATION_BASE_VERSIONS = "0 (for Compatible), 2 (for DQM)";
    private ParameterAccessCoordinator requestPAC = null;
    private static Boolean cookieSupportEnabled = null;
    IParameterMaps mCookieMap = null;
    private MasterDetailProvider masterdetailprovider = new MasterDetailProvider();
    private ReportService reportService = null;
    private RequestMetrics requestMetrics = new RequestMetrics();
    private Set<String> boundParameters = new HashSet<String>();
    private MigrationBaseVersionEnum migrationBaseVersion = MigrationBaseVersionEnum.NOT_DEFINED;
    private String[] retrieveDatasets;
    private String resultsetFileName;
    private boolean bSaveResultSet;
    private int nLastSavedQuery = 0;
    protected IMAAttributeTransformer maResponseAttributeTransformer = null;
    private IMFWCMRequestExecutor mCMRequestExecutor = null;
    private boolean isRSVP4J = false;
    private HttpServletRequest httpServletRequest = null;
    private boolean bMacroInCommandBlocks = false;

    public MasterDetailProvider getMasterDetailProvider() {
        return this.masterdetailprovider;
    }

    public void setMasterDetailProvider(MasterDetailProvider theMasterDetailProvider) {
        this.masterdetailprovider = theMasterDetailProvider;
    }

    private void init(BIBusEnvelope requestEnvelope) {
        this.mRequestEnvelope = requestEnvelope;
        this.extractBiBusHeaderParameters(this.getBibusHeader());
    }

    public RequestEnvironment() {
    }

    public RequestEnvironment(BIBusEnvelope requestEnvelope, CancelableRequestRegistry cancelableRequestRegistry) {
        super(cancelableRequestRegistry);
        this.init(requestEnvelope);
    }

    public RequestEnvironment(Element biBusHeader) {
        Element soapHeader = DocumentHelper.createElement((QName)HEADER_NAME);
        soapHeader.add(biBusHeader);
        this.init(new BIBusEnvelope(soapHeader));
    }

    public RequestEnvironment(BIBusEnvelope requestEnvelope) {
        this(requestEnvelope, null);
    }

    public RequestEnvironment(IMFWCMRequestExecutor executor) {
        this.mCMRequestExecutor = executor;
        Element soapHeader = DocumentHelper.createElement((QName)HEADER_NAME);
        this.mRequestEnvelope = new BIBusEnvelope(soapHeader);
    }

    public void resetBIBusEnvelope(BIBusEnvelope requestEnvelope) {
        this.mRequestEnvelope = requestEnvelope;
        this.extractBiBusHeaderParameters(this.getBibusHeader());
    }

    public void resetEnvelopeFromExecutor() {
        if (this.mCMRequestExecutor != null) {
            this.resetBIBusEnvelope(this.mCMRequestExecutor.getEnvelope());
        }
    }

    @Override
    public ParameterAccessCoordinator getRequestPAC() {
        return this.requestPAC;
    }

    public void setRequestPAC(ParameterAccessCoordinator pac) {
        this.requestPAC = pac;
    }

    public void resetRequestPAC() {
        this.requestPAC = null;
    }

    private synchronized IParameterMaps getParameterMap() {
        ParameterMapCM map = ((ExecutionEnvironment)this.getExecutionEnvironment()).getMultiRequestContext().getCMMap();
        if (map != null) {
            return map;
        }
        map = new ParameterMapCM(this);
        map.loadParameterMapFromCM();
        return map;
    }

    public void initializeRequestPAC(Element command) {
        if (this.requestPAC == null) {
            this.requestPAC = new ParameterAccessCoordinator();
            this.loadRequestPACWithCommandInfo(command);
            this.loadRequestPACWithOverrideParameterMap(command);
            if (this.mRequestEnvelope != null) {
                this.requestPAC.addParameterMap(this.getParameterMap());
            }
            MultiRequestContext mrc = ((ExecutionEnvironment)this.mExecutionEnvironment).getMultiRequestContext();
            GlobalParametersUtil.addGlobalParamMapToPAC(this.requestPAC, mrc, this);
            this.requestPAC.addParameterAccessCoordinator(XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE).getParameterAccessCoordinator());
        }
    }

    private void loadRequestPACWithConnectionInfo(Element connection, ParameterMapsApp envMap, boolean metadataCommand, String excludeList) {
        String value = VALUE_ATTRIBUTE;
        List els = connection.elements();
        for (Element element : els) {
            String val;
            String name = element.getName();
            String lookup = name + ";";
            if (excludeList.contains(lookup) || (val = element.attributeValue(VALUE_ATTRIBUTE)) == null) continue;
            if ("dataSource".equals(name) && metadataCommand) {
                name = MODELPATH;
            }
            envMap.set(name, val);
        }
    }

    private void loadRequestPACWithCommandInfo(Element command) {
        ParameterMapsApp envMap = new ParameterMapsApp("_env", IParameterMaps.EPRIORITY.CQE_REQUEST.getKey());
        String value = VALUE_ATTRIBUTE;
        if (command != null) {
            Element info;
            Element qrds;
            String val;
            String val2;
            String val3;
            String val4;
            String val5;
            String contextID = "contextID";
            Element subElement = command.element("contextID");
            if (subElement != null && (val5 = subElement.attributeValue(VALUE_ATTRIBUTE)) != null) {
                envMap.set("contextID", subElement.attributeValue(VALUE_ATTRIBUTE));
            }
            if ((subElement = command.element(REPORT_PATH_ELEMENT_NAME)) != null && (val5 = subElement.attributeValue(VALUE_ATTRIBUTE)) != null) {
                envMap.set(REPORT_PATH_ELEMENT_NAME, subElement.attributeValue(VALUE_ATTRIBUTE));
            }
            String remoteAddr = "REMOTE_ADDR";
            subElement = command.element("REMOTE_ADDR");
            if (subElement != null && (val4 = subElement.attributeValue(VALUE_ATTRIBUTE)) != null) {
                envMap.set("REMOTE_ADDR", subElement.attributeValue(VALUE_ATTRIBUTE));
            }
            String httpHost = "HTTP_HOST";
            subElement = command.element("HTTP_HOST");
            if (subElement != null && (val3 = subElement.attributeValue(VALUE_ATTRIBUTE)) != null) {
                envMap.set("HTTP_HOST", subElement.attributeValue(VALUE_ATTRIBUTE));
            }
            String serverName = "SERVER_NAME";
            subElement = command.element("SERVER_NAME");
            if (subElement != null && (val2 = subElement.attributeValue(VALUE_ATTRIBUTE)) != null) {
                envMap.set("SERVER_NAME", subElement.attributeValue(VALUE_ATTRIBUTE));
            }
            String queryRetrieved = null;
            Element retrieveDataset = command.element(RETRIEVE_DATASET);
            if (retrieveDataset != null && (val = retrieveDataset.attributeValue(VALUE_ATTRIBUTE)) != null) {
                queryRetrieved = val;
            }
            String queryName = "queryName";
            Element querySet = command.element(QUERY_SET);
            if (querySet != null && (qrds = querySet.element(QUERY_RESULT_DEFINITIONS)) != null) {
                List els = qrds.elements();
                for (Element qrd : els) {
                    if (queryRetrieved != null) {
                        String val6;
                        String name = qrd.attributeValue(NAME_ATTRIBUTE);
                        if (!queryRetrieved.equals(name) || (val6 = qrd.attributeValue(REF_QUERY)) == null) continue;
                        envMap.set("queryName", val6);
                        break;
                    }
                    String val7 = qrd.attributeValue(REF_QUERY);
                    if (val7 == null) continue;
                    envMap.set("queryName", val7);
                    break;
                }
            }
            boolean nestedConnectionElements = false;
            Element connection = command.element(CONNECTION_ELEMENT_NAME);
            if (command.getName().equals(CONNECTION_ELEMENT_NAME)) {
                if (null == connection) {
                    connection = command;
                } else {
                    nestedConnectionElements = true;
                }
            }
            String excludeForSecurityConcerns = "serviceID;password;";
            String excludeUseless = "QFProviderType;";
            String excludeList = excludeForSecurityConcerns + excludeUseless;
            boolean metadataCommand = false;
            if (nestedConnectionElements) {
                this.loadRequestPACWithConnectionInfo(command, envMap, metadataCommand, excludeList);
            }
            if (connection != null) {
                metadataCommand = METADATA.equals(command.getName());
                this.loadRequestPACWithConnectionInfo(connection, envMap, metadataCommand, excludeList);
            }
            if ((info = this.mInfo) == null) {
                info = command.element("info");
            }
            if (info != null) {
                Element reportElement = info.element(REPORT_ELEMENT_NAME);
                if (reportElement != null) {
                    envMap.set(REPORT_ELEMENT_NAME, reportElement.getText());
                }
                String startTime = "startTime";
                Element startTimeElement = info.element("startTime");
                if (startTimeElement != null) {
                    envMap.set("startTime", startTimeElement.getText());
                }
            }
        }
        if (this.getRequestID() != null) {
            envMap.set("requestID", this.getRequestID());
        }
        if (this.getSubRequestID() != null) {
            envMap.set("subRequestID", this.getSubRequestID());
        }
        if (this.getModelPath() != null) {
            envMap.set(MODELPATH, this.getModelPath());
        }
        this.requestPAC.addParameterMap(envMap);
        IParameterMaps cookieMap = this.getOrCreateCookieMap();
        if (cookieMap != null) {
            this.requestPAC.addParameterMap(cookieMap);
        }
    }

    public IParameterMaps getOrCreateCookieMap() {
        if (cookieSupportEnabled == null) {
            XQEConfiguration config = XQEConfigurationManager.getInstance().getOrCreateXQEConfiguration();
            cookieSupportEnabled = config.getBooleanProperty("general.cookieSupport[@enabled]", false);
        }
        if (!cookieSupportEnabled.booleanValue()) {
            return null;
        }
        if (this.mCookieMap == null) {
            ParameterMapsApp cookieMap = new ParameterMapsApp("cookies", IParameterMaps.EPRIORITY.CQE_REQUEST.getKey());
            this.loadSetCookiesIntoCookieMap(cookieMap);
            this.mCookieMap = cookieMap;
        }
        return this.mCookieMap;
    }

    private static boolean hasTextChild(Node aNode) {
        if (aNode == null || aNode.getNodeType() != 1) {
            return false;
        }
        String txt = aNode.getText();
        return txt != null && txt.length() > 0;
    }

    private void loadSetCookiesIntoCookieMap(ParameterMapsApp cookieMap) {
        BIBusEnvelope clientEnvelope = this.mRequestEnvelope;
        Element elmSetCookieVars = clientEnvelope.getCookieVars();
        if (elmSetCookieVars == null) {
            return;
        }
        List listSetCookieVars = elmSetCookieVars.elements();
        if (listSetCookieVars == null || listSetCookieVars.size() == 0) {
            return;
        }
        for (int idx = 0; idx < listSetCookieVars.size(); ++idx) {
            Element eCookieNode = (Element)listSetCookieVars.get(idx);
            Element eCookieName = eCookieNode.element(NAME_ATTRIBUTE);
            Element eCookieValue = eCookieNode.element(VALUE_ATTRIBUTE);
            String sCookieName = "";
            String sCookieValue = "";
            if (RequestEnvironment.hasTextChild((Node)eCookieName)) {
                sCookieName = eCookieName.getTextTrim();
            }
            if (RequestEnvironment.hasTextChild((Node)eCookieValue)) {
                sCookieValue = eCookieValue.getTextTrim();
            }
            cookieMap.set("cookies", sCookieName, sCookieValue);
        }
    }

    private void loadRequestPACWithOverrideParameterMap(Element command) {
        if (command != null) {
            Element parameterMap;
            Element querySet = command.element(QUERY_SET);
            Element metadata = command.element(METADATA);
            Element requestHints = null;
            if (querySet != null) {
                requestHints = querySet.element(REQUEST_HINTS);
            } else if (metadata != null) {
                requestHints = metadata.element(REQUEST_HINTS);
            }
            if (requestHints != null && (parameterMap = requestHints.element("parameterMap")) != null) {
                String mapName = parameterMap.attributeValue(NAME_ATTRIBUTE);
                int pri = 1000;
                String priority = parameterMap.attributeValue("priority");
                if (priority != null) {
                    pri = Integer.parseInt(priority);
                }
                ParameterMapsApp requestHintsEnvMap = new ParameterMapsApp(mapName, pri);
                List entries = parameterMap.elements("parameterMapEntry");
                for (Element entry : entries) {
                    String entryKey = entry.attributeValue("key");
                    String entryValue = entry.attributeValue(VALUE_ATTRIBUTE);
                    requestHintsEnvMap.set(mapName, entryKey, entryValue);
                }
                this.requestPAC.addParameterMap(requestHintsEnvMap);
            }
        }
    }

    @Override
    public ParameterAccessCoordinator getParameterAccessCoordinator(PlanningEnvironment planEnv) {
        return this.getParameterAccessCoordinator(planEnv, planEnv.getModelPath());
    }

    public ParameterAccessCoordinator getParameterAccessCoordinator(PlanningEnvironment planEnv, String metadataPath) {
        ParameterAccessCoordinator pac = new ParameterAccessCoordinator();
        pac.addParameterAccessCoordinator(this.getRequestPAC());
        pac.addParameterAccessCoordinator(planEnv.getPlanningPACMetadataPath(metadataPath));
        return pac;
    }

    public void setReportService(ReportService rs) {
        this.reportService = rs;
    }

    public ReportService getReportService() {
        return this.reportService == null ? new ReportService(this.getCAMPassport(), this.getCookies()) : this.reportService;
    }

    public BIBusEnvelope getRequestEnvelope() {
        if (this.mCMRequestExecutor != null) {
            return this.mCMRequestExecutor.getEnvelope();
        }
        return this.mRequestEnvelope;
    }

    @Override
    public Element getBibusHeader() {
        if (this.mCMRequestExecutor != null) {
            return this.mCMRequestExecutor.getHeader();
        }
        return this.mRequestEnvelope.getBIBusHeader();
    }

    public void setCMRequestExecutor(IMFWCMRequestExecutor executor) {
        this.mCMRequestExecutor = executor;
    }

    public boolean isCMRequestExecutorDefined() {
        return this.mCMRequestExecutor != null;
    }

    public IMFWCMRequestExecutor getCMRequestExecutor() {
        if (this.mCMRequestExecutor == null) {
            return new MFWSimpleCMRequestExecutor(this.mRequestEnvelope, this.camPassport);
        }
        return this.mCMRequestExecutor;
    }

    public Map<String, MissingMember> getRequestMissingMembers() {
        return this.missingMuns;
    }

    public void addMun(V5MemberUniqueName v5Mun, String nativeName) {
        if (!this.v5MunMap.containsKey(nativeName)) {
            this.v5MunMap.put(nativeName, v5Mun);
        }
    }

    public Map<String, V5MemberUniqueName> getV5Muns() {
        return this.v5MunMap;
    }

    public void extractParametersFromCommand(BIBusEnvelope requestEnvelope, Element commandElement) {
        String productLocaleString = null;
        String runLocaleString = null;
        String expressionLocaleString = null;
        String requestIDString = null;
        String subRequestIDString = null;
        if (commandElement != null) {
            Element reportPathElement;
            String propertyNameString;
            Element propertyElement;
            Element subRequestIDElement;
            Element requestIDElement;
            Element connectionElement = commandElement.element(CONNECTION_ELEMENT_NAME);
            Element querySetElement = commandElement.element(QUERY_SET);
            if (null != querySetElement) {
                expressionLocaleString = querySetElement.attributeValue("expressionLocale");
            } else {
                Element metadataElement = commandElement.element(METADATA);
                if (metadataElement != null) {
                    expressionLocaleString = metadataElement.attributeValue("authoringLocale");
                }
            }
            if (connectionElement != null) {
                Element camCapabilityPassportElem;
                Element serviceIDElement;
                Element productLocaleElement = null;
                Element runLocaleElement = null;
                productLocaleElement = connectionElement.element("productLocale");
                runLocaleElement = connectionElement.element("runLocale");
                if (productLocaleElement != null) {
                    productLocaleString = productLocaleElement.attributeValue(VALUE_ATTRIBUTE);
                }
                if (runLocaleElement != null) {
                    runLocaleString = runLocaleElement.attributeValue(VALUE_ATTRIBUTE);
                }
                if ((serviceIDElement = connectionElement.element(SERVICE_ID)) != null) {
                    this.serviceID = serviceIDElement.attributeValue(VALUE_ATTRIBUTE);
                }
                Element cmCacheElement = connectionElement.element(CM_CACHE_CONTEXT_ELEMENT_NAME);
                if (METADATA.equals(commandElement.getName())) {
                    this.packageName = this.getPackageNameFrom(connectionElement.element("dataSource"), false);
                } else if (null != querySetElement) {
                    this.packageName = this.getPackageNameFrom(querySetElement.element(MODELPATH), false);
                } else if (cmCacheElement != null) {
                    this.packageName = this.getPackageNameFrom(cmCacheElement, true);
                }
                if (null == this.modelPath && null != requestEnvelope) {
                    this.modelPath = requestEnvelope.getFormValue(MODELPATH);
                }
                if (null == this.packageName) {
                    this.packageName = this.extractPackageNameFromString(this.modelPath);
                }
                if (null != (camCapabilityPassportElem = connectionElement.element(CAM_CAPABILITY_PASSPORT_ELEMENT_NAME))) {
                    String cookiePassport = camCapabilityPassportElem.attributeValue(VALUE_ATTRIBUTE);
                    this.setCAMCapabilityPassport(cookiePassport);
                }
            }
            if (null != (requestIDElement = commandElement.element("requestID"))) {
                requestIDString = requestIDElement.attributeValue(VALUE_ATTRIBUTE);
            }
            if (null != (subRequestIDElement = commandElement.element("subRequestID"))) {
                subRequestIDString = subRequestIDElement.attributeValue(VALUE_ATTRIBUTE);
            }
            if (null != (propertyElement = commandElement.element("property")) && (propertyNameString = propertyElement.attributeValue(NAME_ATTRIBUTE)).equals("includeEmptyCells")) {
                String propertyValueString = propertyElement.attributeValue(VALUE_ATTRIBUTE);
                boolean aIncludeEmptyCells = propertyValueString != null && propertyValueString.equals("true");
                this.setIncludeEmptyCells(aIncludeEmptyCells);
            }
            if (null != (reportPathElement = commandElement.element(REPORT_PATH_ELEMENT_NAME))) {
                this.reportPath = reportPathElement.getText();
                if (this.reportPath == null || this.reportPath.length() == 0) {
                    this.reportPath = reportPathElement.attribute(VALUE_ATTRIBUTE).getText();
                }
            }
        }
        if (null != requestEnvelope) {
            if (null == requestIDString) {
                requestIDString = requestEnvelope.getConversationContextID();
            }
            if (null == productLocaleString) {
                productLocaleString = requestEnvelope.getUserPreferenceValue("productLocale");
            }
            if (null == runLocaleString && null == (runLocaleString = requestEnvelope.getUserPreferenceValue("runLocale"))) {
                runLocaleString = requestEnvelope.getUserPreferenceValue("contentLocale");
            }
            if (expressionLocaleString == null && commandElement != null && GET_PARTIAL_DATASET_ELEMENT_NAME.equals(commandElement.getName())) {
                expressionLocaleString = RequestEnvironment.extractExpressionLocaleFromReportSpecification(requestEnvelope);
            }
        }
        this.setProductLocale(productLocaleString);
        this.setRunLocale(runLocaleString);
        this.setExpressionLocale(expressionLocaleString);
        this.setRequestID(requestIDString);
        this.setSubRequestID(subRequestIDString);
        this.setInternalQuery(false);
    }

    public void extractParametersFromCommand(Element commandElement) {
        this.extractParametersFromCommand(null, commandElement);
    }

    public void extractParameters(Element requestBody) {
        this.extractParametersFromCommand(RequestEnvironment.getCommandElement(requestBody));
    }

    private void extractBiBusHeaderParameters(Element biBusHeader) {
        Element sessionIdElement;
        Element trackingElem;
        Element camPassportElem;
        this.setBiBusHeaderElement(biBusHeader);
        Element camElem = biBusHeader.element(CAM_ELEMENT_NAME);
        if (null != camElem && null != (camPassportElem = camElem.element(CAM_PASSPORT_ELEMENT_NAME))) {
            this.setCAMPassportElement(camPassportElem);
            Element id = camPassportElem.element(ID_ELEMENT_NAME);
            if (null != id) {
                this.setCAMPassport(id.getText());
            }
        }
        if (null != (trackingElem = biBusHeader.element(TRACKING_ELEM_NAME)) && null != (sessionIdElement = trackingElem.element(SESSION_CONTEXT_ELEM_NAME))) {
            this.biBusSessionID = sessionIdElement.getText();
        }
        this.extractCookiesAndSAPLogonTicket(biBusHeader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String extractExpressionLocaleFromReportSpecification(BIBusEnvelope requestEnvelope) {
        if (requestEnvelope == null) {
            return null;
        }
        String reportSpecification = requestEnvelope.getFormValue("ui.spec");
        if (reportSpecification == null) {
            return null;
        }
        String expressionLocaleString = null;
        XMLStreamReader reader = null;
        try {
            reader = StaxUtil.createXMLStreamReader(reportSpecification);
            StaxUtil.moveToElement(reader);
            expressionLocaleString = reader.getAttributeValue("", "expressionLocale");
        }
        catch (Exception ex) {
            XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "RequestAdapter.V5Request", LogLevel.INFO);
            logger.log(LogLevel.WARN, String.format("The expression locale could not be extracted from the report specification: %s", reportSpecification), (Throwable)ex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (XMLStreamException xMLStreamException) {}
        }
        return expressionLocaleString;
    }

    public void initializeLoggingOverrides() {
        this.mLoggingOverrides = LoggingOverrides.extractFromBiBusHeader(this.getBibusHeader(), this.getSessionContextID());
    }

    private void extractCookiesAndSAPLogonTicket(Element biBusHeader) {
        Element cookieVars;
        Element hdrSession = biBusHeader.element(HEADER_SESSION_ELEMENT_NAME);
        if (null != hdrSession && null != (cookieVars = hdrSession.element(COOKIE_VARS_ELEMENT_NAME))) {
            List items = cookieVars.elements(ITEM_ELEMENT_NAME);
            for (Element item : items) {
                Element name = item.element(NAME_ATTRIBUTE);
                Element value = item.element(VALUE_ATTRIBUTE);
                if (null == name || value == null) continue;
                String nameStr = name.getText();
                String ticketText = value.getText();
                if (nameStr != null && ticketText != null) {
                    if (this.cookies == null) {
                        this.cookies = new TreeMap();
                    }
                    this.cookies.put(nameStr, ticketText);
                }
                if (!SAP_COOKIE_NAME.equals(nameStr)) continue;
                this.sapLogonTicket = ticketText;
            }
        }
    }

    public static Element getCommandElement(Element requestBody) {
        String commandName;
        Element command = null;
        String[] stringArray = SUPPORTED_COMMAND_NAMES;
        int n = stringArray.length;
        for (int i = 0; i < n && (command = requestBody.element(commandName = stringArray[i])) == null; ++i) {
        }
        return command;
    }

    public RequestEnvironment duplicate() {
        RequestEnvironment copy = new RequestEnvironment(this.mRequestEnvelope, this.mCancelableRequestRegistry);
        this.copyDefinitionToCopy(copy);
        QueryEngine.getInstance().configureRequestEnvironment(copy);
        IExecutionEnvironment newExecutionEnvironment = copy.mExecutionEnvironment;
        newExecutionEnvironment.setMultiRequestContext(((ExecutionEnvironment)this.mExecutionEnvironment).getMultiRequestContext());
        newExecutionEnvironment.setConnectionElement(((ExecutionEnvironment)this.mExecutionEnvironment).getConnectionElement());
        newExecutionEnvironment.setConnectionPool(((ExecutionEnvironment)this.mExecutionEnvironment).getConnectionPool());
        newExecutionEnvironment.setCancelManager(((ExecutionEnvironment)this.mExecutionEnvironment).getCancelManager());
        return copy;
    }

    protected void copyDefinitionToCopy(RequestEnvironment copy) {
        copy.camPassport = this.camPassport;
        copy.camUserPassport = this.camUserPassport;
        copy.curTraceWriter = this.curTraceWriter;
        copy.mInfo = this.mInfo;
        copy.mTrace = this.mTrace;
        copy.expressionLocale = this.expressionLocale;
        copy.productLocale = this.productLocale;
        copy.runLocale = this.runLocale;
        copy.sessionContextID = this.sessionContextID;
        copy.requestID = this.requestID;
        copy.subRequestID = UUID.randomUUID().toString();
        copy.sapLogonTicket = this.sapLogonTicket;
        copy.sqlFilePath = this.sqlFilePath;
        copy.modelPath = this.modelPath;
        copy.modelType = this.modelType;
        if (this.cookies != null) {
            copy.cookies = new TreeMap(this.cookies);
        }
        copy.packageName = this.packageName;
        copy.reportName = this.reportName;
        copy.randomSeed = this.randomSeed;
        copy.randomSeedSet = this.randomSeedSet;
        copy.responseMessageFolder = this.responseMessageFolder;
        copy.operationName = this.operationName;
        copy.environmentFactory = this.environmentFactory;
        copy.maResponseAttributeTransformer = this.maResponseAttributeTransformer;
        copy.requestPAC = this.requestPAC;
        copy.mLoggingOverrides = this.mLoggingOverrides;
        copy.setIncludeEmptyCells(this.getIncludeEmptyCells());
        copy.setInternal(true);
        copy.setValidateRequest(this.isValidateRequest());
        copy.setValidateMissingMembers(this.isValidateMissingMembers());
        copy.setDMRRequest(this.isDMRRequest());
        copy.setMixedRequest(this.isMixedRequest());
        copy.setDatasetPath(this.getDatasetPath());
        copy.setMacroInCommandBlocks(this.getMacroInCommandBlocks());
    }

    public RequestEnvironment duplicatePartial() {
        RequestEnvironment copy = new RequestEnvironment(this.mRequestEnvelope);
        this.copyDefinitionToCopy(copy);
        copy.sessionContextID = copy.sessionContextID + "_preloadJoinGragh";
        copy.setValidateRequest(true);
        QueryEngine.getInstance().configureRequestEnvironment(copy);
        IExecutionEnvironment newExecutionEnvironment = copy.mExecutionEnvironment;
        newExecutionEnvironment.setConnectionElement(((ExecutionEnvironment)this.mExecutionEnvironment).getConnectionElement());
        return copy;
    }

    private String getPackageNameFrom(Element cacheContext, boolean isCacheContext) {
        if (cacheContext == null) {
            return null;
        }
        String value = cacheContext.attributeValue(VALUE_ATTRIBUTE);
        if (value == null && (value = cacheContext.getText()) == null) {
            return null;
        }
        if (!isCacheContext && this.modelPath == null) {
            this.modelPath = value;
            String type = cacheContext.attributeValue("type");
            if (type != null) {
                this.modelType = type;
            }
        }
        if (this.mCMCacheContext == null && isCacheContext) {
            this.setCMCacheContext(value);
        }
        return this.extractPackageNameFromString(value);
    }

    private String extractPackageNameFromString(String value) {
        if (null != value) {
            String quote;
            int endIndex;
            String packagePattern = "package[@name=";
            int index = value.indexOf(packagePattern);
            if (index < 0) {
                return null;
            }
            if ((endIndex = value.indexOf((quote = value.substring((index += packagePattern.length() + 1) - 1, index)) + "]", index)) < index) {
                return null;
            }
            return value.substring(index, endIndex);
        }
        return null;
    }

    public String getModelPathFromRequestDocument() {
        MultiRequestContext multiRequestContext = ((ExecutionEnvironment)this.getExecutionEnvironment()).getMultiRequestContextNoThrow();
        Document requestDocument = null;
        if (null != multiRequestContext) {
            requestDocument = multiRequestContext.getRequestDocument();
        }
        Element rootElement = null;
        if (null != requestDocument) {
            rootElement = requestDocument.getRootElement();
        }
        Element querySet = null;
        if (null != rootElement) {
            querySet = rootElement.element(QUERY_SET);
        }
        Element modelPath = null;
        if (null != querySet) {
            modelPath = querySet.element(MODELPATH);
        }
        String myModelPath = null;
        if (null != modelPath) {
            myModelPath = modelPath.getText();
        }
        return myModelPath;
    }

    public String getPackageFromRequestDocument() {
        MultiRequestContext multiRequestContext = ((ExecutionEnvironment)this.getExecutionEnvironment()).getMultiRequestContextNoThrow();
        Document requestDocument = null;
        if (null != multiRequestContext) {
            requestDocument = multiRequestContext.getRequestDocument();
        }
        Element rootElement = null;
        if (null != requestDocument) {
            rootElement = requestDocument.getRootElement();
        }
        Element querySet = null;
        if (null != rootElement) {
            querySet = rootElement.element(QUERY_SET);
        }
        Element modelPath = null;
        if (null != querySet) {
            modelPath = querySet.element(MODELPATH);
        }
        String myPackageName = null;
        if (null != modelPath) {
            myPackageName = this.extractPackageNameFromString(modelPath.getText());
        }
        return myPackageName;
    }

    public void setMigrationBaseVersion(MigrationBaseVersionEnum migrationBaseVersionValue) {
        this.migrationBaseVersion = migrationBaseVersionValue;
    }

    public static MigrationBaseVersionEnum convertMigrationBaseVersion(String migrationBaseVersionValue) {
        MigrationBaseVersionEnum migrateVersion = (MigrationBaseVersionEnum)((Object)MigrationBaseVersionEnum.MIGRATE_BASE_VERSION_LOOKUP.get(migrationBaseVersionValue));
        if (migrateVersion == null) {
            throw new XQERuntimeException(XQEMessageKeys.MIG_InvalidMigrationBaseVersion, migrationBaseVersionValue, SUPPORTED_MIGRATION_BASE_VERSIONS);
        }
        return migrateVersion;
    }

    public MigrationBaseVersionEnum getMigrationBaseVersion() {
        return this.migrationBaseVersion;
    }

    public void setRetrieveDatasets(String[] queryNames) {
        this.retrieveDatasets = queryNames;
    }

    public String[] getRetrieveDatasets(Element rootElement) {
        if (this.retrieveDatasets == null) {
            this.retrieveDatasets = this.getRetrieveDatasetsArray(rootElement);
        }
        return this.retrieveDatasets;
    }

    public void setResultsetFileName(String sResultsetFileName) {
        this.resultsetFileName = sResultsetFileName;
    }

    public String getResultsetFileName() {
        return this.resultsetFileName;
    }

    public void setNLastSavedQuery(int nNewLastSavedQuery) {
        this.nLastSavedQuery = nNewLastSavedQuery;
    }

    public int getNLastSavedQuery() {
        return this.nLastSavedQuery;
    }

    private String[] getRetrieveDatasetsArray(Element rootElement) {
        List retrieveDatasetElements = rootElement.elements(RETRIEVE_DATASET);
        String[] queryResultDefinitionNames = new String[retrieveDatasetElements.size()];
        int retrieveDatasetElementIndex = 0;
        for (Element retrieveDatasetElement : retrieveDatasetElements) {
            queryResultDefinitionNames[retrieveDatasetElementIndex++] = retrieveDatasetElement.attribute(VALUE_ATTRIBUTE).getStringValue();
        }
        return queryResultDefinitionNames;
    }

    @Override
    public String[] getRetrieveDatasets() {
        return this.retrieveDatasets;
    }

    public IMAAttributeTransformer getMAResponseAttributeTransformer() {
        return this.maResponseAttributeTransformer;
    }

    public void setMAResponseAttributeTransformer(IMAAttributeTransformer transformer) {
        this.maResponseAttributeTransformer = transformer;
    }

    public RequestMetrics getRequestMetrics() {
        return this.requestMetrics;
    }

    public void setRequestMetrics(RequestMetrics metrics) {
        this.requestMetrics = metrics;
    }

    @Override
    public IQueryReuseManager getQueryReuseManager() {
        if (this.queryReuseManager == null) {
            this.queryReuseManager = QueryReuseManager.getInstance();
        }
        return this.queryReuseManager;
    }

    public void setUpMFWContextHeader(MFWRequestContext context) {
        if (this.isCMRequestExecutorDefined()) {
            context.setCMRequestExecutor(this.getCMRequestExecutor());
        } else {
            context.setBiBusEnvelope(this.getRequestEnvelope());
        }
    }

    public File getOrCreateReportLogsDir() {
        if (!CollectXQELogs.isLoggingEnabled(this)) {
            return null;
        }
        File logsDir = TraceLogManager.getInstance().getLogDirectory(this);
        ((ExecutionEnvironment)this.getExecutionEnvironment()).getMultiRequestContext().getSessionContext().setReportLogsDir(logsDir);
        return logsDir;
    }

    public void addQueryRequiresReplan(String queryName) {
        ((ExecutionEnvironment)this.mExecutionEnvironment).getMultiRequestContext().addQueryRequiresReplan(queryName);
    }

    public void bindParameter(Parameter parameter) {
        this.boundParameters.add(parameter.getParameterName());
    }

    public void addBoundParameter(String parameter) {
        this.boundParameters.add(parameter);
    }

    @Override
    public Set<String> getBoundParameters() {
        return this.boundParameters;
    }

    public void setSaveResultSet(boolean b) {
        this.bSaveResultSet = b;
    }

    public boolean getSaveResultSet() {
        return this.bSaveResultSet;
    }

    public void setRSVP4J(boolean rsvp4j) {
        this.isRSVP4J = rsvp4j;
    }

    public boolean getRSVP4J() {
        return this.isRSVP4J;
    }

    @Override
    public void setHttpServletRequest(HttpServletRequest servletRequest) {
        this.httpServletRequest = servletRequest;
    }

    @Override
    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public void setMacroInCommandBlocks(boolean macroInCommandBlocks) {
        this.bMacroInCommandBlocks = macroInCommandBlocks;
    }

    public boolean getMacroInCommandBlocks() {
        return this.bMacroInCommandBlocks;
    }

    public static enum MigrationBaseVersionEnum {
        NOT_DEFINED("-1"),
        COMPATIBLE("0"),
        DQM("2");

        String code = "";
        private static final Map<String, MigrationBaseVersionEnum> MIGRATE_BASE_VERSION_LOOKUP;

        private MigrationBaseVersionEnum(String versionCode) {
            this.code = versionCode;
        }

        static {
            MIGRATE_BASE_VERSION_LOOKUP = new HashMap<String, MigrationBaseVersionEnum>();
            for (MigrationBaseVersionEnum v : EnumSet.allOf(MigrationBaseVersionEnum.class)) {
                MIGRATE_BASE_VERSION_LOOKUP.put(v.code, v);
            }
        }
    }
}

