/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler;

import com.cognos.xqe.bibushandler.BaseCubeRequestMetrics;
import com.cognos.xqe.bibushandler.CubeRequestMetrics;
import com.cognos.xqe.bibushandler.VirtualCubeRequestMetrics;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.HighPrecisionStopWatch;
import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RequestMetrics {
    private static final String CUBE_METRICS_SEPARATOR = "\n----";
    private String reportName = null;
    private long requestDuration = 0L;
    private long numberOfBytesReturned = 0L;
    private final ConcurrentMap<String, CubeRequestMetrics> cubeMetricsMap = new ConcurrentHashMap<String, CubeRequestMetrics>();
    private HighPrecisionStopWatch requestTimer;
    private BigInteger bigestSetSize = BigInteger.ZERO;
    private long cubeletsValueCount;

    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String theReportName) {
        this.reportName = theReportName;
    }

    public long getRequestDuration() {
        return this.requestDuration;
    }

    public void setRequestDuration(long theRequestDuration) {
        this.requestDuration = theRequestDuration;
    }

    public long getNumberOfBytesReturned() {
        return this.numberOfBytesReturned;
    }

    public void incrementNumberOfBytesReturned(long bytesReturned) {
        this.numberOfBytesReturned += bytesReturned;
    }

    public Map<String, CubeRequestMetrics> getCubeMetricsMap() {
        return this.cubeMetricsMap;
    }

    public CubeRequestMetrics getCubeMetrics(String cubeName, boolean isVC) {
        CubeRequestMetrics cubeMetrics = (CubeRequestMetrics)this.cubeMetricsMap.get(cubeName);
        if (cubeMetrics == null) {
            if (isVC) {
                this.cubeMetricsMap.putIfAbsent(cubeName, new VirtualCubeRequestMetrics(cubeName));
            } else {
                this.cubeMetricsMap.putIfAbsent(cubeName, new BaseCubeRequestMetrics(cubeName));
            }
            cubeMetrics = (CubeRequestMetrics)this.cubeMetricsMap.get(cubeName);
        }
        return cubeMetrics;
    }

    public CubeRequestMetrics getCubeMetrics(ICube cube) {
        boolean isVC = false;
        if (cube instanceof ROLAPCube) {
            isVC = ((ROLAPCube)cube).isVirtual();
        }
        return this.getCubeMetrics(cube.getName(), isVC);
    }

    public void setRequestTimer(HighPrecisionStopWatch timer) {
        this.requestTimer = timer;
    }

    public HighPrecisionStopWatch getRequestTimer() {
        return this.requestTimer;
    }

    public void setBiggestSetSize(BigInteger setSize) {
        if (setSize == null) {
            return;
        }
        if (setSize.compareTo(this.bigestSetSize) > 0) {
            this.bigestSetSize = setSize;
        }
    }

    public BigInteger getBiggestSetSize() {
        return this.bigestSetSize;
    }

    public void incrementCubeletsValueCount(long inc) {
        this.cubeletsValueCount += inc;
    }

    public long getCubeletsValueCount() {
        return this.cubeletsValueCount;
    }

    public String toString() {
        String formatString = "Total request time %,dms returning %,d bytes for report %s.";
        StringBuilder logMsgText = new StringBuilder(String.format(formatString, this.requestDuration, this.numberOfBytesReturned, this.reportName));
        for (CubeRequestMetrics cubeRequestMetrics : this.cubeMetricsMap.values()) {
            logMsgText.append(CUBE_METRICS_SEPARATOR);
            logMsgText.append(cubeRequestMetrics.toString());
        }
        return logMsgText.toString();
    }

    public static RequestMetrics fromString(String txt) {
        return null;
    }
}

