/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler;

import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQESubConfiguration;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.trace.XQELogger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

class ServiceManager {
    private static final String SERVICES_SERVICE = "Services.service";
    private static final String ATTRIBUTE_TERMINATE = "[@terminate]";
    private static final String ATTRIBUTE_INITIALIZE = "[@initialize]";
    private static final String ATTRIBUTE_CLASS = "[@class]";
    private static final String ATTRIBUTE_NAME = "[@name]";
    private static final String ATTRIBUTE_LOAD = "[@load]";
    private static final String ATTRIBUTE_UNLOAD = "[@unload]";
    private XQEConfiguration config;
    private XQELogger initLogger;
    private XQELogger ipfLogger;
    List<IService> services;

    ServiceManager(XQEConfiguration theConfig, XQELogger theLogger, XQELogger theIpfLogger) {
        this.config = theConfig;
        this.initLogger = theLogger;
        this.ipfLogger = theIpfLogger;
        this.services = new ArrayList<IService>();
    }

    protected void logAndThrowInitializationError(Throwable ex, String serviceId) throws XQERuntimeException {
        this.initLogger.log(LogLevel.ERROR, String.format("Error initializing %s: %s", serviceId, ex));
        this.ipfLogger.log(this.ipfLogger.getDefaultLevel(), OperationEnum.STARTSERVICE_FAILURE, XQEMessageKeys.INI_ErrorDuringInitialization, serviceId);
        throw new XQERuntimeException(XQEMessageKeys.INI_ErrorDuringInitialization, ex, serviceId);
    }

    private IService createSingletonServiceProxy(final String serviceName, final Method activate, final Method deactivate) {
        return new IService(){

            private void invokeMethod(Method method) {
                try {
                    String msg = String.format("calling %s.%s() on behalf of service %s", method.getDeclaringClass().getCanonicalName(), method.getName(), serviceName);
                    ServiceManager.this.ipfLogger.log(LogLevel.TRACE, msg);
                    method.invoke(null, new Object[0]);
                    msg = String.format("%s.%s() called on behalf of service %s", method.getDeclaringClass().getCanonicalName(), method.getName(), serviceName);
                    ServiceManager.this.ipfLogger.log(LogLevel.TRACE, msg);
                }
                catch (IllegalArgumentException ex) {
                    ServiceManager.this.logAndThrowInitializationError(ex, serviceName);
                }
                catch (IllegalAccessException ex) {
                    ServiceManager.this.logAndThrowInitializationError(ex, serviceName);
                }
                catch (InvocationTargetException ex) {
                    ServiceManager.this.logAndThrowInitializationError(ex, serviceName);
                }
            }

            @Override
            public void unload() {
                if (deactivate != null) {
                    this.invokeMethod(deactivate);
                }
            }

            @Override
            public void load() {
                if (activate != null) {
                    this.invokeMethod(activate);
                }
            }
        };
    }

    public void load() {
        if (!this.services.isEmpty()) {
            this.unload();
            this.services.clear();
        }
        this.createServiceWrappers();
        for (IService service : this.services) {
            service.load();
        }
    }

    private void createServiceWrappers() {
        XQESubConfiguration subConfig = this.config.getChildren(SERVICES_SERVICE);
        while (subConfig.hasNext()) {
            subConfig.next();
            if (!subConfig.getBoolean(ATTRIBUTE_LOAD, Boolean.TRUE).booleanValue()) continue;
            String className = subConfig.getString(ATTRIBUTE_CLASS, null);
            if (className == null) {
                throw new XQERuntimeException(new IllegalArgumentException("Missing class name in Services.service[@class]"));
            }
            String activateName = subConfig.getString(ATTRIBUTE_INITIALIZE, "getInstance");
            String deactivateName = null;
            if (subConfig.getBoolean(ATTRIBUTE_UNLOAD, Boolean.TRUE).booleanValue()) {
                deactivateName = subConfig.getString(ATTRIBUTE_TERMINATE, "releaseInstance");
            }
            String serviceName = subConfig.getString(ATTRIBUTE_NAME, "");
            try {
                Class<?> klass = this.getClass().getClassLoader().loadClass(className);
                Method activateMethod = null;
                if (activateName != null) {
                    activateMethod = klass.getMethod(activateName, new Class[0]);
                }
                Method deactivateMethod = null;
                if (deactivateName != null) {
                    deactivateMethod = klass.getMethod(deactivateName, new Class[0]);
                }
                this.services.add(this.createSingletonServiceProxy(serviceName, activateMethod, deactivateMethod));
            }
            catch (ClassNotFoundException ex) {
                this.logAndThrowInitializationError(ex, serviceName);
            }
            catch (SecurityException ex) {
                this.logAndThrowInitializationError(ex, serviceName);
            }
            catch (NoSuchMethodException ex) {
                this.logAndThrowInitializationError(ex, serviceName);
            }
        }
    }

    public void unload() {
        for (IService service : this.services) {
            service.unload();
        }
    }

    static interface IService {
        public void load();

        public void unload();
    }
}

