/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler;

import com.cognos.xqe.bibushandler.CubeRequestMetrics;

public class VirtualCubeRequestMetrics
extends CubeRequestMetrics {
    private long virtualCubeMergeTotalTime = 0L;
    private long virtualCubeNumberOfCellsMerged = 0L;
    private int virtualCubeNumberOfMergeOperations = 0;

    public VirtualCubeRequestMetrics(String theCubeName) {
        super(theCubeName);
    }

    public int getVirtualCubeNumberOfMergeOperations() {
        return this.virtualCubeNumberOfMergeOperations;
    }

    public long getVirtualCubeMergeTotalTime() {
        return this.virtualCubeMergeTotalTime;
    }

    public long getVirtualCubeNumberOfCellsMerged() {
        return this.virtualCubeNumberOfCellsMerged;
    }

    public void incrementVirtualCubeMerge(long timeInMillis, long numCells) {
        this.virtualCubeMergeTotalTime += timeInMillis;
        this.virtualCubeNumberOfCellsMerged += numCells;
        ++this.virtualCubeNumberOfMergeOperations;
    }

    public String toString() {
        String formatString = "VirtualCube %s\nCache threads waited %,dms enqueing cells to the pipelineResultSet.\nResultSetCache: %,d requests in %,dms with %,d hits.\nExpressionCache: %,d requests in %,dms with %,d hits.\nDataCache: %,d requests in %,dms solved %,d (%,d non null) out of %,d tuples.\nVC merge operations: %,d requests in %,dms with %,d cells.";
        String txt = String.format(formatString, this.getCubeName(), this.getTotalPipelineWaitTime(), this.getResultSetCacheNumberOfRequests(), this.getResultSetCacheTotalTime(), this.getResultSetCacheNumberOfHits(), this.getExprCacheNumberOfRequests(), this.getExprCacheTotalTime(), this.getExprCacheNumberOfHits(), this.getDataCacheNumberOfRequests(), this.getDataCacheTotalTime(), this.getDataCacheCellsRequested().subtract(this.getDataCacheCellsNotFound()), this.getDataCacheNonNullCellsSolved(), this.getDataCacheCellsRequested(), this.virtualCubeNumberOfMergeOperations, this.virtualCubeMergeTotalTime, this.virtualCubeNumberOfCellsMerged);
        return txt;
    }
}

