/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler.datasource;

import com.cognos.xqe.bibushandler.datasource.DataSourceConnectionSignon;
import com.cognos.xqe.data.model.ICombinedSignon;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.model.IUserClassIDSignon;
import com.cognos.xqe.data.model.IUsernamePasswordSignon;

public final class CombinedSignon
extends DataSourceConnectionSignon
implements ICombinedSignon {
    private final IDataSourceConnectionSignon[] signons;
    private String userID = null;

    public CombinedSignon(IDataSourceConnectionSignon ... theSignons) {
        super(IDataSourceConnectionSignon.SignonType.COMBINED, null, null);
        this.signons = theSignons;
    }

    @Override
    public IDataSourceConnectionSignon[] getSignons() {
        return this.signons;
    }

    @Override
    public String getUserID() {
        if (this.userID == null) {
            String userName = null;
            String userClassIDs = null;
            for (IDataSourceConnectionSignon signon : this.signons) {
                if (signon.getType() == IDataSourceConnectionSignon.SignonType.USERNAME_PASSWORD) {
                    userName = ((IUsernamePasswordSignon)signon).getUserName();
                    continue;
                }
                if (signon.getType() != IDataSourceConnectionSignon.SignonType.USER_CLASSID) continue;
                userClassIDs = ((IUserClassIDSignon)signon).getUserClassIDS();
            }
            this.userID = userName != null && userName.length() > 0 ? userName : userClassIDs;
        }
        return this.userID;
    }

    @Override
    public boolean equals(Object theOther) {
        if (theOther == null) {
            return false;
        }
        if (this == theOther) {
            return true;
        }
        if (!(theOther instanceof IDataSourceConnectionSignon) || ((IDataSourceConnectionSignon)theOther).getType() != this.getType()) {
            return false;
        }
        return this.getUserID() != null && this.getUserID().equals(((CombinedSignon)theOther).getUserID());
    }

    @Override
    public int hashCode() {
        if (this.getUserID() != null) {
            return this.getUserID().hashCode();
        }
        return 0;
    }
}

