/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler.datasource;

import com.cognos.pogo.util.base64;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.bibushandler.Commands;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.content.ContentManager;
import com.cognos.xqe.bibushandler.content.ICMConnection;
import com.cognos.xqe.bibushandler.content.ICMDataSource;
import com.cognos.xqe.bibushandler.content.ICMSignon;
import com.cognos.xqe.bibushandler.content.ICryptoHandle;
import com.cognos.xqe.bibushandler.datasource.DataSource;
import com.cognos.xqe.bibushandler.datasource.DataSourceCapabilities;
import com.cognos.xqe.bibushandler.datasource.DataSourceConnectionSignon;
import com.cognos.xqe.bibushandler.datasource.UsernamePasswordSignon;
import com.cognos.xqe.data.json.JSONAssemblyHelper;
import com.cognos.xqe.data.model.AmbiguousSignonException;
import com.cognos.xqe.data.model.DataSourceException;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionCommandBlock;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.model.SignonNotFoundException;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.IDataProvider;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.connection.ConnectionStringBuilder;
import com.cognos.xqe.data.providers.relational.TraceRelationalDataProvider;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCDataProvider;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.exception.XQESOAPFaultException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.security.EncryptedObject;
import com.cognos.xqe.security.IEncryptedObject;
import com.cognos.xqe.util.ConnectionUtil;
import com.cognos.xqe.util.FileUtil;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.pool.XQESAXReaderPool;
import com.cognos.xqe.util.reference.IResourceHolder;
import com.cognos.xqebifw.bibushandler.datasource.JCAMImpersonator;
import com.cognos.xqemoser.UserProfileServiceClient;
import com.ibm.bi.org.apache.hadoop.io.CryptoProvider;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.apache.commons.collections.map.Flat3Map;
import org.apache.commons.io.FilenameUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class DataSourceConnection
implements IDataSourceConnection {
    private static final String CLOSE_BRACKET = "]";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String AUTHKEY = "authKey";
    private static final String SECRETKEY = "secretKey";
    private static final String ACCESSTOKEN = "access_token";
    private static final String IDTOKEN = "id_token";
    private static final String SAP_TICKET = "SAPLogonTicket";
    public static final String SKIP_SIGNONS = "SkipSignons";
    private static final String CUBE_PASSWORD = "cubePassword";
    private static final String SEARCH_PATH = "searchPath";
    private static final String NAME = "name";
    private static final String MISS_SPELLED_PSWD_TAG = "</passwrod>";
    private static final String PASSWORD_TAG = "<password>";
    private static final String UTF_8_CHARSET = "UTF-8";
    private static final String URI_DELIMITER_REGEX = Pattern.quote("+");
    private final String name;
    private String searchPath;
    private final String connectionString;
    private final String isolationLevel;
    private final String apiToken;
    private Map<String, IDataSourceConnectionSignon> signons = null;
    private final ReadWriteLock signonsLock = new ReentrantReadWriteLock();
    private final Map<String, Object> connectionParameters = Collections.synchronizedMap(new HashMap());
    protected final DataSource dataSource;
    private IDataSourceConnectionSignon resolvedSignon = null;
    protected DataSourceCapabilities capabilities = null;
    protected static final String DEFAULT_NAME_PROPERTY = "defaultName";
    public static final String DATASOURCE_CREDENTIAL = "DataSourceCredential";
    public static final String V5_CREDENTIAL = "V5Credential";
    public static final String OIDC_CREDENTIAL = "OIDCCredential";
    public static final String API_TOKEN = "ApiToken";
    protected final String namespace;
    private final boolean isAssembly;
    private final List<DataSourceConnection> connectionsAssembly = Collections.synchronizedList(new ArrayList());

    public DataSourceConnection(String theName, String theConnectionString, DataSource theDatasource) {
        this(theName, null, theConnectionString, theDatasource, null, null, null);
    }

    public DataSourceConnection(String theName, String theSearchPath, String theConnectionString, DataSource theDatasource) {
        this(theName, theSearchPath, theConnectionString, theDatasource, null, null, null);
    }

    public DataSourceConnection(String theName, String theSearchPath, String theConnectionString, DataSource theDatasource, String theNamespace, String theIsolationLevel, String theApiToken) {
        this.name = theName;
        this.searchPath = theSearchPath;
        this.connectionString = theConnectionString;
        this.dataSource = theDatasource;
        this.namespace = theNamespace;
        this.isolationLevel = theIsolationLevel;
        this.apiToken = theApiToken;
        this.isAssembly = ConnectionUtil.pointsToAnAssemblyOfConnections(this.connectionString);
    }

    @Override
    public String getConnectionString(IDataSourceConnectionSignon signon) {
        if (null != signon) {
            return ConnectionStringBuilder.substituteSignonInConnectionString(this.connectionString, signon);
        }
        return this.connectionString;
    }

    @Override
    @Deprecated
    public String getConnectionString() {
        return this.getConnectionString(this.resolvedSignon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IDataSourceConnectionSignon getSignon() throws DataSourceException, XQESOAPFaultException {
        if (this.hasResolvedSignon()) {
            return this.resolvedSignon;
        }
        ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (env == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        this.prepareSignons(((RequestEnvironment)env.getRequestEnvironment()).getCAMPassport());
        this.signonsLock.readLock().lock();
        try {
            String signonName = this.getSignonName((IRequestEnvironment)env.getRequestEnvironment(), env.getConnectionElement());
            if (signonName != null) {
                this.resolvedSignon = this.signons.get(signonName);
                if (this.resolvedSignon == null) {
                    if (this.signons.size() != 1) throw new SignonNotFoundException((IDataSource)this.dataSource, signonName, env.getConnectionSearchPath());
                    this.resolvedSignon = this.signons.values().iterator().next();
                }
            } else {
                if (this.signons.isEmpty()) {
                    IDataSourceConnectionSignon iDataSourceConnectionSignon = null;
                    return iDataSourceConnectionSignon;
                }
                int numSignons = this.signons.size();
                if (numSignons > 1) {
                    if (!ROLAPContext.isRelQueryExecuting()) throw new AmbiguousSignonException((IDataSource)this.dataSource, new ArrayList<String>(this.signons.keySet()));
                    for (String signon : this.signons.keySet()) {
                        if (!signon.equalsIgnoreCase("DynamicCubes")) continue;
                        IDataSourceConnectionSignon iDataSourceConnectionSignon = this.signons.get(signon);
                        return iDataSourceConnectionSignon;
                    }
                    throw new AmbiguousSignonException((IDataSource)this.dataSource, new ArrayList<String>(this.signons.keySet()));
                }
                this.resolvedSignon = this.signons.values().iterator().next();
            }
            IDataSourceConnectionSignon iDataSourceConnectionSignon = this.resolvedSignon;
            return iDataSourceConnectionSignon;
        }
        finally {
            this.signonsLock.readLock().unlock();
        }
    }

    public String getSignonName(IRequestEnvironment reqEnv, Element connectionElement) {
        Element actualConnection = this.getConnectionElementWithMatchingDatasourceName(connectionElement);
        if (actualConnection == null) {
            actualConnection = this.getMostNestedConnectionElement(connectionElement);
        }
        String signonName = null;
        Element signonElement = actualConnection.element("signon");
        if (signonElement != null) {
            String signonSearchPath;
            Element searchPathElement;
            Element nameElement = signonElement.element(NAME);
            if (nameElement != null) {
                signonName = nameElement.attributeValue("value");
            }
            if (signonName == null && (searchPathElement = signonElement.element(SEARCH_PATH)) != null && (signonSearchPath = searchPathElement.attributeValue("value")) != null && signonSearchPath.length() > 0) {
                signonName = ContentManager.getSearchPathPropName(reqEnv, signonSearchPath, "dataSourceSignon");
            }
        }
        return signonName;
    }

    @Override
    public String getEncryptedSignon() {
        ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        Object reqEnv = env.getRequestEnvironment();
        ICMDataSource ds = ContentManager.getDataSource(reqEnv, this.dataSource.getCMDataSourceName());
        ICMConnection conn = ds.getConnection(this.getName());
        Collection<ICMSignon> cmSignons = conn.getSignons();
        String signonName = this.getSignonName((IRequestEnvironment)reqEnv, env.getConnectionElement());
        if (cmSignons != null) {
            if (signonName == null && cmSignons.size() == 1) {
                return cmSignons.iterator().next().getCredential();
            }
            for (ICMSignon cmSignon : cmSignons) {
                if (!cmSignon.getDefaultName().equalsIgnoreCase(signonName)) continue;
                return cmSignon.getCredential();
            }
        }
        return null;
    }

    private Element getConnectionElementWithMatchingDatasourceName(Element connectionElement) {
        if (this.dataSource.getName() == null) {
            return null;
        }
        List connections = connectionElement.elements("connection");
        Element connectionToReturn = null;
        if (connections.isEmpty()) {
            Element dataSourceElement = connectionElement.element("dataSource");
            if (dataSourceElement != null && (this.dataSource.getName().equals(dataSourceElement.attributeValue("value")) || this.dataSource.getCMDataSourceName().equals(dataSourceElement.attributeValue("value")))) {
                return connectionElement;
            }
        } else {
            Iterator nestedConnectionIterator = connections.iterator();
            while (connectionToReturn == null && nestedConnectionIterator.hasNext()) {
                connectionToReturn = this.getConnectionElementWithMatchingDatasourceName((Element)nestedConnectionIterator.next());
            }
        }
        return connectionToReturn;
    }

    private Element getMostNestedConnectionElement(Element connectionElement) {
        for (Element nestedconnectionElement = connectionElement.element("connection"); nestedconnectionElement != null; nestedconnectionElement = nestedconnectionElement.element("connection")) {
            if (!this.sameDataSource(nestedconnectionElement)) continue;
            connectionElement = nestedconnectionElement;
        }
        return connectionElement;
    }

    private void populateWithSignonFromV5Spec(ExecutionEnvironment env, String camPassport, DataSource aDataSource) {
        Object reqEnv = env.getRequestEnvironment();
        Element connectionElement = env.getConnectionElement();
        String cmUserName = ContentManager.getUserName(reqEnv);
        Element matchingConnectionElement = this.getConnectionElementWithMatchingDatasourceName(connectionElement);
        connectionElement = matchingConnectionElement != null ? matchingConnectionElement : this.getMostNestedConnectionElement(connectionElement);
        String userName = null;
        EncryptedObject<String> password = null;
        EncryptedObject<String> cubePassword = null;
        try {
            Element userNameElement = connectionElement.element(USERNAME);
            if (userNameElement != null) {
                userName = userNameElement.attributeValue("value");
            }
            Element cubePasswordElement = connectionElement.element(CUBE_PASSWORD);
            Element passwordElement = connectionElement.element(PASSWORD);
            if (cubePasswordElement != null) {
                passwordElement = cubePasswordElement;
            }
            if (passwordElement != null) {
                Element encryptedPswdElement;
                password = passwordElement.attributeValue("value") == null || passwordElement.attributeValue("value").length() == 0 ? ((encryptedPswdElement = passwordElement.element("encryptedValue")) != null ? (encryptedPswdElement.attributeValue("value") != null && encryptedPswdElement.attributeValue("value").length() > 0 ? EncryptedObject.fromProtectedUTF8(base64.decode((int)0, (String)encryptedPswdElement.attributeValue("value"))) : new EncryptedObject()) : new EncryptedObject<String>()) : new EncryptedObject<String>(passwordElement.attributeValue("value").toString());
            }
            if (cubePasswordElement != null) {
                cubePassword = password;
                password = null;
            }
        }
        catch (Exception ex) {
            throw new XQERuntimeException(XQEMessageKeys.DS_UnableToDecryptDataSourceSignon, (Throwable)ex);
        }
        IDataSourceConnectionSignon signon = DataSourceConnectionSignon.createSignon(aDataSource.getType(), V5_CREDENTIAL, null, userName, password, null, cmUserName, cubePassword, null, null, null);
        if (signon != null) {
            this.signons.put(DEFAULT_NAME_PROPERTY, signon);
        }
    }

    private void populateWithSignonFromPersonalDSCredentials(IRequestEnvironment reqEnv, String camPassport) {
        IDataSourceConnectionSignon signon = this.getSignonFromUPS(camPassport, reqEnv, this.dataSource);
        if (signon != null) {
            this.signons.put(DEFAULT_NAME_PROPERTY, signon);
        }
    }

    private void populateWithSignonsFromDSConnection(IRequestEnvironment reqEnv, String camPassport) {
        Collection<ICMSignon> cmSignons;
        ICMDataSource ds = ContentManager.getDataSource(reqEnv, this.dataSource.getCMDataSourceName());
        ICMConnection conn = ds.getConnection(this.getName());
        IDataSourceConnectionSignon signon = null;
        if (!(DataSourceTypeEnum.isTM(this.dataSource.getType()) && this.getConnectionParameter(SKIP_SIGNONS) != null || (cmSignons = conn.getSignons()) == null)) {
            for (ICMSignon cmSignon : cmSignons) {
                signon = DataSourceConnection.decryptSignon(this.dataSource.getType(), cmSignon.getDefaultName(), cmSignon.getSearchPath(), cmSignon.getCredential(), ds.getCryptoHandle(), camPassport, this.connectionString, ds.getDelegatedCredential());
                if (signon == null) continue;
                this.signons.put(cmSignon.getDefaultName(), signon);
            }
        }
    }

    private void populateWithSignonFromApiToken() {
        Credentials creds = DataSourceConnection.retrieveCredentials(this.apiToken);
        IDataSourceConnectionSignon signon = DataSourceConnectionSignon.createSignon(null, null, null, null, null, null, null, null, null, null, null, null, null, null, creds.getAuthKey(), creds.getSecretKey());
        if (signon != null) {
            this.signons.put(signon.getName(), signon);
        }
    }

    private boolean sameDataSource(Element nestedConnection) {
        Element datasourceElement = nestedConnection.element("dataSource");
        return datasourceElement != null && this.dataSource.getCMDataSourceName().equals(datasourceElement.attributeValue("value"));
    }

    private void prepareSignons(String camPassport) {
        ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (env == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        this.signonsLock.writeLock().lock();
        try {
            Object reqEnv = env.getRequestEnvironment();
            if (this.signons == null) {
                this.signons = new Flat3Map();
                this.populateWithSignonFromV5Spec(env, camPassport, this.dataSource);
                if (this.signons.isEmpty()) {
                    this.populateWithSignonsFromDSConnection((IRequestEnvironment)reqEnv, camPassport);
                }
                if (this.signons.isEmpty()) {
                    this.populateWithSignonFromPersonalDSCredentials((IRequestEnvironment)reqEnv, camPassport);
                }
                if (this.signons.isEmpty() && null != this.apiToken) {
                    this.populateWithSignonFromApiToken();
                }
            }
        }
        catch (XQERuntimeException rte) {
            if (rte.getMessageKey() != XQEMessageKeys.DS_DataSourceNotFound) {
                throw rte;
            }
        }
        catch (Throwable ex) {
            throw new XQERuntimeException(XQEMessageKeys.DS_UnableToRetrieveDataSourceSignons, ex, (Object)this.getName(), (Object)this.dataSource.getCMDataSourceName());
        }
        finally {
            this.signonsLock.writeLock().unlock();
        }
    }

    private IDataSourceConnectionSignon getSignonFromUPS(String camPassport, IRequestEnvironment reqEnv, DataSource ds) {
        IDataSourceConnectionSignon signon = null;
        try {
            UserProfileServiceClient upsClient = new UserProfileServiceClient(camPassport, reqEnv.getCookies());
            String[] encryptedCredential = upsClient.getPersonalDataSourceCredential(this.dataSource.getCMDataSourceName(), this.getName());
            if (encryptedCredential != null) {
                String encryptedXML = "<credential><encryptedValue>" + encryptedCredential[1] + "</encryptedValue></credential>";
                String signonSearchPath = "storeID(\"" + encryptedCredential[0] + "\")";
                signon = DataSourceConnection.decryptSignon(this.dataSource.getType(), DATASOURCE_CREDENTIAL, signonSearchPath, encryptedXML, null, camPassport, this.connectionString, null);
                if (signon != null) {
                    this.signons.put(DEFAULT_NAME_PROPERTY, signon);
                    return signon;
                }
            }
        }
        catch (Exception ex) {
            throw new XQERuntimeException(XQEMessageKeys.DS_UnableToDecryptDataSourceSignon, (Throwable)ex);
        }
        return signon;
    }

    @Override
    public List<IDataSourceConnectionCommandBlock> getCommandBlock(Commands key) {
        ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (env == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        RequestEnvironment reqEnv = (RequestEnvironment)env.getRequestEnvironment();
        try {
            return ContentManager.getDataSource(reqEnv, this.getDataSource().getCMDataSourceName()).getConnection(this.getName()).getCommandBlocks(reqEnv, reqEnv.getRunLocale(), key);
        }
        catch (XQERuntimeException rte) {
            if (rte.getMessageKey() == XQEMessageKeys.DS_DataSourceNotFound) {
                return null;
            }
            throw rte;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getIsolationLevel() {
        return this.isolationLevel;
    }

    @Override
    public String getApiToken() {
        return this.apiToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element asXML() {
        Element connectionElement = DocumentHelper.createElement((String)"connection");
        Element nameElement = connectionElement.addElement(NAME);
        nameElement.addAttribute("value", this.name);
        Element searchPathElement = connectionElement.addElement(SEARCH_PATH);
        searchPathElement.addAttribute("value", this.searchPath);
        if (this.signons != null) {
            this.signonsLock.readLock().lock();
            try {
                for (IDataSourceConnectionSignon aSignon : this.signons.values()) {
                    connectionElement.add(aSignon.asXML());
                }
            }
            finally {
                this.signonsLock.readLock().unlock();
            }
        }
        return connectionElement;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getConnectionParameter(String key) {
        Map<String, Object> map = this.connectionParameters;
        synchronized (map) {
            return this.connectionParameters.get(key);
        }
    }

    @Override
    public void setConnectionParameter(String key, Object value) {
        this.connectionParameters.put(key, value);
    }

    public static Credentials retrieveCredentials(String encryptedXML) {
        return DataSourceConnection.retrieveCredentials(encryptedXML, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Credentials retrieveCredentials(String encryptedXML, String aNamespace) {
        Document doc;
        SAXReader reader;
        if (encryptedXML == null) {
            throw new XQERuntimeException(XQEMessageKeys.DS_UnableToParseDataSourceSignon);
        }
        String username = null;
        EncryptedObject<String> password = null;
        String sapTicket = null;
        EncryptedObject<String> cubePassword = null;
        String namespace = aNamespace;
        EncryptedObject<String> accessToken = null;
        EncryptedObject<String> idToken = null;
        EncryptedObject<String> authKey = null;
        EncryptedObject<String> secretKey = null;
        XQESAXReaderPool pool = XQESAXReaderPool.getInstance();
        String base64EncodedString = null;
        try {
            reader = pool.borrowReader();
            try {
                doc = reader.read((Reader)new StringReader(encryptedXML));
                Element encryptedValueElement = doc.getRootElement().element("encryptedValue");
                base64EncodedString = encryptedValueElement.getText();
            }
            finally {
                pool.returnReader(reader);
            }
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.DS_UnableToParseDataSourceSignon, (Throwable)e);
        }
        if (base64EncodedString == null) {
            throw new XQERuntimeException(XQEMessageKeys.DS_UnableToParseDataSourceSignon);
        }
        byte[] data = base64.decode((int)0, (String)base64EncodedString);
        String decryptedCredentials = null;
        try {
            data = CryptoProvider.decrypt((byte[])data);
            decryptedCredentials = new String(data, UTF_8_CHARSET);
        }
        catch (Exception ex) {
            throw new XQERuntimeException(XQEMessageKeys.DS_UnableToDecryptDataSourceSignon, (Throwable)ex);
        }
        String validdecryptedCredentials = decryptedCredentials;
        try {
            reader = pool.borrowReader();
            try {
                Element secretKeyElement;
                Element authKeyElement;
                Element idTokenElement;
                Element accesTokenElement;
                Element namespaceElement;
                Element cubePasswordElement;
                Element sapTicketElement;
                Element passwordElement;
                Element credentialsElement;
                Element usernameElement;
                if (decryptedCredentials.contains(MISS_SPELLED_PSWD_TAG)) {
                    validdecryptedCredentials = decryptedCredentials.replace(MISS_SPELLED_PSWD_TAG, PASSWORD_TAG);
                }
                if ((usernameElement = (credentialsElement = (doc = reader.read((Reader)new StringReader(validdecryptedCredentials))).getRootElement()).element(USERNAME)) != null) {
                    username = usernameElement.getText();
                }
                if ((passwordElement = credentialsElement.element(PASSWORD)) != null) {
                    password = new EncryptedObject<String>(passwordElement.getText());
                }
                if ((sapTicketElement = credentialsElement.element(SAP_TICKET)) != null) {
                    sapTicket = sapTicketElement.getText();
                }
                if ((cubePasswordElement = credentialsElement.element(CUBE_PASSWORD)) != null) {
                    cubePassword = new EncryptedObject<String>(cubePasswordElement.getText());
                }
                if ((namespaceElement = credentialsElement.element("namespace")) != null) {
                    namespace = namespaceElement.getText();
                }
                if ((accesTokenElement = credentialsElement.element(ACCESSTOKEN)) != null) {
                    accessToken = new EncryptedObject<String>(accesTokenElement.getText());
                }
                if ((idTokenElement = credentialsElement.element(IDTOKEN)) != null) {
                    idToken = new EncryptedObject<String>(idTokenElement.getText());
                }
                if ((authKeyElement = credentialsElement.element(AUTHKEY)) != null) {
                    authKey = new EncryptedObject<String>(authKeyElement.getText());
                }
                if ((secretKeyElement = credentialsElement.element(SECRETKEY)) != null) {
                    secretKey = new EncryptedObject<String>(secretKeyElement.getText());
                }
            }
            finally {
                pool.returnReader(reader);
            }
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.DS_UnableToParseDataSourceSignon, (Throwable)e);
        }
        return new Credentials(username, password, sapTicket, cubePassword, namespace, accessToken, idToken, authKey, secretKey);
    }

    public static IDataSourceConnectionSignon decryptSignon(String providerType, String defaultName, String path, String encryptedXML, IResourceHolder<? extends ICryptoHandle> cryptoHandleRef, String camPassport, String connectionString, JCAMImpersonator.DelegatedCredential delegatedCredential) {
        ExecutionEnvironment env;
        if (encryptedXML == null) {
            throw new XQERuntimeException(XQEMessageKeys.DS_UnableToParseDataSourceSignon);
        }
        Credentials credentials = DataSourceConnection.retrieveCredentials(encryptedXML);
        IDataSourceConnectionSignon r = DataSourceConnectionSignon.createSignon(providerType, defaultName, path, credentials, ContentManager.getUserName((env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment()).getRequestEnvironment()), cryptoHandleRef, connectionString, delegatedCredential);
        if (r != null && r instanceof UsernamePasswordSignon && DataSourceTypeEnum.isJDBC(providerType)) {
            IDataProvider provider = ProviderManager.getInstance().getProvider(providerType);
            if (provider instanceof TraceRelationalDataProvider) {
                provider = ((TraceRelationalDataProvider)provider).getProvider();
            }
            if (provider instanceof JDBCDataProvider) {
                ((JDBCDataProvider)provider).registerCredentialToDBUser(encryptedXML, credentials.username);
            }
        }
        return r;
    }

    @Override
    public String getSearchPath() {
        return this.searchPath;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean hasResolvedSignon() {
        return this.resolvedSignon != null;
    }

    public boolean signonInInvalidState() {
        return this.signons != null && this.signons.isEmpty() && this.resolvedSignon == null;
    }

    @Override
    public void invalidateResolvedSignon() {
        this.signonsLock.writeLock().lock();
        try {
            this.resolvedSignon = null;
            this.signons = null;
        }
        finally {
            this.signonsLock.writeLock().unlock();
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("DataSourceConnection[name=").append(this.getName());
        buffer.append(", connectionString=").append(this.getConnectionString(null));
        buffer.append(CLOSE_BRACKET);
        return buffer.toString();
    }

    private ICMConnection getCMConnection() {
        ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (env == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        return ContentManager.getConnection(env.getRequestEnvironment(), this.getDataSource().getCMDataSourceName(), this.name);
    }

    @Override
    public String getUserGroups() {
        String userGroups = null;
        ICMConnection cs = this.getCMConnection();
        if (null == cs) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "CM connection missing.");
        }
        userGroups = cs.getUserGroups();
        return userGroups;
    }

    @Override
    public void setUserGroups(String userGroups) {
        ICMConnection cs = this.getCMConnection();
        if (null == cs) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "CM connection missing");
        }
        cs.setUserGroups(userGroups);
    }

    public void setSignons(Map<String, IDataSourceConnectionSignon> newSignons) {
        this.signonsLock.writeLock().lock();
        try {
            this.signons = newSignons;
        }
        finally {
            this.signonsLock.writeLock().unlock();
        }
    }

    @Override
    public String getDBUserNameFromConnectionElementOrCredential() {
        ICMDataSource cmDS;
        if (!DataSourceTypeEnum.isJDBC(this.dataSource.getType())) {
            return null;
        }
        IDataProvider provider = ProviderManager.getInstance().getProvider(this.dataSource.getType());
        if (provider instanceof TraceRelationalDataProvider) {
            provider = ((TraceRelationalDataProvider)provider).getProvider();
        }
        if (!(provider instanceof JDBCDataProvider)) {
            return null;
        }
        if (this.resolvedSignon != null) {
            if (this.resolvedSignon instanceof UsernamePasswordSignon) {
                return ((UsernamePasswordSignon)this.resolvedSignon).getUserName();
            }
            return null;
        }
        ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (env == null) {
            return null;
        }
        if ((DataSourceTypeEnum.isMicrosoft(this.dataSource.getType()) || DataSourceTypeEnum.supportsJavaKerberos(this.dataSource.getType(), this.connectionString)) && (cmDS = ContentManager.getDataSource(env.getRequestEnvironment(), this.dataSource.getCMDataSourceName())).getCryptoHandle() != null) {
            return null;
        }
        Element connnectionElement = env.getConnectionElement();
        Element matchingConnectionElement = this.getConnectionElementWithMatchingDatasourceName(connnectionElement);
        connnectionElement = matchingConnectionElement != null ? matchingConnectionElement : this.getMostNestedConnectionElement(connnectionElement);
        Element userNameElement = connnectionElement.element(USERNAME);
        if (userNameElement != null) {
            return userNameElement.attributeValue("value");
        }
        if (this.getConnectionParameter(SKIP_SIGNONS) != null) {
            return null;
        }
        ICMDataSource cmDS2 = ContentManager.getDataSource(env.getRequestEnvironment(), this.dataSource.getCMDataSourceName());
        ICMConnection cmConn = cmDS2.getConnection(this.getName());
        Collection<ICMSignon> cmSignons = cmConn.getSignons();
        if (cmSignons.isEmpty()) {
            return null;
        }
        if (cmSignons.size() == 1) {
            return ((JDBCDataProvider)provider).getDBUserFromCredential(cmSignons.iterator().next().getCredential());
        }
        String signonName = this.getSignonName((IRequestEnvironment)env.getRequestEnvironment(), env.getConnectionElement());
        if (signonName != null) {
            for (ICMSignon cmSignon : cmSignons) {
                if (!signonName.equals(cmSignon.getDefaultName())) continue;
                return ((JDBCDataProvider)provider).getDBUserFromCredential(cmSignon.getCredential());
            }
        }
        return null;
    }

    @Override
    public boolean isModelConnection() {
        return true;
    }

    public boolean isAssemblyOfConnections() {
        return this.isAssembly;
    }

    public List<DataSourceConnection> getAssemblyOfConnections() {
        return this.connectionsAssembly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryExpand() {
        List<DataSourceConnection> list = this.connectionsAssembly;
        synchronized (list) {
            if (this.isAssemblyOfConnections() && this.connectionsAssembly.isEmpty()) {
                String[] uris;
                String[] uriKeyValue = ConnectionUtil.extractKeyValuePair(this.connectionString, "URL");
                if (MacroExpander.containsPound(uriKeyValue[1])) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_UnsupportedAssemblyURLWithMacros, uriKeyValue[1]);
                }
                for (String uri : uris = uriKeyValue[1].split(URI_DELIMITER_REGEX)) {
                    if (uri.startsWith("file://")) {
                        String fileExt = FilenameUtils.getExtension((String)uri);
                        FileUtil.FileType assemblyType = FileUtil.FileType.valueOf(fileExt.toUpperCase());
                        switch (assemblyType) {
                            case JSON: {
                                this.populateAssemblyOfConnections(JSONAssemblyHelper.getJSONAssemblyHelper(this));
                                break;
                            }
                            case XML: {
                                throw new UnsupportedOperationException("XML assembly files are not supported.");
                            }
                            default: {
                                throw new UnsupportedOperationException("Assembly files of type UNKNOWN are not supported.");
                            }
                        }
                        continue;
                    }
                    throw new UnsupportedOperationException("Only FILE protocol is supported for Assembly URIs.");
                }
            }
        }
    }

    private void populateAssemblyOfConnections(JSONAssemblyHelper jsonAssemblyHelper) {
        JSONArray datasets = jsonAssemblyHelper.getDatasets();
        for (int i = 0; i < datasets.size(); ++i) {
            JSONObject dataset = (JSONObject)datasets.get(i);
            StringBuilder newConnectionString = new StringBuilder(ConnectionUtil.generateConnectionString(jsonAssemblyHelper, dataset));
            String[] newSubtypeKVPair = ConnectionUtil.extractKeyValuePair(newConnectionString.toString(), "SUBTYPE");
            String[] currSubtypeKVPair = ConnectionUtil.extractKeyValuePair(this.connectionString, "SUBTYPE");
            if (newSubtypeKVPair == null && currSubtypeKVPair != null) {
                newConnectionString.append(';');
                newConnectionString.append("SUBTYPE");
                newConnectionString.append("=");
                newConnectionString.append(currSubtypeKVPair[1]);
            }
            DataSourceConnection dsConnection = new DataSourceConnection(jsonAssemblyHelper.getDatasetName(dataset), newConnectionString.toString(), this.getDataSource());
            this.connectionsAssembly.add(dsConnection);
        }
    }

    public static class Credentials {
        private final String username;
        private final IEncryptedObject<String> password;
        private final String sapTicket;
        private final IEncryptedObject<String> cubePassword;
        private final String namespace;
        private final IEncryptedObject<String> accessToken;
        private final IEncryptedObject<String> idToken;
        private final IEncryptedObject<String> authKey;
        private final IEncryptedObject<String> secretKey;

        Credentials(String un, IEncryptedObject<String> pw, String st, IEncryptedObject<String> cpwd, String ns, IEncryptedObject<String> at, IEncryptedObject<String> it, IEncryptedObject<String> ak, IEncryptedObject<String> sk) {
            this.username = un;
            this.password = pw;
            this.sapTicket = st;
            this.cubePassword = cpwd;
            this.namespace = ns;
            this.accessToken = at;
            this.idToken = it;
            this.authKey = ak;
            this.secretKey = sk;
        }

        public String getUsername() {
            return this.username;
        }

        public IEncryptedObject<String> getPassword() {
            return this.password;
        }

        public String getSapTicket() {
            return this.sapTicket;
        }

        public IEncryptedObject<String> getCubePassword() {
            return this.cubePassword;
        }

        public String getNameSpace() {
            return this.namespace;
        }

        public IEncryptedObject<String> getAccessToken() {
            return this.accessToken;
        }

        public IEncryptedObject<String> getIdToken() {
            return this.idToken;
        }

        public IEncryptedObject<String> getAuthKey() {
            return this.authKey;
        }

        public IEncryptedObject<String> getSecretKey() {
            return this.secretKey;
        }
    }
}

