/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler.datasource;

import com.cognos.xqe.bibushandler.Commands;
import com.cognos.xqe.bibushandler.datasource.UsernamePasswordSignon;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionCommandBlock;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.providers.connection.ConnectionStringBuilder;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.security.IEncryptedObject;
import com.cognos.xqe.util.pool.XQESAXReaderPool;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public final class DataSourceConnectionFromFile
implements IDataSourceConnection {
    private String name;
    private String connectionString;
    private File connectionsFile;
    private ExecutionEnvironment environment;
    private HashMap<String, Object> connectionParameters;
    private String userGroups;
    private IDataSourceConnectionSignon signon;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataSourceConnectionFromFile(String theName, File theConnectionsFile) {
        this.name = theName;
        this.connectionsFile = theConnectionsFile;
        this.connectionParameters = new HashMap();
        this.connectionString = null;
        this.userGroups = "";
        XQESAXReaderPool pool = XQESAXReaderPool.getInstance();
        try {
            SAXReader reader = pool.borrowReader();
            try {
                Document doc = reader.read((InputStream)new BufferedInputStream(new FileInputStream(this.connectionsFile)));
                Element directoryNode = doc.getRootElement().element("directory");
                List databaseElements = directoryNode.elements("database");
                for (Element databaseElement : databaseElements) {
                    String databaseName = databaseElement.attributeValue("name");
                    if (databaseName.compareToIgnoreCase(this.name) != 0) continue;
                    this.connectionString = databaseElement.attributeValue("connectionString");
                    Element connectionElement = databaseElement.element("connection");
                    if (connectionElement != null) {
                        Element signonElement = connectionElement.element("signon");
                        String userName = signonElement.attributeValue("dbUserId");
                        String password = signonElement.attributeValue("dbPassword");
                        this.signon = new UsernamePasswordSignon(userName, new EncryptedPassword(password));
                    }
                    break;
                }
            }
            finally {
                pool.returnReader(reader);
            }
        }
        catch (Exception ex) {
            throw new XQERuntimeException(XQEMessageKeys.DS_UnableToRetrieveDataSourceConnections, (Throwable)ex, this.name);
        }
    }

    @Override
    public String getConnectionString(IDataSourceConnectionSignon aSignon) {
        return ConnectionStringBuilder.substituteSignonInConnectionString(this.connectionString, aSignon);
    }

    @Override
    public String getConnectionString() {
        return this.getConnectionString(null);
    }

    public ExecutionEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    public IDataSourceConnectionSignon getSignon() {
        return this.signon;
    }

    @Override
    public Object getConnectionParameter(String key) {
        return this.connectionParameters.get(key);
    }

    @Override
    public void setConnectionParameter(String key, Object value) {
        this.connectionParameters.put(key, value);
    }

    @Override
    public List<IDataSourceConnectionCommandBlock> getCommandBlock(Commands key) {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getIsolationLevel() {
        return null;
    }

    @Override
    public String getApiToken() {
        return null;
    }

    @Override
    public String getSearchPath() {
        return null;
    }

    @Override
    public String getNamespace() {
        return null;
    }

    @Override
    public Element asXML() {
        Element connectionElement = DocumentHelper.createElement((String)"connection");
        Element nameElement = connectionElement.addElement("name");
        nameElement.addAttribute("value", this.name);
        return connectionElement;
    }

    @Override
    public boolean hasResolvedSignon() {
        return false;
    }

    @Override
    public void invalidateResolvedSignon() {
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("DataSourceConnectionFromFile[name=").append(this.getName());
        buffer.append(", connectionString=").append(this.getConnectionString(null));
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public String getUserGroups() {
        return this.userGroups;
    }

    @Override
    public void setUserGroups(String newUserGroups) {
        this.userGroups = newUserGroups;
    }

    @Override
    public boolean isModelConnection() {
        return false;
    }

    @Override
    public String getEncryptedSignon() {
        return null;
    }

    @Override
    public String getDBUserNameFromConnectionElementOrCredential() {
        return null;
    }

    private class EncryptedPassword
    implements IEncryptedObject<String> {
        private String object;

        EncryptedPassword(String theObject) {
            this.object = theObject;
        }

        @Override
        public String decrypt() {
            return this.object;
        }

        @Override
        public boolean hasValue() {
            return true;
        }

        @Override
        public byte[] getSecureData() {
            return this.object.getBytes();
        }
    }
}

