/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler.datasource;

import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.trace.XQEDebugLog;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;

public class PropertiesDataTypeMask {
    public static final long BINARY_TYPE_MASK = 1L;
    public static final long CLOB_TYPE_MASK = 2L;
    public static final long BLOB_TYPE_MASK = 6L;
    public static final long BOOLEAN_TYPE_MASK = 8L;
    public static final long ROW_TYPE_MASK = 16L;
    public static final long ARRAY_TYPE_MASK = 32L;
    public static final long MULTISET_TYPE_MASK = 64L;
    public static final long COLLECTION_TYPE_MASK = 112L;
    public static final long DATE_TYPE_MASK = 256L;
    public static final long TIME_TYPE_MASK = 512L;
    public static final long TIME_WITH_TIME_ZONE_TYPE_MASK = 1024L;
    public static final long TIMESTAMP_TYPE_MASK = 2048L;
    public static final long TIMESTAMP_WITH_TIME_ZONE_TYPE_MASK = 4096L;
    public static final long PERIOD_TYPE_MASK = 8192L;
    public static final long DATETIME_TYPE_MASK = 16128L;
    public static final long INTERVAL_DAY_TYPE_MASK = 65536L;
    public static final long INTERVAL_DAY_TO_HOUR_TYPE_MASK = 131072L;
    public static final long INTERVAL_DAY_TO_MINUTE_TYPE_MASK = 262144L;
    public static final long INTERVAL_DAY_TO_SECOND_TYPE_MASK = 524288L;
    public static final long INTERVAL_HOUR_TYPE_MASK = 0x100000L;
    public static final long INTERVAL_HOUR_TO_MINUTE_TYPE_MASK = 0x200000L;
    public static final long INTERVAL_HOUR_TO_SECOND_TYPE_MASK = 0x400000L;
    public static final long INTERVAL_MINUTE_TYPE_MASK = 0x800000L;
    public static final long INTERVAL_MINUTE_TO_SECOND_TYPE_MASK = 0x1000000L;
    public static final long INTERVAL_SECOND_TYPE_MASK = 0x2000000L;
    public static final long INTERVAL_DAY_TIME_TYPE_MASK = 0x3FF0000L;
    public static final long INTERVAL_YEAR_TYPE_MASK = 0x4000000L;
    public static final long INTERVAL_YEAR_TO_MONTH_TYPE_MASK = 0x8000000L;
    public static final long INTERVAL_MONTH_TYPE_MASK = 0x10000000L;
    public static final long INTERVAL_YEAR_MONTH_TYPE_MASK = 0x1C000000L;
    public static final long DECIMAL_TYPE_MASK = 0x100000000L;
    public static final long INTEGER_TYPE_MASK = 0x200000000L;
    public static final long LEVELNUMBER_TYPE_MASK = 0x400000000L;
    public static final long LONG_TYPE_MASK = 0x800000000L;
    public static final long SMALLINT_TYPE_MASK = 0x1000000000L;
    public static final long EXACT_NUMERIC_TYPE_MASK = 0xFF00000000L;
    public static final long DOUBLE_TYPE_MASK = 0x10000000000L;
    public static final long FLOAT_TYPE_MASK = 0x20000000000L;
    public static final long NUMERIC_TYPE_MASK = 0x7FF00000000L;
    public static final long VARIANT_TYPE_MASK = 0x80000000000L;
    public static final long CHAR_TYPE_MASK = 0x100000000000L;
    public static final long NCHAR_TYPE_MASK = 0x200000000000L;
    public static final long NVARCHAR_TYPE_MASK = 0x400000000000L;
    public static final long STRING_TYPE_MASK = 0x800000000000L;
    public static final long VARCHAR_TYPE_MASK = 0x1000000000000L;
    public static final long XML_TYPE_MASK = 0x2000000000000L;
    public static final long TEXT_TYPE_MASK = 0xFFFF00000000000L;
    public static final long JSON_TYPE_MASK = 0x8000000000000L;
    public static final long MEMBER_TYPE_MASK = 0x4000000000000L;
    public static final long NULL_TYPE_MASK = 0x1000000000000000L;
    public static final long NULLARG_TYPE_MASK = 0x4000000000000000L;
    public static final long DATALINK_TYPE_MASK = 0x2000000000000000L;
    public static final long ANY_TYPE_MASK = Long.MAX_VALUE;
    private static final String SPACE_CHAR = " ";
    private static final String UNDERSCORE = "_";
    private static HashMap<String, Long> dataTypeMaskMap = new HashMap();

    public static long getDataTypeMask(String name) {
        name = StringUtils.replace((String)name, (String)SPACE_CHAR, (String)UNDERSCORE);
        long mask = 0L;
        if (dataTypeMaskMap.get(name) != null) {
            mask = dataTypeMaskMap.get(name);
        } else {
            XQEDebugLog.out.println("Invalid data type defined in property file : " + name);
        }
        return mask;
    }

    static {
        dataTypeMaskMap.put("binary", 1L);
        dataTypeMaskMap.put("clob", 2L);
        dataTypeMaskMap.put("blob", 6L);
        dataTypeMaskMap.put("boolean", 8L);
        dataTypeMaskMap.put("row", 16L);
        dataTypeMaskMap.put("array", 32L);
        dataTypeMaskMap.put("multiset", 64L);
        dataTypeMaskMap.put(DataSubType.COLLECTIONTYPE.getDataSubTypeName(), 112L);
        dataTypeMaskMap.put("date", 256L);
        dataTypeMaskMap.put("time", 512L);
        dataTypeMaskMap.put("time_with_time_zone", 1024L);
        dataTypeMaskMap.put("timestamp", 2048L);
        dataTypeMaskMap.put("timestamp_with_time_zone", 4096L);
        dataTypeMaskMap.put("period", 8192L);
        dataTypeMaskMap.put(DataSubType.DATETIMETYPE.getDataSubTypeName(), 16128L);
        dataTypeMaskMap.put("interval_day", 65536L);
        dataTypeMaskMap.put("interval_day_to_hour", 131072L);
        dataTypeMaskMap.put("interval_day_to_minute", 262144L);
        dataTypeMaskMap.put("interval_day_to_second", 524288L);
        dataTypeMaskMap.put("interval_hour", 0x100000L);
        dataTypeMaskMap.put("interval_hour_to_minute", 0x200000L);
        dataTypeMaskMap.put("interval_hour_to_second", 0x400000L);
        dataTypeMaskMap.put("interval_minute", 0x800000L);
        dataTypeMaskMap.put("interval_minute_to_second", 0x1000000L);
        dataTypeMaskMap.put("interval_second", 0x2000000L);
        dataTypeMaskMap.put("interval_day_time", 0x3FF0000L);
        dataTypeMaskMap.put("interval_year", 0x4000000L);
        dataTypeMaskMap.put("interval_year_to_month", 0x8000000L);
        dataTypeMaskMap.put("interval_month", 0x10000000L);
        dataTypeMaskMap.put("interval_year_month", 0x1C000000L);
        dataTypeMaskMap.put("decimal", 0x100000000L);
        dataTypeMaskMap.put("double", 0x10000000000L);
        dataTypeMaskMap.put("float", 0x20000000000L);
        dataTypeMaskMap.put("integer", 0x200000000L);
        dataTypeMaskMap.put("levelNumber", 0x400000000L);
        dataTypeMaskMap.put("long", 0x800000000L);
        dataTypeMaskMap.put("smallint", 0x1000000000L);
        dataTypeMaskMap.put(DataSubType.NUMERICTYPE.getDataSubTypeName(), 0x7FF00000000L);
        dataTypeMaskMap.put("exact", 0xFF00000000L);
        dataTypeMaskMap.put("variant", 0x80000000000L);
        dataTypeMaskMap.put("char", 0x100000000000L);
        dataTypeMaskMap.put("nchar", 0x200000000000L);
        dataTypeMaskMap.put("nvarchar", 0x400000000000L);
        dataTypeMaskMap.put("string", 0x800000000000L);
        dataTypeMaskMap.put("varchar", 0x1000000000000L);
        dataTypeMaskMap.put("xml", 0x2000000000000L);
        dataTypeMaskMap.put("json", 0x8000000000000L);
        dataTypeMaskMap.put("datalink", 0x2000000000000000L);
        dataTypeMaskMap.put("member", 0x4000000000000L);
        dataTypeMaskMap.put(DataSubType.TEXTTYPE.getDataSubTypeName(), 0xFFFF00000000000L);
        dataTypeMaskMap.put("null", 0x1000000000000000L);
        dataTypeMaskMap.put("nullArg", 0x4000000000000000L);
        dataTypeMaskMap.put("any", Long.MAX_VALUE);
    }
}

