/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler.recorder;

import com.cognos.mfw4j.utilities.ThreadSafeDateFormat;
import com.cognos.xqe.bibushandler.recorder.EventLog;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public final class Session
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String XML_ELEM_SESSION = "session";
    private static final String XML_ATTR_END_DATE = "endDate";
    private static final String XML_ATTR_FAULT_COUNT = "faultCount";
    private static final String XML_ATTR_REQUEST_COUNT = "requestCount";
    private static final String XML_ATTR_SESSION_ID = "sessionId";
    private static final String XML_ATTR_START_DATE = "startDate";
    protected static final ThreadSafeDateFormat DATE_FORMATTER = new ThreadSafeDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private long mSessionId;
    private Date mStartDate;
    private Date mEndDate;
    private final AtomicLong mRequestCount = new AtomicLong(0L);
    private final AtomicLong mFaultCount = new AtomicLong(0L);
    private EventLog mEventLog = new EventLog();

    public Session() {
    }

    public Session(long sessionId) {
        this.mSessionId = sessionId;
    }

    public long getSessionId() {
        return this.mSessionId;
    }

    public Date getStartDate() {
        return this.mStartDate;
    }

    public void setStartDate(Date startDate) {
        this.mStartDate = startDate;
    }

    public Date getEndDate() {
        return this.mEndDate;
    }

    public void setEndDate(Date endDate) {
        this.mEndDate = endDate;
    }

    public long getRequestCount() {
        return this.mRequestCount.get();
    }

    public long incrementAndGetRequestCount() {
        return this.mRequestCount.incrementAndGet();
    }

    private void setRequestCount(long requestCount) {
        this.mRequestCount.set(requestCount);
    }

    public long getFaultCount() {
        return this.mFaultCount.get();
    }

    public long incrementAndGetFaultCount() {
        return this.mFaultCount.incrementAndGet();
    }

    private void setFaultCount(long faultCount) {
        this.mFaultCount.set(faultCount);
    }

    public EventLog getEventLog() {
        return this.mEventLog;
    }

    private void setEventLog(EventLog eventLog) {
        this.mEventLog = eventLog;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(XML_ELEM_SESSION);
        writer.writeAttribute(XML_ATTR_SESSION_ID, Long.toString(this.getSessionId()));
        writer.writeAttribute(XML_ATTR_START_DATE, DATE_FORMATTER.format(this.getStartDate()));
        writer.writeAttribute(XML_ATTR_END_DATE, DATE_FORMATTER.format(this.getEndDate()));
        writer.writeAttribute(XML_ATTR_REQUEST_COUNT, Long.toString(this.getRequestCount()));
        writer.writeAttribute(XML_ATTR_FAULT_COUNT, Long.toString(this.getFaultCount()));
        this.getEventLog().serialize(writer);
        writer.writeEndElement();
    }

    public static Session deserialize(XMLStreamReader reader) throws XMLStreamException {
        reader.require(1, null, XML_ELEM_SESSION);
        String tmp = reader.getAttributeValue(null, XML_ATTR_SESSION_ID);
        Session session = new Session(Long.parseLong(tmp));
        try {
            tmp = reader.getAttributeValue(null, XML_ATTR_END_DATE);
            session.setEndDate(DATE_FORMATTER.parse(tmp));
            tmp = reader.getAttributeValue(null, XML_ATTR_FAULT_COUNT);
            session.setFaultCount(Long.parseLong(tmp));
            tmp = reader.getAttributeValue(null, XML_ATTR_REQUEST_COUNT);
            session.setRequestCount(Long.parseLong(tmp));
            tmp = reader.getAttributeValue(null, XML_ATTR_START_DATE);
            session.setStartDate(DATE_FORMATTER.parse(tmp));
        }
        catch (ParseException ex) {
            throw new XQERuntimeException(ex);
        }
        StaxUtil.moveToElement(reader);
        session.setEventLog(EventLog.deserialize(reader));
        return session;
    }
}

