/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.cache;

import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.StringKeyIndexer;
import com.cognos.xqe.cache.StringKeyIndexerKey;
import com.cognos.xqe.cache.storage.primitive.BTreePrimitiveCacheStorage;
import com.cognos.xqe.cache.storage.primitive.CacheValueNotFound;
import com.cognos.xqe.cache.storage.primitive.PrimitiveCache;
import com.cognos.xqe.exception.RequestCanceledException;
import com.cognos.xqe.exception.XQERuntimeException;
import java.io.File;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BTreeStringKeyIndexer
implements StringKeyIndexer {
    private PrimitiveCache pcache = null;
    private ReadWriteLock rwLock = new ReentrantReadWriteLock();

    @Override
    public long getIndex(String value) {
        return this.getIndex(this.createKey(value));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getIndex(StringKeyIndexerKey key) {
        try {
            try {
                this.rwLock.readLock().lockInterruptibly();
                long l = this.pcache.get(key);
                return l;
            }
            catch (CacheValueNotFound cacheValueNotFound) {
            }
            catch (InterruptedException e) {
                throw new RequestCanceledException();
            }
            finally {
                this.rwLock.readLock().unlock();
            }
            try {
                this.rwLock.writeLock().lockInterruptibly();
                long e = this.pcache.get(key);
                return e;
            }
            catch (CacheValueNotFound e) {
                long id;
                try {
                    id = this.pcache.get(INDEXER_KEY);
                }
                catch (CacheValueNotFound ce) {
                    id = 0L;
                }
                this.pcache.put(key, ++id);
                this.pcache.put(INDEXER_KEY, id);
                long l = id;
                return l;
            }
            catch (InterruptedException e) {
                throw new RequestCanceledException();
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        }
        catch (CacheException e) {
            throw new XQERuntimeException(e);
        }
    }

    public BTreeStringKeyIndexer(String cacheDir, String fileName, boolean replaceExistingFiles) {
        this.pcache = new PrimitiveCache();
        File f = new File(cacheDir);
        if (!f.exists() && !f.mkdirs()) {
            throw new XQERuntimeException();
        }
        this.pcache.addStorage(new BTreePrimitiveCacheStorage(cacheDir, fileName + "_idx", replaceExistingFiles));
    }

    @Override
    public void close() {
        try {
            this.pcache.close();
        }
        catch (CacheException ce) {
            throw new XQERuntimeException(ce);
        }
    }

    @Override
    public StringKeyIndexerKey createKey(String value) {
        return new StringKeyIndexerKey(value);
    }
}

