/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.cache;

import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.ICacheEngine;
import com.cognos.xqe.cache.engine.L2CacheEngine;
import com.cognos.xqe.cache.storage.BTreeCacheStorage;
import com.cognos.xqe.cache.storage.BufferHashmapCacheStorage;
import com.cognos.xqe.cache.storage.LRUMapCacheStorage;
import com.cognos.xqe.cache.storage.LongBucketCacheStorage;
import com.cognos.xqe.cache.storage.SoftReferenceHashmapCacheStorage;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import java.io.File;

public final class CacheEngineFactory {
    private static final String CACHE_STORAGE_DIR = "cacheStorage";

    public static ICacheEngine createNullCache() {
        ICacheEngine cache = CacheEngineFactory.createCache();
        return cache;
    }

    public static ICacheEngine createStaticCache() {
        ICacheEngine cache = CacheEngineFactory.createCache();
        cache.addStorage(new LongBucketCacheStorage());
        return cache;
    }

    public static ICacheEngine createDynamicCache(int maxElements, String cacheName, String cacheDir, boolean replace) throws CacheException {
        if (cacheDir == null) {
            cacheDir = CacheEngineFactory.getCacheDirectory();
        }
        ICacheEngine cache = CacheEngineFactory.createCache();
        if (maxElements > 0) {
            cache.addStorage(new LRUMapCacheStorage(maxElements));
        } else {
            cache.addStorage(new LongBucketCacheStorage());
            if (cache instanceof L2CacheEngine) {
                ((L2CacheEngine)cache).setCacheL1OnPut(false);
            }
        }
        cache.addStorage(new BTreeCacheStorage(cacheDir, cacheName, replace));
        return cache;
    }

    public static ICacheEngine createDynamicMemoryCache(int maxElements, String cacheName, String cacheDir, boolean replace) throws CacheException {
        if (cacheDir == null) {
            cacheDir = CacheEngineFactory.getCacheDirectory();
        }
        ICacheEngine cache = CacheEngineFactory.createCache();
        ((L2CacheEngine)cache).setCacheL2OnPut(false);
        BTreeCacheStorage backingStore = new BTreeCacheStorage(cacheDir, cacheName, replace);
        cache.addStorage(new LRUMapCacheStorage(maxElements, backingStore));
        cache.addStorage(backingStore);
        return cache;
    }

    public static ICacheEngine createCache() {
        return new L2CacheEngine();
    }

    public static ICacheEngine createTestCache() {
        ICacheEngine cache = CacheEngineFactory.createCache();
        cache.addStorage(new BufferHashmapCacheStorage());
        return cache;
    }

    public static ICacheEngine createSoftCache(int pinSize) {
        ICacheEngine cache = CacheEngineFactory.createCache();
        cache.addStorage(new SoftReferenceHashmapCacheStorage(pinSize));
        return cache;
    }

    private static String getCacheDirectory() {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        String cacheDir = config.getXqeTempDirectory() + File.separator + CACHE_STORAGE_DIR;
        return cacheDir;
    }

    public static ICacheEngine createDiskCache(String dir, String filename, boolean replace) throws CacheException {
        if (dir == null) {
            dir = CacheEngineFactory.getCacheDirectory();
        }
        ICacheEngine cache = CacheEngineFactory.createCache();
        cache.addStorage(new BTreeCacheStorage(dir, filename, replace));
        return cache;
    }
}

