/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.cache;

public class CacheException
extends Exception {
    private String filename = "unknown";
    private static final long serialVersionUID = 8348873091911162157L;

    public void setFilename(String name) {
        this.filename = name;
    }

    public String getFilename() {
        return this.filename;
    }

    public CacheException(Throwable cause) {
        super(cause);
    }

    public CacheException() {
    }

    public static class FileIOError
    extends CacheException {
        private static final long serialVersionUID = 7559671921065089366L;

        public FileIOError(String file) {
            this.setFilename(file);
        }

        public FileIOError(String file, Throwable cause) {
            this.setFilename(file);
        }
    }

    public static class InvalidCacheKeyError
    extends CacheException {
        private static final long serialVersionUID = 450843929254996904L;
    }

    public static class DirectoryCreationFailure
    extends CacheException {
        private static final long serialVersionUID = -2841001713719658889L;

        public DirectoryCreationFailure(String dir) {
            this.setFilename(dir);
        }
    }

    public static class CreationFailed
    extends CacheException {
        private static final long serialVersionUID = -6502366123724935879L;

        public CreationFailed(Throwable cause) {
            super(cause);
        }
    }

    public static class FileRemovalFailure
    extends CacheException {
        private static final long serialVersionUID = 5952426436713595103L;

        public FileRemovalFailure(String file) {
            this.setFilename(file);
        }
    }

    public static class UnexpectedError
    extends CacheException {
        private static final long serialVersionUID = -3588792340190979543L;

        public UnexpectedError(Throwable cause) {
            super(cause);
        }
    }

    public static class InternalError
    extends CacheException {
        private static final long serialVersionUID = -8750484456362114784L;
    }

    public static class ObjectSerializationException
    extends CacheException {
        private static final long serialVersionUID = 2000564939853656033L;

        public ObjectSerializationException(Throwable cause) {
            super(cause);
        }
    }

    public static class ObjectCreationException
    extends CacheException {
        private static final long serialVersionUID = 4726372414724206415L;

        public ObjectCreationException(Throwable cause) {
            super(cause);
        }
    }
}

