/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.cache;

import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.cache.StringKeyIndexer;
import com.cognos.xqe.cache.StringKeyIndexerKey;
import com.cognos.xqe.exception.RequestCanceledException;
import com.cognos.xqe.util.primitive.HashMapObjectLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class HashMapStringKeyIndexer
implements StringKeyIndexer {
    private HashMapObjectLong<ICacheKey> pcache = null;
    private ReadWriteLock rwLock = new ReentrantReadWriteLock();

    @Override
    public long getIndex(String value) {
        return this.getIndex(this.createKey(value));
    }

    @Override
    public long getIndex(StringKeyIndexerKey key) {
        try {
            this.rwLock.readLock().lockInterruptibly();
            if (this.pcache.containsKey(key)) {
                long l = this.pcache.get(key);
                return l;
            }
        }
        catch (InterruptedException e) {
            throw new RequestCanceledException();
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        try {
            this.rwLock.writeLock().lockInterruptibly();
            if (this.pcache.containsKey(key)) {
                long e = this.pcache.get(key);
                return e;
            }
            long id = this.pcache.containsKey(INDEXER_KEY) ? this.pcache.get(INDEXER_KEY) : 0L;
            this.pcache.put(key, ++id);
            this.pcache.put(INDEXER_KEY, id);
            long l = id;
            return l;
        }
        catch (InterruptedException e) {
            throw new RequestCanceledException();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public HashMapStringKeyIndexer() {
        this.pcache = new HashMapObjectLong();
    }

    @Override
    public void close() {
    }

    @Override
    public StringKeyIndexerKey createKey(String value) {
        return new StringKeyIndexerKey(value);
    }
}

