/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.cache.engine;

import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.CacheMetricsTracker;
import com.cognos.xqe.cache.ICacheEngine;
import com.cognos.xqe.cache.ICacheFaultHandler;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.cache.ICacheStorage;
import com.cognos.xqe.cache.ICacheableObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class L2CacheEngine
implements ICacheEngine {
    CacheMetricsTracker cacheMetrics = new CacheMetricsTracker(false);
    ICacheStorage firstLevel = null;
    ICacheStorage secondLevel = null;
    boolean cacheL1OnPut = true;
    boolean cacheL2OnPut = true;
    private AtomicInteger cacheSize = new AtomicInteger(0);
    private AtomicInteger cacheSizeBytes = new AtomicInteger(0);
    private List<ICacheFaultHandler> faultHandlers = new ArrayList<ICacheFaultHandler>();

    public void setCacheL1OnPut(boolean put) {
        this.cacheL1OnPut = put;
    }

    public void setCacheL2OnPut(boolean put) {
        this.cacheL2OnPut = put;
    }

    @Override
    public int getCacheSize() {
        return this.cacheSize.get();
    }

    @Override
    public int getCacheSizeBytes() {
        return this.cacheSizeBytes.get();
    }

    @Override
    public int getFreeSize() {
        return this.firstLevel.getFreeSize();
    }

    public void setFirstLevelStorage(ICacheStorage cacheStorage) {
        this.firstLevel = cacheStorage;
    }

    public void setSecondLevelStorage(ICacheStorage cacheStorage) {
        this.secondLevel = cacheStorage;
    }

    @Override
    public void addStorage(ICacheStorage cacheStorage) {
        if (this.firstLevel == null) {
            this.firstLevel = cacheStorage;
        } else {
            this.secondLevel = cacheStorage;
        }
    }

    @Override
    public void addFaultHandler(ICacheFaultHandler handler) {
        this.faultHandlers.add(handler);
    }

    @Override
    public void cacheAll(List<ICacheableObject> objects) throws CacheException {
        ArrayList<ICacheKey> keys = new ArrayList<ICacheKey>(objects.size());
        for (ICacheableObject obj : objects) {
            keys.add(obj.getCacheKey());
        }
        if (this.cacheL1OnPut && this.firstLevel != null) {
            this.firstLevel.bulkPut(keys, objects);
        }
        if (this.secondLevel != null) {
            this.secondLevel.bulkPut(keys, objects);
        }
    }

    @Override
    public void cacheObject(ICacheableObject obj) throws CacheException {
        if (obj == null) {
            throw new CacheException.InvalidCacheKeyError();
        }
        if (obj.getCacheKey() == null) {
            throw new CacheException.InvalidCacheKeyError();
        }
        if (this.cacheL1OnPut && this.firstLevel != null) {
            this.firstLevel.put(obj.getCacheKey(), obj);
        }
        if (this.cacheL2OnPut && this.secondLevel != null) {
            this.secondLevel.put(obj.getCacheKey(), obj);
        }
        this.cacheSize.incrementAndGet();
    }

    private ICacheableObject internalGet(ICacheStorage store, ICacheKey key) throws CacheException {
        if (store == null) {
            return null;
        }
        ICacheableObject obj = null;
        if (store.localReferences()) {
            obj = store.get(key);
        } else {
            Class<?> clazz = key.getCacheableObjectClass();
            try {
                obj = (ICacheableObject)clazz.newInstance();
            }
            catch (IllegalAccessException e) {
                throw new CacheException.ObjectCreationException(e);
            }
            catch (InstantiationException e) {
                throw new CacheException.ObjectCreationException(e);
            }
            obj.setKey(key);
            obj = store.get(key, obj);
        }
        return obj;
    }

    private ICacheableObject internalGet(ICacheKey key, CacheMetricsTracker metrics) throws CacheException {
        if (key == null) {
            throw new CacheException.InvalidCacheKeyError();
        }
        ICacheableObject obj = null;
        obj = this.internalGet(this.firstLevel, key);
        if (obj == null) {
            long startTime = System.currentTimeMillis();
            obj = this.internalGet(this.secondLevel, key);
            if (obj != null) {
                this.firstLevel.put(key, obj);
            }
            if (metrics != null) {
                long missTime = System.currentTimeMillis() - startTime;
                metrics.incrementMisses();
                metrics.incrementAvgMissTime(missTime);
                this.cacheMetrics.incrementMisses();
                this.cacheMetrics.incrementAvgMissTime(missTime);
            }
        } else if (metrics != null) {
            metrics.incrementHits();
            this.cacheMetrics.incrementHits();
        }
        if (obj == null) {
            if (key.getFaultHandler() != null) {
                obj = key.getFaultHandler().lookupObject(key);
            } else {
                for (ICacheFaultHandler handler : this.faultHandlers) {
                    obj = handler.lookupObject(key);
                    if (obj == null) continue;
                    this.cacheObject(obj);
                }
            }
        }
        return obj;
    }

    @Override
    public ICacheableObject get(ICacheKey key) throws CacheException {
        return this.internalGet(key, null);
    }

    @Override
    public ICacheableObject get(ICacheKey key, CacheMetricsTracker metrics) throws CacheException {
        return this.internalGet(key, metrics);
    }

    @Override
    public List<ICacheableObject> getAll(List<ICacheKey> keys) throws CacheException {
        return this.getAll(keys, null);
    }

    @Override
    public boolean contains(ICacheKey key) throws CacheException {
        if (this.firstLevel.contains(key)) {
            return true;
        }
        if (this.secondLevel != null) {
            return this.secondLevel.contains(key);
        }
        return false;
    }

    @Override
    public void close() throws CacheException {
        if (this.firstLevel != null) {
            this.firstLevel.close();
        }
        if (this.secondLevel != null) {
            this.secondLevel.close();
        }
    }

    @Override
    public void flush() throws CacheException {
        if (this.firstLevel != null) {
            this.firstLevel.flush();
        }
        if (this.secondLevel != null) {
            this.secondLevel.flush();
        }
    }

    @Override
    public void clear() throws CacheException {
        if (this.firstLevel != null) {
            this.firstLevel.clear();
        }
        if (this.secondLevel != null) {
            this.secondLevel.clear();
        }
    }

    @Override
    public CacheMetricsTracker getMetrics() {
        return this.cacheMetrics;
    }

    @Override
    public List<ICacheableObject> getAll(List<ICacheKey> keys, CacheMetricsTracker metrics) throws CacheException {
        ArrayList<ICacheableObject> result = new ArrayList<ICacheableObject>();
        for (ICacheKey key : keys) {
            ICacheableObject obj = this.get(key, metrics);
            if (obj == null) continue;
            result.add(obj);
        }
        return result;
    }

    @Override
    public void remove(ICacheKey key) throws CacheException {
        if (this.firstLevel != null) {
            this.firstLevel.remove(key);
        }
        if (this.secondLevel != null) {
            this.secondLevel.remove(key);
        }
    }
}

