/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.cache.storage;

import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.cache.ICacheStorage;
import com.cognos.xqe.cache.ICacheableObject;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class HashmapCacheStorage
implements ICacheStorage {
    ReadWriteLock rwLock = new ReentrantReadWriteLock();
    Map<ICacheKey, ICacheableObject> objectCache = new TreeMap<ICacheKey, ICacheableObject>();

    @Override
    public ICacheableObject get(ICacheKey key) {
        this.rwLock.readLock().lock();
        try {
            ICacheableObject iCacheableObject = this.objectCache.get(key);
            return iCacheableObject;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public void put(ICacheKey key, ICacheableObject obj) throws CacheException {
        this.rwLock.writeLock().lock();
        try {
            this.objectCache.put(key, obj);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public boolean contains(ICacheKey key) {
        this.rwLock.readLock().lock();
        try {
            boolean bl = this.objectCache.containsKey(key);
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public ICacheableObject get(ICacheKey key, ICacheableObject shell) throws CacheException {
        return null;
    }

    @Override
    public boolean localReferences() {
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void clear() {
        this.rwLock.writeLock().lock();
        try {
            this.objectCache.clear();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public int getFreeSize() {
        return 0;
    }

    @Override
    public void bulkPut(List<ICacheKey> keys, List<ICacheableObject> objs) throws CacheException {
        for (int i = 0; i < keys.size(); ++i) {
            this.put(keys.get(i), objs.get(i));
        }
    }

    @Override
    public void remove(ICacheKey key) throws CacheException {
        this.rwLock.writeLock().lock();
        try {
            this.objectCache.remove(key);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }
}

