/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.cache.storage;

import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.cache.ICacheStorage;
import com.cognos.xqe.cache.ICacheableObject;
import com.cognos.xqe.exception.XQERuntimeException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections.map.AbstractLinkedMap;
import org.apache.commons.collections.map.LRUMap;

public class LRUMapCacheStorage
implements ICacheStorage {
    private LRUMap store;
    private Lock lock = new ReentrantLock();

    public LRUMapCacheStorage(int size) {
        this.store = new LRUMap(size);
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.store.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
    }

    @Override
    public boolean contains(ICacheKey key) {
        this.lock.lock();
        try {
            boolean bl = this.store.containsKey((Object)key);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void flush() {
        try {
            if (this.store instanceof BackingLRUMap) {
                ICacheStorage backingStore = ((BackingLRUMap)this.store).backingStore;
                for (Object objEntry : this.store.entrySet()) {
                    Map.Entry entry = (Map.Entry)objEntry;
                    if (backingStore.contains((ICacheKey)entry.getKey())) continue;
                    backingStore.put((ICacheKey)entry.getKey(), (ICacheableObject)entry.getValue());
                }
            }
        }
        catch (CacheException e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    public ICacheableObject get(ICacheKey key) {
        this.lock.lock();
        try {
            ICacheableObject iCacheableObject = (ICacheableObject)this.store.get((Object)key);
            return iCacheableObject;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public ICacheableObject get(ICacheKey key, ICacheableObject shell) {
        return null;
    }

    @Override
    public boolean localReferences() {
        return true;
    }

    @Override
    public void put(ICacheKey key, ICacheableObject obj) {
        this.lock.lock();
        try {
            this.store.put((Object)key, (Object)obj);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getFreeSize() {
        this.lock.lock();
        try {
            int n = this.store.maxSize() - this.store.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void bulkPut(List<ICacheKey> keys, List<ICacheableObject> objs) throws CacheException {
        for (int i = 0; i < keys.size(); ++i) {
            this.put(keys.get(i), objs.get(i));
        }
    }

    public LRUMapCacheStorage(int size, ICacheStorage backStore) {
        this.store = new BackingLRUMap(size, backStore);
    }

    @Override
    public void remove(ICacheKey key) throws CacheException {
        this.lock.lock();
        try {
            this.store.remove((Object)key);
        }
        finally {
            this.lock.unlock();
        }
    }

    class BackingLRUMap
    extends LRUMap {
        ICacheStorage backingStore;
        private static final long serialVersionUID = -8547179731571733159L;

        BackingLRUMap(int size, ICacheStorage storage) {
            super(size);
            this.backingStore = null;
            this.backingStore = storage;
        }

        protected boolean removeLRU(AbstractLinkedMap.LinkEntry entry) {
            if (this.backingStore != null) {
                ICacheKey key = (ICacheKey)entry.getKey();
                try {
                    this.backingStore.put(key, (ICacheableObject)entry.getValue());
                }
                catch (CacheException e) {
                    throw new XQERuntimeException(e);
                }
                return true;
            }
            return super.removeLRU(entry);
        }
    }
}

