/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.cache.storage;

import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.cache.ICacheStorage;
import com.cognos.xqe.cache.ICacheableObject;
import com.cognos.xqe.exception.XQERuntimeException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LongBucketCacheStorage
implements ICacheStorage {
    private static final int MAPPED_BITS = 32;
    private static final long MAPPED_BITS_MASK = 0xFFFFFFFFL;
    private static final int MAPPED_BITS_SHIFT = 32;
    private static final int[] ARRAY_ADDRESS_SPACE = new int[]{8, 8, 4, 12};
    private static int[] addressSpaceBitmasks = new int[ARRAY_ADDRESS_SPACE.length];
    private static int[] addressSpaceShift = new int[ARRAY_ADDRESS_SPACE.length];
    Map<Integer, Object[]> topLevel;
    private Lock lock;

    public LongBucketCacheStorage() {
        int sum = 0;
        for (int num : ARRAY_ADDRESS_SPACE) {
            sum += num;
        }
        if (sum != 32) {
            throw new XQERuntimeException();
        }
        for (int i = 0; i < ARRAY_ADDRESS_SPACE.length; ++i) {
            LongBucketCacheStorage.addressSpaceBitmasks[i] = (1 << ARRAY_ADDRESS_SPACE[i]) - 1;
        }
        int shift = 32;
        for (int i = 0; i < ARRAY_ADDRESS_SPACE.length; ++i) {
            LongBucketCacheStorage.addressSpaceShift[i] = shift -= ARRAY_ADDRESS_SPACE[i];
        }
        this.topLevel = new TreeMap<Integer, Object[]>();
        this.lock = new ReentrantLock();
    }

    @Override
    public void clear() {
    }

    @Override
    public void close() {
    }

    private int getTopIndex(long key) {
        return (int)(key >> 32 & 0xFFFFFFFFL);
    }

    private int[] getBucketIndexes(long key) {
        int[] indexes = new int[ARRAY_ADDRESS_SPACE.length];
        for (int i = 0; i < ARRAY_ADDRESS_SPACE.length; ++i) {
            indexes[i] = (int)(key >> addressSpaceShift[i]) & addressSpaceBitmasks[i];
        }
        return indexes;
    }

    private Object[] findBucket(int topIndex, int[] bucketIndexes, boolean create) {
        Object[] top = this.topLevel.get(topIndex);
        if (top == null) {
            if (create) {
                top = new Object[1 << ARRAY_ADDRESS_SPACE[0]];
                this.topLevel.put(topIndex, top);
            } else {
                return null;
            }
        }
        Object[] bucket = null;
        for (int i = 0; i < ARRAY_ADDRESS_SPACE.length - 1; ++i) {
            bucket = (Object[])top[bucketIndexes[i]];
            if (bucket == null) {
                if (create) {
                    top[bucketIndexes[i]] = bucket = new Object[1 << ARRAY_ADDRESS_SPACE[i + 1]];
                } else {
                    return null;
                }
            }
            top = bucket;
        }
        return bucket;
    }

    @Override
    public boolean contains(ICacheKey key) {
        int[] bucketIndexes;
        int topIndex = this.getTopIndex(key.getLong());
        Object[] bucket = this.findBucket(topIndex, bucketIndexes = this.getBucketIndexes(key.getLong()), false);
        if (bucket != null) {
            return bucket[bucketIndexes[bucketIndexes.length - 1]] != null;
        }
        return false;
    }

    @Override
    public void flush() {
    }

    @Override
    public ICacheableObject get(ICacheKey key) {
        int[] bucketIndexes;
        int topIndex = this.getTopIndex(key.getLong());
        Object[] bucket = this.findBucket(topIndex, bucketIndexes = this.getBucketIndexes(key.getLong()), false);
        if (bucket != null) {
            return (ICacheableObject)bucket[bucketIndexes[bucketIndexes.length - 1]];
        }
        return null;
    }

    @Override
    public ICacheableObject get(ICacheKey key, ICacheableObject shell) {
        return null;
    }

    @Override
    public boolean localReferences() {
        return true;
    }

    @Override
    public void put(ICacheKey key, ICacheableObject obj) {
        this.lock.lock();
        try {
            this.putNoLock(key, obj);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void putNoLock(ICacheKey key, ICacheableObject obj) {
        int topIndex = this.getTopIndex(key.getLong());
        int[] bucketIndexes = this.getBucketIndexes(key.getLong());
        Object[] bucket = this.findBucket(topIndex, bucketIndexes, true);
        bucket[bucketIndexes[bucketIndexes.length - 1]] = obj;
    }

    @Override
    public int getFreeSize() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bulkPut(List<ICacheKey> keys, List<ICacheableObject> objs) throws CacheException {
        this.lock.lock();
        try {
            for (int i = 0; i < keys.size(); ++i) {
                this.putNoLock(keys.get(i), objs.get(i));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(ICacheKey key) throws CacheException {
        this.lock.lock();
        try {
            int topIndex = this.getTopIndex(key.getLong());
            int[] bucketIndexes = this.getBucketIndexes(key.getLong());
            Object[] bucket = this.findBucket(topIndex, bucketIndexes, true);
            bucket[bucketIndexes[bucketIndexes.length - 1]] = null;
        }
        finally {
            this.lock.unlock();
        }
    }
}

