/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.cache.util;

import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.cache.ICacheableObject;
import com.cognos.xqe.cache.util.ICacheableNameValueBasedContent;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorageKey;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorageMemberKey;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.VarcharValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.record.IExternalizable;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MetadataCacheKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class CacheableNameValueBasedArray
implements Serializable,
ICacheableNameValueBasedContent {
    protected static ConcurrentMap<String, Integer> propToIdMap = new ConcurrentHashMap<String, Integer>();
    protected static ConcurrentMap<Integer, String> idToPropMap = new ConcurrentHashMap<Integer, String>();
    private static AtomicInteger maxPropId = new AtomicInteger(0);
    protected int[] idArray = null;
    protected Object[] valueArray = null;
    protected ICacheKey cacheKey;
    protected static final long serialVersionUID = 1763751091792259147L;
    private static final int SERIALIZED_OBJECT_ID = 1;
    private static final int STRING_ID = 2;
    private static final int METADATA_CACHE_KEY_ID = 3;
    private static final int LIST_ID = 4;
    private static final int NULL_OBJECT_ID = 5;
    private static final int ICACHEKEY_ARRAY = 6;
    private static final int IEXTERNALIZABLE_ID = 7;
    private static final int MEMBER_STORAGE_KEY_ID = 8;
    private static final int MEMBER_STORAGE_MEMBER_KEY_ID = 9;
    private static final int VARCHARVALUE_ID = 10;

    protected static Integer nameToId(String name) {
        Integer propId = (Integer)propToIdMap.get(name);
        if (propId == null) {
            propId = maxPropId.getAndIncrement();
            Integer otherPropId = propToIdMap.putIfAbsent(name, propId);
            if (otherPropId != null) {
                propId = otherPropId;
            } else {
                String otherName = idToPropMap.put(propId, name);
                if (otherName != null) {
                    throw new XQERuntimeException();
                }
            }
        }
        return propId;
    }

    protected static String idToName(Integer id) {
        return (String)idToPropMap.get(id);
    }

    public CacheableNameValueBasedArray() {
        this.cacheKey = null;
    }

    public CacheableNameValueBasedArray(ICacheKey key, Map<String, Object> nameValueContent) {
        this.cacheKey = key;
        this.addContent(nameValueContent);
    }

    @Override
    public ICacheKey getCacheKey() {
        return this.cacheKey;
    }

    private void writeObject(ObjectOutputStream out) throws IOException, CacheException {
        this.writeToStream(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, CacheException {
        this.readFromStream(in);
    }

    @Override
    public void readFromStream(ObjectInputStream in) throws IOException, ClassNotFoundException, CacheException {
        int i;
        int size = in.readInt();
        this.idArray = new int[size];
        this.valueArray = new Object[size];
        for (i = 0; i < size; ++i) {
            this.idArray[i] = in.readInt();
        }
        for (i = 0; i < size; ++i) {
            this.valueArray[i] = this.readObjectFromStream(in);
        }
    }

    private Object readObjectFromStream(ObjectInputStream in) throws IOException, ClassNotFoundException, CacheException {
        int objectType = in.readInt();
        int len = 0;
        ICacheKey key = null;
        switch (objectType) {
            case 5: {
                return null;
            }
            case 1: {
                return in.readObject();
            }
            case 3: {
                key = new MetadataCacheKey();
                key.readFromStream(in);
                return key;
            }
            case 8: {
                key = new MemberStorageKey();
                key.readFromStream(in);
                return key;
            }
            case 9: {
                key = new MemberStorageMemberKey();
                key.readFromStream(in);
                return key;
            }
            case 4: {
                len = in.readInt();
                ArrayList<Object> list = new ArrayList<Object>(len);
                for (int i = 0; i < len; ++i) {
                    list.add(this.readObjectFromStream(in));
                }
                return list;
            }
            case 2: {
                len = in.readInt();
                StringBuilder value = new StringBuilder(len);
                for (int j = 0; j < len; ++j) {
                    value.append(in.readChar());
                }
                return value.toString();
            }
            case 10: {
                len = in.readInt();
                char[] valueChars = new char[len];
                for (int j = 0; j < len; ++j) {
                    valueChars[j] = in.readChar();
                }
                VarcharValue varcharValue = DataValueFactory.createVarcharValue();
                varcharValue.set(valueChars);
                return varcharValue;
            }
            case 6: {
                len = in.readInt();
                ICacheKey[] keys = new ICacheKey[len];
                for (int i = 0; i < len; ++i) {
                    keys[i] = (ICacheKey)this.readObjectFromStream(in);
                }
                return keys;
            }
            case 7: {
                IExternalizable obj;
                len = in.readInt();
                StringBuilder name = new StringBuilder(len);
                for (int j = 0; j < len; ++j) {
                    name.append(in.readChar());
                }
                Class<?> clazz = Class.forName(name.toString());
                try {
                    obj = (IExternalizable)clazz.newInstance();
                }
                catch (IllegalAccessException e) {
                    throw new CacheException.ObjectCreationException(e);
                }
                catch (InstantiationException e) {
                    throw new CacheException.ObjectCreationException(e);
                }
                obj.deexternalize(in);
                return obj;
            }
        }
        throw new CacheException.InternalError();
    }

    private void writeObjectToStream(Object value, ObjectOutputStream out) throws IOException {
        if (value == null || value instanceof Value && ((Value)value).isNull()) {
            out.writeInt(5);
        } else if (value instanceof MetadataCacheKey) {
            out.writeInt(3);
            ((MetadataCacheKey)value).writeToStream(out);
        } else if (value instanceof MemberStorageMemberKey) {
            out.writeInt(9);
            ((MemberStorageMemberKey)value).writeToStream(out);
        } else if (value instanceof MemberStorageKey) {
            out.writeInt(8);
            ((MemberStorageKey)value).writeToStream(out);
        } else if (value instanceof String) {
            out.writeInt(2);
            out.writeInt(((String)value).length());
            out.writeChars((String)value);
        } else if (value instanceof VarcharValue) {
            out.writeInt(10);
            out.writeInt(((VarcharValue)value).getCurrentLength());
            out.writeChars(((VarcharValue)value).getString());
        } else if (value instanceof List) {
            out.writeInt(4);
            List list = (List)value;
            out.writeInt(list.size());
            for (Object item : list) {
                this.writeObjectToStream(item, out);
            }
        } else if (value instanceof ICacheKey[]) {
            out.writeInt(6);
            out.writeInt(((ICacheKey[])value).length);
            for (ICacheKey key : (ICacheKey[])value) {
                this.writeObjectToStream(key, out);
            }
        } else if (value instanceof IExternalizable) {
            out.writeInt(7);
            String className = value.getClass().getName();
            out.writeInt(className.length());
            out.writeChars(className);
            ((IExternalizable)value).externalize(out);
        } else {
            out.writeInt(1);
            out.writeObject(value);
        }
    }

    @Override
    public void writeToStream(ObjectOutputStream out) throws IOException {
        if (this.idArray == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.idArray.length);
            for (int id : this.idArray) {
                out.writeInt(id);
            }
            for (Object value : this.valueArray) {
                this.writeObjectToStream(value, out);
            }
        }
    }

    @Override
    public void inflateObject(ByteBuffer bbf) throws CacheException {
        try {
            ByteArrayInputStream bytesIn = new ByteArrayInputStream(bbf.array());
            ObjectInputStream in = new ObjectInputStream(bytesIn);
            this.readFromStream(in);
        }
        catch (IOException e) {
            throw new CacheException.ObjectCreationException(e);
        }
        catch (ClassNotFoundException e) {
            throw new CacheException.ObjectCreationException(e);
        }
    }

    @Override
    public void deflateObject(ByteBuffer bbf) throws CacheException {
        bbf.put(this.getBytes());
    }

    @Override
    public ICacheableObject cloneObj() {
        return this;
    }

    private byte[] getBytes() throws CacheException {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(byteStream);
            this.writeToStream(out);
            return byteStream.toByteArray();
        }
        catch (IOException e) {
            throw new CacheException.ObjectSerializationException(e);
        }
    }

    @Override
    public int getSize() throws CacheException {
        return this.getBytes().length;
    }

    @Override
    public Map<String, Object> getContent() {
        return this;
    }

    @Override
    public void addContent(Map<String, Object> nameValueContent) {
        Set<String> keys = nameValueContent.keySet();
        this.idArray = new int[keys.size()];
        this.valueArray = new Object[keys.size()];
        int i = 0;
        for (String key : keys) {
            this.idArray[i++] = CacheableNameValueBasedArray.nameToId(key);
        }
        Arrays.sort(this.idArray);
        for (i = 0; i < this.idArray.length; ++i) {
            this.valueArray[i] = nameValueContent.get(CacheableNameValueBasedArray.idToName(this.idArray[i]));
        }
    }

    @Override
    public void setKey(ICacheKey key) {
        this.cacheKey = key;
    }

    @Override
    public void clear() {
        this.idArray = null;
        this.valueArray = null;
    }

    @Override
    public boolean containsKey(Object key) {
        return Arrays.binarySearch(this.idArray, CacheableNameValueBasedArray.nameToId((String)key)) > -1;
    }

    @Override
    public boolean containsValue(Object obj) {
        for (int i = 0; i < this.valueArray.length; ++i) {
            if (!this.valueArray[i].equals(obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(Object key) {
        int index = Arrays.binarySearch(this.idArray, CacheableNameValueBasedArray.nameToId((String)key));
        if (index < 0) {
            return null;
        }
        return this.valueArray[index];
    }

    @Override
    public boolean isEmpty() {
        return this.idArray == null || this.idArray.length == 0;
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object put(String key, Object value) {
        Integer id = CacheableNameValueBasedArray.nameToId(key);
        int index = Arrays.binarySearch(this.idArray, id);
        if (index >= 0) {
            Object oldValue = this.valueArray[index];
            this.valueArray[index] = value;
            return oldValue;
        }
        if (value != null) {
            int[] newIdArray = new int[this.idArray.length + 1];
            System.arraycopy(this.idArray, 0, newIdArray, 0, this.idArray.length);
            newIdArray[this.idArray.length] = id;
            Arrays.sort(newIdArray);
            Object[] newValueArray = new Object[this.idArray.length + 1];
            int oldIndex = 0;
            int newIndex = 0;
            for (int keyId : newIdArray) {
                if (keyId == id) {
                    newValueArray[newIndex++] = value;
                    continue;
                }
                newValueArray[newIndex++] = this.valueArray[oldIndex++];
            }
            this.idArray = newIdArray;
            this.valueArray = newValueArray;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        if (this.idArray == null) {
            return 0;
        }
        return this.idArray.length;
    }

    @Override
    public Collection<Object> values() {
        throw new UnsupportedOperationException();
    }

    public static void initializeIdMap(String[] allPropertyNames) {
        for (String property : allPropertyNames) {
            CacheableNameValueBasedArray.nameToId(property);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("Cached Properties: ");
        for (Object value : this.valueArray) {
            if (value == null) {
                buf.append("null");
            } else {
                buf.append(value.toString());
            }
            buf.append(" ");
        }
        return buf.toString();
    }
}

