/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.cache.util;

import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.cache.util.CacheableNameValueBasedArray;
import java.util.Arrays;
import java.util.Map;

public class CacheableNameValueBasedArrayImmutableKeys
extends CacheableNameValueBasedArray {
    protected static final long serialVersionUID = 1763751091792259148L;

    public CacheableNameValueBasedArrayImmutableKeys() {
    }

    public CacheableNameValueBasedArrayImmutableKeys(ICacheKey key, int[] ids, Map<String, Object> nameValueContent) {
        this.cacheKey = key;
        this.idArray = ids;
        this.valueArray = new Object[ids.length];
        this.addContent(nameValueContent);
    }

    @Override
    public void addContent(Map<String, Object> nameValueContent) {
        for (Map.Entry<String, Object> entry : nameValueContent.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object put(String key, Object value) {
        Integer id = CacheableNameValueBasedArrayImmutableKeys.nameToId(key);
        int index = Arrays.binarySearch(this.idArray, id);
        if (index >= 0) {
            Object oldValue = this.valueArray[index];
            this.valueArray[index] = value;
            return oldValue;
        }
        throw new UnsupportedOperationException("Cannot put key '" + key + "' since it's id is not already in the map.");
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public static int[] getIdsForProps(String[] props) {
        int[] ids = new int[props.length];
        int i = 0;
        for (String prop : props) {
            ids[i++] = CacheableNameValueBasedArrayImmutableKeys.nameToId(prop);
        }
        Arrays.sort(ids);
        for (i = 0; i < ids.length; ++i) {
            props[i] = CacheableNameValueBasedArrayImmutableKeys.idToName(ids[i]);
        }
        return ids;
    }
}

