/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.cache.util;

import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.cache.ICacheableObject;
import com.cognos.xqe.cache.util.ICacheableNameValueBasedContent;
import com.cognos.xqe.exception.XQERuntimeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CacheableNameValueBasedContent
implements ICacheableNameValueBasedContent {
    private static ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private static Map<String, Integer> propToIdMap = new HashMap<String, Integer>();
    private static Map<Integer, String> idToPropMap = new HashMap<Integer, String>();
    private static int maxPropId = 0;
    private Map<Integer, Object> idValueBasedContent;
    private ICacheKey cacheKey;
    private static final long serialVersionUID = 1763751091792259147L;

    protected static synchronized int getNextPropId() {
        return maxPropId++;
    }

    protected static Integer nameToId(String name) {
        Integer propId;
        rwLock.readLock().lock();
        try {
            propId = propToIdMap.get(name);
        }
        finally {
            rwLock.readLock().unlock();
        }
        if (propId == null) {
            rwLock.writeLock().lock();
            try {
                propId = CacheableNameValueBasedContent.getNextPropId();
                propToIdMap.put(name, propId);
                idToPropMap.put(propId, name);
            }
            finally {
                rwLock.writeLock().unlock();
            }
        }
        return propId;
    }

    protected static String idToName(Integer id) {
        rwLock.readLock().lock();
        try {
            String string = idToPropMap.get(id);
            return string;
        }
        finally {
            rwLock.readLock().unlock();
        }
    }

    public CacheableNameValueBasedContent() {
        this.cacheKey = null;
        this.idValueBasedContent = new HashMap<Integer, Object>();
    }

    public CacheableNameValueBasedContent(ICacheKey key, Map<String, Object> nameValueContent) {
        this.cacheKey = key;
        this.addContent(nameValueContent);
    }

    @Override
    public ICacheKey getCacheKey() {
        return this.cacheKey;
    }

    @Override
    public void readFromStream(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            int propId = in.readInt();
            Object value = in.readObject();
            this.idValueBasedContent.put(propId, value);
        }
    }

    @Override
    public void writeToStream(ObjectOutputStream out) throws IOException {
        out.writeInt(this.idValueBasedContent.size());
        for (Map.Entry<Integer, Object> value : this.idValueBasedContent.entrySet()) {
            out.writeInt(value.getKey());
            out.writeObject(value.getValue());
        }
    }

    @Override
    public void inflateObject(ByteBuffer bbf) {
        try {
            ByteArrayInputStream bytesIn = new ByteArrayInputStream(bbf.array());
            ObjectInputStream in = new ObjectInputStream(bytesIn);
            this.readFromStream(in);
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    public void deflateObject(ByteBuffer bbf) {
        bbf.put(this.getBytes());
    }

    @Override
    public ICacheableObject cloneObj() {
        return this;
    }

    private byte[] getBytes() {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(byteStream);
            this.writeToStream(out);
            return byteStream.toByteArray();
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    public int getSize() {
        return this.getBytes().length;
    }

    @Override
    public Map<String, Object> getContent() {
        return this;
    }

    @Override
    public void addContent(Map<String, Object> nameValueContent) {
        if (this.idValueBasedContent == null) {
            this.idValueBasedContent = new HashMap<Integer, Object>();
        }
        if (nameValueContent != null) {
            for (Map.Entry<String, Object> entry : nameValueContent.entrySet()) {
                Integer id = CacheableNameValueBasedContent.nameToId(entry.getKey());
                this.idValueBasedContent.put(id, entry.getValue());
            }
        }
    }

    @Override
    public void setKey(ICacheKey key) {
        this.cacheKey = key;
    }

    @Override
    public void clear() {
        this.idValueBasedContent.clear();
    }

    @Override
    public boolean containsKey(Object obj) {
        int id = propToIdMap.get(obj);
        return this.idValueBasedContent.containsKey(id);
    }

    @Override
    public boolean containsValue(Object obj) {
        return this.idValueBasedContent.containsValue(obj);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<Integer, Object> entry : this.idValueBasedContent.entrySet()) {
            result.put(CacheableNameValueBasedContent.idToName(entry.getKey()), entry.getValue());
        }
        return result.entrySet();
    }

    @Override
    public Object get(Object key) {
        return this.idValueBasedContent.get(CacheableNameValueBasedContent.nameToId((String)key));
    }

    @Override
    public boolean isEmpty() {
        return this.idValueBasedContent.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<Integer, Object> entry : this.idValueBasedContent.entrySet()) {
            result.add(CacheableNameValueBasedContent.idToName(entry.getKey()));
        }
        return result;
    }

    @Override
    public Object put(String key, Object value) {
        if (this.idValueBasedContent == null) {
            this.idValueBasedContent = new HashMap<Integer, Object>();
        }
        return this.idValueBasedContent.put(CacheableNameValueBasedContent.nameToId(key), value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        for (Map.Entry<? extends String, ? extends Object> entry : map.entrySet()) {
            this.idValueBasedContent.put(CacheableNameValueBasedContent.nameToId(entry.getKey()), entry.getValue());
        }
    }

    @Override
    public Object remove(Object key) {
        return this.idValueBasedContent.remove(CacheableNameValueBasedContent.nameToId((String)key));
    }

    @Override
    public int size() {
        return this.idValueBasedContent.size();
    }

    @Override
    public Collection<Object> values() {
        return this.idValueBasedContent.values();
    }
}

