/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.cache.xindice;

import com.cognos.xqe.cache.transformer.Transformer;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.ibm.bi.org.apache.hadoop.io.CryptoProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xindice.core.data.Key;
import org.apache.xindice.core.data.Record;
import org.apache.xindice.core.data.RecordSet;
import org.apache.xindice.core.data.Value;
import org.apache.xindice.core.filer.BTreeFiler;
import org.apache.xindice.core.filer.Filer;
import org.apache.xindice.util.Configuration;
import org.apache.xindice.util.XindiceException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XindiceBackedMap<K, V>
implements Map<K, V> {
    private static final String TBL_EXTENSION = ".tbl";
    private static final String XINDICE_CONFIG_ROOT_COLLECTION = "root-collection";
    private static final String XINDICE_CONFIG_DBNAME = "name";
    private static final String XINDICE_CONFIG_DBROOT = "dbroot";
    public static final String CACHE_ROOT_DIR = "CacheRootDir";
    private static final boolean TESTING_MODE = false;
    private Filer filer;
    private final File cacheFile;
    private long lastModTime;
    private final Transformer<K, V> transformer;
    private final boolean autoFlushEnabled;
    private final boolean useCompression;
    private final boolean useEncryption;

    public XindiceBackedMap(String name, Transformer<K, V> theTransformer, boolean reuse, boolean autoFlush, boolean compressed, boolean encrypted) {
        this(new File(name), theTransformer, reuse, autoFlush, compressed, encrypted);
    }

    public XindiceBackedMap(File theCacheFile, Transformer<K, V> theTransformer, boolean reuse, boolean autoFlush, boolean compressed, boolean encrypted) {
        if (theCacheFile.isDirectory()) {
            throw new XQERuntimeException(XQEMessageKeys.CSH_CacheFileNameWasDir, theCacheFile.getPath());
        }
        if (theCacheFile.getName().equals("")) {
            throw new XQERuntimeException(XQEMessageKeys.CSH_CacheFileNameEmpty);
        }
        if (!theCacheFile.getName().endsWith(TBL_EXTENSION)) {
            throw new XQERuntimeException(XQEMessageKeys.CSH_CacheFileNameMissingTBL);
        }
        this.cacheFile = theCacheFile;
        this.lastModTime = this.cacheFile.lastModified();
        this.autoFlushEnabled = autoFlush;
        this.useCompression = compressed;
        this.useEncryption = encrypted;
        try {
            this.filer = this.getFiler(reuse);
        }
        catch (XindiceException e) {
            throw new XQERuntimeException(e);
        }
        this.transformer = theTransformer;
    }

    private Filer getOrCreateFiler() throws XindiceException {
        return this.getFiler(true);
    }

    private synchronized Filer getFiler(boolean reuse) throws XindiceException {
        if (this.filer == null) {
            this.filer = new BTreeFiler();
        }
        if (!this.filer.isOpened()) {
            if (this.filer.getConfig() == null) {
                Configuration config = this.getXindiceConfiguration();
                this.filer.setConfig(config);
                this.setFilerLocation(this.filer);
            }
            this.openFiler(this.filer, reuse);
            this.lastModTime = this.cacheFile.lastModified();
        } else if (this.cacheFile.lastModified() > this.lastModTime) {
            Filer temp = this.filer;
            this.filer = null;
            try {
                this.filer = this.getFiler(true);
                temp.close();
            }
            finally {
                if (null == this.filer) {
                    this.filer = temp;
                }
            }
        }
        return this.filer;
    }

    private String getFilerDirectory() {
        String dir = System.getProperty(CACHE_ROOT_DIR);
        if (dir == null) {
            dir = System.getProperty("java.io.tmpdir");
        }
        return dir;
    }

    private void openFiler(Filer theFiler, boolean reuse) throws XindiceException {
        if (theFiler.isOpened()) {
            return;
        }
        this.createFilerDirectory(theFiler);
        boolean needsCreating = false;
        if (theFiler.exists()) {
            if (!reuse) {
                if (!theFiler.drop()) {
                    throw new XQERuntimeException(XQEMessageKeys.CSH_XindiceFilerDropFailed, this.cacheFile.getAbsolutePath());
                }
                needsCreating = true;
            } else if (this.cacheFile.length() == 0L) {
                needsCreating = true;
            }
        } else {
            needsCreating = true;
        }
        if (needsCreating && !theFiler.create()) {
            throw new XQERuntimeException(XQEMessageKeys.CSH_XindiceFilerCreateFailed, this.cacheFile.getAbsolutePath());
        }
        if (!theFiler.open()) {
            throw new XQERuntimeException(XQEMessageKeys.CSH_XindiceFilerOpenFailed, this.cacheFile.getAbsolutePath());
        }
    }

    private void createFilerDirectory(Filer theFiler) {
        Configuration config = theFiler.getConfig();
        if (config == null) {
            throw new XQERuntimeException(XQEMessageKeys.CSH_XindiceConfigMissing);
        }
        String dbroot = (config = config.getChild(XINDICE_CONFIG_ROOT_COLLECTION)).getAttribute(XINDICE_CONFIG_DBROOT);
        File cacheDir = new File(dbroot);
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
    }

    private Configuration getXindiceConfiguration() {
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            InputSource src = new InputSource(new StringReader("<xindice>    <root-collection dbroot='./db/' name='db'>        <queryengine>            <resolver autoindex='false' class='org.apache.xindice.core.query.XPathQueryResolver'/>            <resolver class='org.apache.xindice.core.xupdate.XUpdateQueryResolver'/>        </queryengine>    </root-collection>    <xml-rpc>        <driver name='xerces'/>    </xml-rpc></xindice>"));
            document = parser.parse(src);
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.CSH_XindiceConfigError, (Throwable)e);
        }
        Configuration config = new Configuration(document, false);
        String filerDirectory = this.getFilerDirectory();
        if (null != this.cacheFile.getParent() && !this.cacheFile.isDirectory()) {
            try {
                filerDirectory = this.cacheFile.getParentFile().getCanonicalPath();
            }
            catch (IOException e) {
                throw new XQERuntimeException(XQEMessageKeys.CSH_XindiceConfigError, (Throwable)e);
            }
        }
        try {
            String fileName = this.cacheFile.getName().replaceAll("\\.tbl$", "");
            config.getChild(XINDICE_CONFIG_ROOT_COLLECTION).setAttribute(XINDICE_CONFIG_DBROOT, filerDirectory);
            config.getChild(XINDICE_CONFIG_ROOT_COLLECTION).setAttribute(XINDICE_CONFIG_DBNAME, fileName);
            config.setAttribute("maxkeysize", 8);
        }
        catch (XindiceException e) {
            throw new XQERuntimeException(XQEMessageKeys.CSH_XindiceConfigError, (Throwable)e);
        }
        return config;
    }

    private void setFilerLocation(Filer theFiler) {
        Configuration config = theFiler.getConfig();
        if (config == null) {
            throw new XQERuntimeException(XQEMessageKeys.CSH_XindiceConfigMissing);
        }
        config = config.getChild(XINDICE_CONFIG_ROOT_COLLECTION);
        String dbroot = config.getAttribute(XINDICE_CONFIG_DBROOT);
        String dbname = config.getAttribute(XINDICE_CONFIG_DBNAME);
        theFiler.setLocation(new File(dbroot), dbname);
    }

    public boolean isAutoFlushEnabled() {
        return this.autoFlushEnabled;
    }

    public boolean isCompressed() {
        return this.useCompression;
    }

    public boolean isEncrypted() {
        return this.useEncryption;
    }

    public synchronized void flush() {
        try {
            if (null != this.filer) {
                this.filer.flush();
            }
        }
        catch (XindiceException e) {
            throw new XQERuntimeException(XQEMessageKeys.CSH_XindiceError, (Throwable)e);
        }
    }

    public synchronized boolean close() {
        try {
            if (null != this.filer) {
                boolean bl = this.filer.close();
                return bl;
            }
        }
        catch (XindiceException e) {
            throw new XQERuntimeException(XQEMessageKeys.CSH_XindiceError, (Throwable)e);
        }
        finally {
            this.filer = null;
        }
        return false;
    }

    @Override
    public synchronized void clear() {
        try {
            if (null != this.filer) {
                this.filer.close();
                this.filer = null;
                this.filer = this.getFiler(false);
            }
        }
        catch (XindiceException e) {
            throw new XQERuntimeException(XQEMessageKeys.CSH_XindiceError, (Throwable)e);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.getRecord(key) != null;
    }

    private Record getRecord(Object key) {
        Record answer = null;
        try {
            answer = this.getOrCreateFiler().readRecord(this.createKey(key));
        }
        catch (XindiceException e) {
            throw new XQERuntimeException(XQEMessageKeys.CSH_XindiceError, (Throwable)e);
        }
        return answer;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return this.values().contains(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        Record record = this.getRecord(key);
        if (record == null) {
            return null;
        }
        Value v = record.getValue();
        ObjectInputStream stream = this.getObjectInputStream(v);
        V returnedValue = null;
        try {
            V v2 = returnedValue = (V)this.transformer.inflateValue(stream);
            return v2;
        }
        finally {
            block8: {
                try {
                    stream.close();
                }
                catch (IOException ex) {
                    if (returnedValue == null) break block8;
                    throw new XQERuntimeException(XQEMessageKeys.CSH_ValueInflationError, (Throwable)ex);
                }
            }
        }
    }

    private ObjectInputStream getObjectInputStream(Value v) {
        InputStream is = new ByteArrayInputStream(v.getData());
        ObjectInputStream answer = null;
        try {
            if (this.isEncrypted()) {
                try {
                    is = CryptoProvider.createDecryptingInputStream((InputStream)is);
                }
                catch (Exception ex) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)ex);
                }
            }
            if (this.isCompressed()) {
                is = new GZIPInputStream(is);
            }
            answer = new ObjectInputStream(is);
        }
        catch (IOException ex) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)ex);
        }
        return answer;
    }

    private ObjectOutputStream getObjectOutputStream(ByteArrayOutputStream bos) {
        OutputStream os = bos;
        ObjectOutputStream answer = null;
        try {
            if (this.isEncrypted()) {
                try {
                    os = CryptoProvider.createEncryptingOutputStream((OutputStream)os);
                }
                catch (Exception ex) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)ex);
                }
            }
            if (this.isCompressed()) {
                os = new GZIPOutputStream(os);
            }
            answer = new ObjectOutputStream(os);
        }
        catch (IOException ex) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)ex);
        }
        return answer;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        Key k = this.createKey(key);
        V answer = null;
        try {
            Record record = this.getOrCreateFiler().readRecord(k);
            if (null != record) {
                ObjectInputStream stream = this.getObjectInputStream(record.getValue());
                try {
                    answer = this.transformer.inflateValue(stream);
                }
                finally {
                    block13: {
                        try {
                            stream.close();
                        }
                        catch (IOException ex) {
                            if (answer == null) break block13;
                            throw new XQERuntimeException(XQEMessageKeys.CSH_ValueInflationError, (Throwable)ex);
                        }
                    }
                }
            }
            this.getOrCreateFiler().writeRecord(k, this.createValue(value));
            if (this.isAutoFlushEnabled()) {
                this.getOrCreateFiler().flush();
            }
            this.lastModTime = System.currentTimeMillis();
        }
        catch (XindiceException e) {
            throw new XQERuntimeException(XQEMessageKeys.CSH_XindiceError, (Throwable)e);
        }
        return answer;
    }

    public void putFast(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        try {
            this.getOrCreateFiler().writeRecord(this.createKey(key), this.createValue(value));
            if (this.isAutoFlushEnabled()) {
                this.getOrCreateFiler().flush();
            }
            this.lastModTime = System.currentTimeMillis();
        }
        catch (XindiceException e) {
            throw new XQERuntimeException(XQEMessageKeys.CSH_XindiceError, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value createValue(V value) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream stream = this.getObjectOutputStream(bos);
        boolean success = false;
        try {
            this.transformer.serializeValue(value, stream);
            success = true;
        }
        finally {
            block8: {
                try {
                    stream.close();
                }
                catch (IOException ex) {
                    if (!success) break block8;
                    throw new XQERuntimeException(XQEMessageKeys.CSH_ValueDeflationError, (Throwable)ex);
                }
            }
        }
        return new Value(bos.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Key createKey(K key) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream stream = this.getObjectOutputStream(bos);
        boolean success = false;
        try {
            this.transformer.serializeKey(key, stream);
            success = true;
        }
        finally {
            block8: {
                try {
                    stream.close();
                }
                catch (IOException ex) {
                    if (!success) break block8;
                    throw new XQERuntimeException(XQEMessageKeys.CSH_KeyDeflationError, (Throwable)ex);
                }
            }
        }
        return new Key(bos.toByteArray());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        try {
            Filer theFiler = this.getOrCreateFiler();
            for (Map.Entry<K, V> entry : map.entrySet()) {
                K key = entry.getKey();
                V value = entry.getValue();
                if (key == null) {
                    throw new NullPointerException("Null key is not supported");
                }
                theFiler.writeRecord(this.createKey(key), this.createValue(value));
                this.lastModTime = System.currentTimeMillis();
            }
            if (this.isAutoFlushEnabled()) {
                theFiler.flush();
            }
        }
        catch (XindiceException e) {
            throw new XQERuntimeException(XQEMessageKeys.CSH_XindiceError, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        Record record = this.getRecord(key);
        if (record == null) {
            return null;
        }
        Value value = record.getValue();
        ObjectInputStream stream = this.getObjectInputStream(value);
        V answer = null;
        try {
            answer = this.transformer.inflateValue(stream);
        }
        finally {
            block12: {
                try {
                    stream.close();
                }
                catch (IOException ex) {
                    if (answer == null) break block12;
                    throw new XQERuntimeException(XQEMessageKeys.CSH_ValueInflationError, (Throwable)ex);
                }
            }
        }
        try {
            this.getOrCreateFiler().deleteRecord(this.createKey(key));
            if (this.isAutoFlushEnabled()) {
                this.getOrCreateFiler().flush();
            }
            this.lastModTime = System.currentTimeMillis();
        }
        catch (XindiceException e) {
            throw new XQERuntimeException(XQEMessageKeys.CSH_XindiceError, (Throwable)e);
        }
        return answer;
    }

    public boolean removeFast(K key) {
        try {
            if (this.getOrCreateFiler().deleteRecord(this.createKey(key))) {
                if (this.isAutoFlushEnabled()) {
                    this.getOrCreateFiler().flush();
                }
                this.lastModTime = System.currentTimeMillis();
                return true;
            }
            return false;
        }
        catch (XindiceException e) {
            throw new XQERuntimeException(XQEMessageKeys.CSH_XindiceError, (Throwable)e);
        }
    }

    @Override
    public int size() {
        int answer = 0;
        try {
            long recordCount = this.getOrCreateFiler().getRecordCount();
            answer = recordCount < Integer.MAX_VALUE ? (int)recordCount : Integer.MAX_VALUE;
        }
        catch (XindiceException e) {
            throw new XQERuntimeException(XQEMessageKeys.CSH_XindiceError, (Throwable)e);
        }
        return answer;
    }

    @Override
    public Collection<V> values() {
        return new ValueSet();
    }

    private final class ValueSet
    extends AbstractSet<V> {
        private ValueSet() {
        }

        @Override
        public Iterator<V> iterator() {
            return new Iter();
        }

        @Override
        public int size() {
            return XindiceBackedMap.this.size();
        }

        private class Iter
        implements Iterator<V> {
            private final Iterator<Map.Entry<K, V>> entryIter;

            Iter() {
                this.entryIter = XindiceBackedMap.this.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.entryIter.hasNext();
            }

            @Override
            public V next() {
                Map.Entry entry = this.entryIter.next();
                if (null == entry) {
                    return null;
                }
                return entry.getValue();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new Iter();
        }

        @Override
        public int size() {
            return XindiceBackedMap.this.size();
        }

        private class Iter
        implements Iterator<K> {
            private final Iterator<Map.Entry<K, V>> entryIter;

            Iter() {
                this.entryIter = XindiceBackedMap.this.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.entryIter.hasNext();
            }

            @Override
            public K next() {
                Map.Entry entry = this.entryIter.next();
                if (null == entry) {
                    return null;
                }
                return entry.getKey();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iter();
        }

        @Override
        public int size() {
            return XindiceBackedMap.this.size();
        }

        private class Iter
        implements Iterator<Map.Entry<K, V>> {
            private final RecordSet recordSet;
            private final long modTime;

            Iter() {
                this.modTime = XindiceBackedMap.this.lastModTime;
                try {
                    this.recordSet = XindiceBackedMap.this.getOrCreateFiler().getRecordSet();
                }
                catch (XindiceException e) {
                    throw new XQERuntimeException(XQEMessageKeys.CSH_XindiceError, (Throwable)e);
                }
            }

            @Override
            public boolean hasNext() {
                if (this.modTime != XindiceBackedMap.this.lastModTime) {
                    throw new ConcurrentModificationException();
                }
                try {
                    return this.recordSet.hasMoreRecords();
                }
                catch (XindiceException e) {
                    throw new XQERuntimeException(XQEMessageKeys.CSH_XindiceError, (Throwable)e);
                }
            }

            @Override
            public Map.Entry<K, V> next() {
                if (this.modTime != XindiceBackedMap.this.lastModTime) {
                    throw new ConcurrentModificationException();
                }
                try {
                    if (!this.recordSet.hasMoreRecords()) {
                        return null;
                    }
                    Record rec = this.recordSet.getNextRecord();
                    if (null == rec) {
                        return null;
                    }
                    return new XindiceBackedMapEntry(rec);
                }
                catch (XindiceException e) {
                    throw new XQERuntimeException(XQEMessageKeys.CSH_XindiceError, (Throwable)e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private class XindiceBackedMapEntry
    implements Map.Entry<K, V> {
        Record record;

        XindiceBackedMapEntry(Record theRecord) {
            this.record = theRecord;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K getKey() {
            Key k = this.record.getKey();
            ObjectInputStream stream = XindiceBackedMap.this.getObjectInputStream((Value)k);
            Object answer = null;
            try {
                answer = XindiceBackedMap.this.transformer.inflateKey(stream);
            }
            finally {
                block8: {
                    try {
                        stream.close();
                    }
                    catch (IOException ex) {
                        if (answer == null) break block8;
                        throw new XQERuntimeException(XQEMessageKeys.CSH_KeyInflationError, (Throwable)ex);
                    }
                }
            }
            return answer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V getValue() {
            Value v = this.record.getValue();
            ObjectInputStream stream = XindiceBackedMap.this.getObjectInputStream(v);
            Object answer = null;
            try {
                answer = XindiceBackedMap.this.transformer.inflateValue(stream);
            }
            finally {
                block8: {
                    try {
                        stream.close();
                    }
                    catch (IOException ex) {
                        if (answer == null) break block8;
                        throw new XQERuntimeException(XQEMessageKeys.CSH_ValueInflationError, (Throwable)ex);
                    }
                }
            }
            return answer;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }
}

