/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.config;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.platform.datasetutils.parquet.ParquetVersionEnum;

public final class ConfigService {
    private static final XQELogger TRACE_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "ConfigurationService", LogLevel.INFO);
    private static final String SLASH = "/";
    private static final String DATASET_SERVICE_PQ_VERSION = "DatasetService.parquetVersion";
    private static final String DATASET_SERVICE_ENABLE_ENCRYPTION = "DatasetService.enableEncryption";
    private static final boolean DEFAULT_DATASET_SERVICE_ENABLE_ENCRYPTION = true;
    private static final String DATASET_CLEANUP_FREQUENCY = "DatasetService.cleanupFrequency";
    private static final String DATASET_MAXIMUM_AGE = "DatasetService.maxAge";
    private static final long DEFAULT_DATASET_CLEANUP_FREQUENCY = 3600L;
    private static final long DEFAULT_DATASET_MAXIMUM_AGE = 604800L;
    private static final String DATASET_MAX_REFRESH_WAITTIME = "ModelingService.dataset2MaxRefreshWaitTime";
    private static final String DATASET_MODIFICATION_THRESHOLD = "ModelingService.dataset2ModificationThreshold";
    private static final long DEFAULT_DATASET_MAX_REFRESH_WAITTIME = 60000L;
    private static final long DEFAULT_DATASET_MODIFICATION_THRESHOLD = 300000L;
    private static final String DATASET_MAX_UPLOAD_SIZE = "DatasetService.maxUploadSizeMBytes";
    private static final int DEFAULT_DATASET_MAX_UPLOAD_SIZE = 100;
    private static final String DATASET_MAX_STORAGE = "DatasetService.maxStorageMBytes";
    private static final int DEFAULT_DATASET_MAX_STORAGE = 10000;
    private static ConfigService configService = new ConfigService();

    private ConfigService() {
    }

    public static ConfigService getInstance() {
        return configService;
    }

    public static void setInstance(ConfigService conf) {
        configService = conf;
    }

    private static long getLong(String id, long defaultValue) {
        try {
            return ConfigurationPropertyFactory.getInstance().getLongProperty(id, defaultValue).get();
        }
        catch (Exception e) {
            TRACE_LOGGER.log(LogLevel.WARN, "Failed to get integer value for config key: " + id, (Throwable)e);
            return defaultValue;
        }
    }

    private static String getString(String id, String defaultValue) {
        try {
            return ConfigurationPropertyFactory.getInstance().getStringProperty(id, defaultValue).get();
        }
        catch (Exception e) {
            TRACE_LOGGER.log(LogLevel.WARN, "Failed to get String value for config key: " + id, (Throwable)e);
            return defaultValue;
        }
    }

    private static boolean getBoolean(String id, boolean defaultValue) {
        try {
            return ConfigurationPropertyFactory.getInstance().getBooleanProperty(id, defaultValue).get();
        }
        catch (Exception e) {
            TRACE_LOGGER.log(LogLevel.WARN, "Failed to get boolean value for config key: " + id, (Throwable)e);
            return defaultValue;
        }
    }

    public boolean getDatasetServiceEnableEncryption() {
        return ConfigService.getBoolean(DATASET_SERVICE_ENABLE_ENCRYPTION, true);
    }

    public String getDatasetServiceDirectory() {
        String result = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE).getDatasetDirectory();
        return this.sanitizeDataServiceDirectory(result);
    }

    public String getDatasetServicePQVersion() {
        return ConfigService.getString(DATASET_SERVICE_PQ_VERSION, ParquetVersionEnum.VERSION_1.getValue());
    }

    public String getDatasetCacheDirectory() {
        return this.getDatasetServiceDirectory() + "datasetCache/";
    }

    public long getDatasetCleanupFrequency() {
        return ConfigService.getLong(DATASET_CLEANUP_FREQUENCY, 3600L);
    }

    public long getDatasetCleanupMaxAge() {
        return ConfigService.getLong(DATASET_MAXIMUM_AGE, 604800L);
    }

    private String sanitizeDataServiceDirectory(String p) {
        String path = p.replace('\\', '/');
        if (!path.endsWith(SLASH)) {
            path = path + SLASH;
        }
        if (path.startsWith("../")) {
            String dataDir = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE).getBinDirectory();
            dataDir = dataDir.replace('\\', '/');
            return dataDir + SLASH + path;
        }
        if (path.startsWith(SLASH)) {
            return path;
        }
        if (path.matches("(?is)[A-Z]:.*")) {
            return path;
        }
        return SLASH + path;
    }

    public long getMaxWaitTimeDataset2Refresh() {
        return ConfigService.getLong(DATASET_MAX_REFRESH_WAITTIME, 60000L);
    }

    public long getDatasetLastModifiedThreshold() {
        return ConfigService.getLong(DATASET_MODIFICATION_THRESHOLD, 300000L);
    }

    public long getMaxUploadSizeMBytes() {
        return ConfigService.getLong(DATASET_MAX_UPLOAD_SIZE, 100L);
    }

    public long getMaxStorageMBytes() {
        return ConfigService.getLong(DATASET_MAX_STORAGE, 10000L);
    }
}

