/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.config;

import com.cognos.xqe.config.ConfigFileException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.pool.XQESAXReaderPool;
import java.io.File;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;

public class RSVPProperties {
    private static final String RSVP_PROPERTIES_FILE_NAME = "rsvpproperties.xml";
    public static final String DEFAULT_SESSION_TIMEOUT_NAME = "SessionInactivityTimeout";
    public static final String DEFAULT_SESSION_TIMEOUT_VALUE = "3600";
    private final Element root;

    public RSVPProperties(String effectiveConfigurationDirectoryPath) {
        this(new File(effectiveConfigurationDirectoryPath, RSVP_PROPERTIES_FILE_NAME));
    }

    public RSVPProperties(File rsvpPropertiesFile) {
        this.root = RSVPProperties.getRootElement(rsvpPropertiesFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Element getRootElement(File rsvpPropertiesFile) {
        Element root;
        block5: {
            root = null;
            try {
                if (!rsvpPropertiesFile.exists()) break block5;
                SAXReader saxReader = XQESAXReaderPool.getInstance().borrowReader();
                try {
                    Document doc = saxReader.read(rsvpPropertiesFile);
                    root = doc.getRootElement();
                }
                finally {
                    XQESAXReaderPool.getInstance().returnReader(saxReader);
                }
            }
            catch (Exception exception) {
                throw new ConfigFileException(XQEMessageKeys.CFG_FileLoadError, (Throwable)exception, rsvpPropertiesFile.getAbsolutePath());
            }
        }
        return root;
    }

    public String getPropertyValue(String propertyName) {
        String result = null;
        if (null != this.root) {
            XPath xpath = DocumentHelper.createXPath((String)("/rsvp_property/structure[normalize-space(property)='" + propertyName + "']/value"));
            List nodeList = CollectionCast.uncheckedCast(xpath.selectNodes((Object)this.root));
            if (nodeList.size() == 1) {
                result = ((Node)nodeList.get(0)).getText();
            } else if (nodeList.size() > 1) {
                XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Resources.Session", LogLevel.WARN).log(LogLevel.WARN, "Two many " + propertyName + " defined, ignoring");
            }
        }
        return result;
    }

    public String getSessionTimeOut() {
        return this.getPropertyValue(DEFAULT_SESSION_TIMEOUT_NAME);
    }
}

