/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.config;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.xqe.config.AbstractXQEXMLConfiguration;
import com.cognos.xqe.config.ConfigFileException;
import com.cognos.xqe.config.ConfigMutexLockException;
import com.cognos.xqe.config.EnvironmentVariableStrLookup;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationFactory;
import com.cognos.xqe.config.XQEConfigurationEvent;
import com.cognos.xqe.config.XQEConfigurationListener;
import com.cognos.xqe.config.XQEPeriodicallyReloadableXMLConfigurationWithLogs;
import com.cognos.xqe.config.XQESubConfiguration;
import com.cognos.xqe.config.XQEXMLConfiguration;
import com.cognos.xqe.cubingservices.CommonClassesFactory;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.runtree.olap.mdx.platform.Environment;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.FileUtil;
import com.cognos.xqe.util.ParameterAccessCoordinator;
import com.cognos.xqe.util.ParameterMapsApp;
import com.cognos.xqe.util.ResourceLocator;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.io.File;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.text.StrLookup;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.XPath;

public class XQEConfiguration {
    public static final String STANDALONE_MODE = "general.standAloneMode[@enabled]";
    private static final String JCAMCRYPTO_ENABLED = "general.jcamcrypto[@enabled]";
    private static final String STRING_STRING = "%s%s";
    private static final Logger LOG = Logger.getLogger(XQEConfiguration.class.getName());
    private static final String ENV = "env";
    public static final String XML_VALUE_TRUE = "true";
    public static final String XML_VALUE_FALSE = "false";
    public static final int MS_IN_SECOND = 1000;
    public static final int S_IN_MINUTE = 60;
    public static final int C_10 = 10;
    private static final String SLASH = "/";
    private static final String DATASETS = "datafiles";
    private static final String MOSER = "moser";
    public static final String XML_ATTRIBUTE_NAME = "[@name]";
    public static final String XML_ATTRIBUTE_PRIORITY = "[@priority]";
    public static final String XML_ATTRIBUTE_VALUE = "[@value]";
    public static final String XML_ATTRIBUTE_ENABLED = "[@enabled]";
    public static final String CACHE_QUERY_PLANS_KEY = "general.cacheQueryPlans";
    public static final String CACHE_MA_QUERY_RESULT_KEY = "general.cacheMAQueryResults";
    public static final String MEMORY_MONITOR = "general.memoryMonitor";
    public static final String MEMORY_MONITOR_NOTIFICATIONS = "general.memoryMonitor.notifications";
    public static final String MEMORY_MONITOR_STATISTICS = "general.memoryMonitor.statistics";
    public static final String RESOURCE_MONITOR = "resourceMonitor";
    public static final String RESOURCE_MONITOR_ENABLED = "resourceMonitor.enabled";
    public static final String RESOURCE_MONITOR_BALLAST_ENABLED = "resourceMonitor.ballastEnabled";
    public static final String RESOURCE_MONITOR_GC_ENABLED = "resourceMonitor.gcEnabled";
    public static final String RESOURCE_MONITOR_MEMORY_COUNTING_ENABLED = "resourceMonitor.memoryCountingEnabled";
    public static final String RESOURCE_MONITOR_OVERLOADED_PERCENT = "resourceMonitor.overloadedPercent";
    public static final String RESOURCE_MONITOR_CACHE_CLEARING_ENABLED = "resourceMonitor.cacheClearingEnabled";
    public static final String RESOURCE_MONITOR_BALANCED_GC_ENABLED = "resourceMonitor.balancedGCEnabled";
    public static final String RESOURCE_MONITOR_ORACLE_JVM_ENABLED = "resourceMonitor.oracleJVMEnabled";
    public static final String RESOURCE_MONITOR_MAX_QUERIES = "resourceMonitor.maxQueries";
    public static final String RESOURCE_MONITOR_CANCEL_DELAY = "resourceMonitor.cancelDelay";
    public static final String RESOURCE_MONITOR_CANCEL_RAMPUP_PERCENTAGE = "resourceMonitor.cancelRampupPercentage";
    public static final String RESOURCE_MONITOR_BALLAST_PERCENTAGE = "resourceMonitor.ballastPercentage";
    public static final String RESOURCE_MONITOR_GC_RETRY_PERIOD = "resourceMonitor.gcRetryPeriod";
    public static final String RESOURCE_MONITOR_GC_ITERATIONS = "resourceMonitor.gcIterations";
    public static final String HEALTH_ENABLED = "health[@enabled]";
    public static final String HEALTH_MIN_SUCCESS_RATE = "health.minSuccessRate[@value]";
    public static final String HEALTH_MIN_OVERALL_REQUESTS = "health.minOverallRequests[@value]";
    public static final String HEALTH_MIN_SUCCESS_RATE_MINUTE = "health.minSuccessRateMinute[@value]";
    public static final String HEALTH_CONSECUTIVE_TIMES_MIN_SUCCESS_RATE_MINUTE_FAILURES = "health.maxConsecutiveTimesSuccessRateMinuteFailures[@value]";
    public static final String DUMP_MODEL_KEY = "metadataService.dumpModel";
    public static final String DEFAULT_PROVIDER_IDLE_CONNECTION_KEY = "providers.defaultIdleConnectionTimeout";
    public static final String JVM_INITIAL_HEAP_SIZE = "jvm.qsInitialJVMHeapSize";
    public static final String JVM_HEAP_SIZE_LIMIT = "jvm.qsJVMHeapSizeLimit";
    public static final String JVM_ADDITIONAL_ARGUMENTS = "jvm.qsAdditionalJVMArguments";
    public static final String JVM_DISABLE_VERBOSE_GC_LOGGING = "jvm.qsDisableVerboseGCLogging";
    public static final String JVM_VERBOSE_GC_LOG_LIMIT = "jvm.qsVerboseGCLogLimit";
    public static final String JVM_GC_POLICY = "jvm.qsGCPolicy";
    public static final String JVM_INITIAL_NURSERY_SIZE = "jvm.qsInitialJVMNurserySize";
    public static final String JVM_NURSERY_SIZE_LIMIT = "jvm.qsJVMNurserySizeLimit";
    public static final String GENERATE_COMMENTS_IN_NATIVE_SQL_PORTAL = "queryPlanning.qsGenerateCommentsInNativeSQL";
    public static final String GENERATE_COMMENTS_IN_NATIVE_SQL = "queryPlanning.generateCommentsInNativeSQL[@enabled]";
    public static final String STRICT_DBFUNCTION_RETURN_TYPE = "queryPlanning.strictDBFunctionReturnType[@enabled]";
    public static final String SUBSTRING_RETURN_STRING = "queryPlanning.substringReturnsString[@value]";
    public static final String SHORTEN_IDENTIFIER_NAME = "queryPlanning.shortenIdentifierName[@enabled]";
    public static final String PUSH_CALCULATIONS_TO_INNER_QUERY = "queryPlanning.qsPushCalculationsToInnerQuery[@enabled]";
    public static final String PUSH_FILTERS_TO_INNER_QUERY = "queryPlanning.qsPushFiltersToInnerQuery[@enabled]";
    public static final String ROLAP_MANUAL_CUBE_START = "rolap.qsManualCubeStart";
    public static final String ROLAP_MEMBER_CACHE_ALIAS_ROOT = "rolap.qsROLAPMemberCacheAliasRoot";
    public static final String ROLAP_MULTI_DIMENSIONAL_QUERY_SIZE_LIMIT = "rolap.qsMultiDimensionalQuerySizeLimit";
    public static final String ROLAP_RESULT_SET_CACHE_QUERY_TIME_THRESHOLD = "rolap.qsResultSetCacheQueryTimeThreshold";
    public static final String ROLAP_CUBE_ADMINISTRATION_COMMAND_TIMEOUT = "rolap.qsROLAPCubeAdministrationCommandTimeout";
    public static final String ROLAP_CUBE_CONFIGURATIONS = "rolap.cubeconfigurations";
    public static final String ROLAP_MESSAGE_CLEANUP_PERIOD = "rolap.adminMessageExpiry[@value]";
    public static final long ROLAP_MESSAGE_CLEANUP_PERIOD_DEFAULT = 86400L;
    public static final String PRIMING_REPORT_NAME_PREFIX = "qsPrimingReportNamePrefix";
    public static final String MAX_CROSSJOIN_SIZE = "qsMaxCrossjoinOrderOfMagnitude";
    public static final int DEFAULT_MAX_CROSSJOIN_SIZE = 8;
    public static final String INTERACTIVE_CROSSJOIN_SIZE = "qsMaxCrossjoinInteractiveOrderOfMagnitude";
    public static final int INTERACTIVE_MAX_CROSSJOIN_SIZE = 5;
    public static final String USE_NATIVE_TM1_ENGINE = "qsUseNativeTM1Engine";
    public static final Boolean DEFAULT_USE_NATIVE_TM1_ENGINE;
    public static final String USE_NATIVE_TM1_ENGINE_ENABLE = "queryExecution.useNativeTM1Engine[@enabled]";
    public static final String CHECK_SUPPRESS_QUERY_HINT_TMR = "qsCheckSuppressQueryHintForTMR";
    public static final String CHECK_SUPPRESS_QUERY_HINT_TMR_ENABLED = "queryExecution.checkSuppressQueryHintForTMR[@enabled]";
    public static final String LOG_TM1_REST_FORMATTED_VALUE_ENABLE = "queryExecution.logTM1RESTFormattedValue[@enabled]";
    public static final String VALIDATE_TM1_REST_SELF_SIGNED_CERTIFICATES = "queryExecution.validateTM1RESTSelfSignedCertificates[@enabled]";
    public static final String VALIDATE_TM1_REST_PA_SUBSETS = "queryExecution.validateTM1RESTPASubsets[@enabled]";
    public static final String PA_USE_FILLER_MEMBER = "queryExecution.paUseFillerMember[@enabled]";
    public static final String PA_USE_ROOT_MEMBERS_API = "queryExecution.paUseRootMembers[@enabled]";
    public static final String PA_ENABLE_HIERARCHY_LOCALIZATION = "queryExecution.paEnableHierarchyLocalization[@enabled]";
    public static final String GENERATE_MIN_ON_FACET_SORT_ITEM = "queryPlanning.generateMinOnFacetSortItem[@enabled]";
    public static final int DEF_MAX_TM1_REST_HTTP_CONNECTIONS = 256;
    public static final String MAX_TM1_REST_HTTP_CONNECTIONS = "queryExecution.maxTM1RESTHttpConnections[@value]";
    public static final String MAX_PER_ROUTE_TM1_REST_HTTP_CONNECTIONS = "queryExecution.maxPerRouteTM1RESTHttpConnections[@value]";
    public static final String DATASET_PARQUET_BLOCK_SIZE = "dataset.parquet.blockSize[@value]";
    public static final String DATASET_PARQUET_PAGE_SIZE = "dataset.parquet.pageSize[@value]";
    public static final String DATASET_PARQUET_COMPRESSION_CODEC = "dataset.parquet.compression[@codec]";
    public static final String DATASET_PARQUET_PARQUET_VERSION = "dataset.parquet.parquetVersion[@value]";
    public static final int DEFAULT_DATASET_PARQUET_BLOCK_SIZE = 0xA00000;
    public static final int DEFAULT_DATASET_PARQUET_PAGE_SIZE = 0x100000;
    public static final String DEFAULT_DATASET_PARQUET_COMPRESSION_CODEC = "GZIP";
    public static final String DEFAULT_DATASET_PARQUET_PARQUET_VERSION = "VERSION_1";
    public static final String FLINT_SERVER_ENABLED = "queryExecution.flintServer[@enabled]";
    public static final String FLINT_SERVER_RESTART_ON_CONF_CHANGE_ENABLED = "queryExecution.flintServer.restartOnConfChange[@enabled]";
    public static final String FLINT_SERVER_HOSTNAME = "queryExecution.flintServer.host[@value]";
    public static final String FLINT_SERVER_PORT = "queryExecution.flintServer.port[@value]";
    public static final String FLINT_COMPUTESERVICE_PORT = "computeServicePort";
    public static final String FLINT_MIN_HEAP = "queryExecution.flintServer.memory[@minHeap]";
    public static final String FLINT_MAX_HEAP = "queryExecution.flintServer.memory[@maxHeap]";
    public static final String FLINT_MAX_DIRECT = "queryExecution.flintServer.memory[@maxDirect]";
    public static final String FLINT_SPARK_THREADS = "queryExecution.flintServer.sparkThreads[@value]";
    public static final String FLINT_MIN_THRIFT_WORKERS = "queryExecution.flintServer.thriftWorkers[@min]";
    public static final String FLINT_MAX_THRIFT_WORKERS = "queryExecution.flintServer.thriftWorkers[@max]";
    public static final String FLINT_EXTRA_JAVA_OPTIONS = "queryExecution.flintServer.extraJavaOptions[@value]";
    public static final String FLINT_EXTRA_FLINT_CONF = "queryExecution.flintServer.extraFlintConf";
    public static final String FLINT_LAZY_CONVERSION = "queryExecution.flintServer.lazyConversion[@enabled]";
    public static final String FLINT_DS_NAME = "queryExecution.flintServer.logicalDataSourceName[@value]";
    public static final String FLINT_QUERY_TIMEOUT_INTERVAL_CONF = "queryExecution.flintServer.queryTimeoutInterval[@value]";
    public static final String FLINT_SQL_LEVEL_CACHING = "queryExecution.flintServer.cache[@sqlEnabled]";
    public static final String FLINT_EXECUTE_TO_SERIALIZED_FILE = "queryExecution.flintServer.executeToSerializedFile[@enabled]";
    public static final String FLINT_DATASET_IDLE_SECONDS = "queryExecution.flintServer.datasetIdleSeconds[@value]";
    public static final String FLINT_MANAGED_DATASETS_LIMIT = "queryExecution.flintServer.managedDatasetsLimit[@value]";
    public static final String ENABLE_TM1_101_COMPATIBILITY_MODE = "queryPlanning.enableTM1_101CompatibilityMode[@value]";
    public static final String ALLOW_DATABASE_ONLY_PA = "qsAllowDatabaseOnlyForPA";
    public static final Boolean DEFAULT_ALLOW_DATABASE_ONLY_PA;
    public static final String DEFAULT_PRIMING_REPORT_NAME_PREFIX = "";
    public static final String LAST_CONFIGURE_REQUEST_TYPE = "lastConfigureRequestType";
    public static final String CONFIGURE_REQUEST_TYPE = "configure";
    public static final String RECONFIGURE_REQUEST_TYPE = "reconfigure";
    public static final String LOCK_WAIT_TIME = "general.lockWaitTimeInMs[@value]";
    public static final long LOCK_WAIT_TIME_DEFAULT = 1000L;
    public static final String CCL_CONFIG_AAA = "AAA";
    public static final String CCL_CONFIG_INACTIVITY_TIMEOUT = "inactivityTimeout";
    public static final String EXCESSIVE_COLLECTION_THRESHOLD = "general.gc.excessiveCollectionThreshold";
    public static final double EXCESSIVE_COLLECTION_THRESHOLD_DEFAULT = 0.8;
    public static final String EXCESSIVE_COLLECTION_CHECK_PERIOD = "general.gc.excessiveCollectionCheckPeriod";
    public static final long EXCESSIVE_COLLECTION_CHECK_PERIOD_DEFAULT = 60000L;
    public static final String EXCESSIVE_COLLECTION_SYSTEM_DUMP_ENABLED = "general.gc.excessiveCollectionSystemDumpEnabled";
    public static final boolean EXCESSIVE_COLLECTION_SYSTEM_DUMP_ENABLED_DEFAULT = false;
    private static final String DOT = ".";
    public static final String BURST_PREFETCH = "queryExecution.burstPrefetch";
    public static final String BURST_PREFECTH_MAX_RESULT_SETS = "queryExecution.burstPrefetch.maxResultSetPrefetch[@value]";
    public static final String BURST_PREFECTH_MIN_THREADS = "queryExecution.burstPrefetch.minThreads[@value]";
    public static final String BURST_PREFECTH_MAX_THREADS = "queryExecution.burstPrefetch.maxThreads[@value]";
    public static final String BURST_PREFECTH_MAX_MEMORY = "queryExecution.burstPrefetch.maxMemoryPerResultSet[@value]";
    public static final String SET_CONNECTION_ATTRS = "queryExecution.setConnectionAttributes";
    public static final String MAXROWS_LOCALPROCESSING = "queryExecution.maxRowsLocalProcessing[@value]";
    private static final String DIAGNOSTIC_PROPERTY = "diagnostics";
    private static final String ELEMENT_LEVEL = "[@level]";
    private static final String ELEMENT_LOGGER = "[@appender]";
    private static final String DEFAULT_LEVEL_PROPERTY = "diagnostics[@level]";
    private static final String DEFAULT_APPENDER_PROPERTY = "diagnostics[@appender]";
    private static final String DIAG_ENABLED_PROPERTY = "diagnostics[@enabled]";
    private static final String APPENDER_ELEMENT = ".appenders.appender";
    private static final String COMPONENT_ELEMENT = ".components.component";
    public static final String TEMP_DIRECTORY_KEY = "tempDirectory";
    public static final String TEMP_DIRECTORY_CONFIG_FILE_KEY = "general.tempDirectory[@value]";
    public static final String CONFIG_DIRECTORY_KEY = "configDirectory";
    public static final String DATASETS_FILE_DIRECTORY_KEY = "datasetsFileDirectory";
    public static final String DEFAULT_DATASETS_FILE_DIRECTORY = "../data/datasets";
    private final String datasetsFileDirectory;
    public static final String BIN_DIRECTORY_KEY = "binDirectory";
    public static final String DATA_DIRECTORY_KEY = "dataDirectory";
    public static final String DATA_DIRECTORY_CONFIG_FILE_KEY = "general.dataDirectory[@value]";
    public static final String LOG_FILE_APPENDER_KEY = "xqeLogFileAppender";
    public static final String LOG_FILE_APPENDER_KEY_CONFIG_FILE_KEY = "general.xqeLogFileAppender[@value]";
    public static final String DEFAULT_LOG_FILE_APPENDER = "";
    public static final String LOGS_DIRECTORY_KEY = "logsDirectory";
    public static final String EXTLIB_DIRECTORY_KEY = "extLibDirectory";
    public static final String DEFAULT_TEMP_DIRECTORY = "../temp";
    public static final String DEFAULT_CONFIGURATION_DIRECTORY = "../configuration";
    public static final String DEFAULT_DATA_DIRECTORY = "../data";
    public static final String DEFAULT_BIN_DIRECTORY = ".";
    public static final String DEFAULT_LOGS_DIRECTORY = "../logs";
    public static final String DEFAULT_EXTLIB_DIRECTORY = "../v5dataserver/lib/ext";
    public static final String SERVICE_SUBFOLDER_NAME = "XQE";
    public static final String ENHANCEDTM1FORMATPARSER = "qsUseEnhancedTM1FormatParser";
    public static final String FORMATTING_ENHANCEDTM1FORMATPARSER = "formatting.useEnhancedTM1FormatParser[@value]";
    public static final String CUSTOM_CONFIG_FILE_SUFFIX = ".config.custom.xml";
    public static final String CONFIG_FILE_SUFFIX_KEY = "configFileSuffix";
    public static final String LOG_CONFIG_FILE_NAME_KEY = "logConfigFilename";
    public static final String DEFAULT_CONFIG_FILE_SUFFIX = ".config.xml";
    public static final String DEV_CONFIG_FILE_SUFFIX = ".config.dev.xml";
    public static final String DSS_CONFIG_FILE_SUFFIX = ".config.dss.xml";
    public static final String CUSTOM_DSS_CONFIG_FILE_SUFFIX = ".config.dss.custom.xml";
    public static final String LOG_CONFIG_FILE_NAME = "xqe.diagnosticlogging.xml";
    public static final String COMPONENTS_CONFIG_FILE_SUFFIX = ".config.components.xml";
    public static final String LOAD_HIERARCHY_NAMED_SETS = "queryExecution.loadHierarchyNamedSets[@enabled]";
    public static final String APPROX_AGGREGATES_LGK_KEY = "queryExecution.approxAggregates.lgK[@value]";
    public static final int DEFAULT_APPROX_AGGREGATES_LGK = 12;
    public static final String QS_REST_TIMEOUT_ENABLED = "queryExecution.RESTTimeout[@enabled]";
    public static final String QS_REST_DEFAULT_TIMEOUT = "queryExecution.RESTDefaultTimeout[@value]";
    public static final String QS_REST_DEFAULT_PREDICT_TIMEOUT = "queryExecution.RESTDefaultPredictTimeout[@value]";
    public static final String QS_REST_MAX_TIMEOUT = "queryExecution.RESTMaxTimeout[@value]";
    public static final String QS_REST_WORKLOAD_MANAGEMENT_ENABLED = "queryExecution.RESTWorkloadManagement[@enabled]";
    public static final String QS_REST_WORKLOAD_MANAGEMENT_SUPERVISE_INTERVAL_MS = "queryExecution.RESTWorkloadManagement.superviseIntervalMs[@value]";
    public static final String QS_REST_WORKLOAD_MANAGEMENT_MAX_REQUEST_LOAD = "queryExecution.RESTWorkloadManagement.maxRequestLoad[@value]";
    public static final String QS_REST_WORKLOAD_MANAGEMENT_DEFAULT_POOL = "queryExecution.RESTWorkloadManagement.defaultPool[@value]";
    public static final String QS_REST_WORKLOAD_MANAGEMENT_MAX_PERMITS = "queryExecution.RESTWorkloadManagement.maxPermits[@value]";
    private final String configDirectory;
    private final String binDirectory;
    private final String dataDirectory;
    private File xqeTempDirectory;
    private File xqeDataDirectory;
    private File xqeLogsDirectory;
    private String xqeLogsFileAppender;
    private final String xqeExtLibDirectory;
    private final CompositeConfiguration configuration;
    private final XMLConfiguration dominantConfiguration;
    private final AbstractXQEXMLConfiguration[] individualConfigurations = new AbstractXQEXMLConfiguration[ConfigEnum.values().length];
    private final ServiceEnumeration serviceType;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private ParameterAccessCoordinator pac = null;
    private volatile boolean hasGenerateCommentsInNativeSQLFlippedPortal = false;

    protected AbstractXQEXMLConfiguration loadConfigFromFile(String fullFileName, boolean allowReload) {
        try {
            File cFile = new File(fullFileName);
            URL url = cFile.toURI().toURL();
            return this.loadConfiguration(url, allowReload);
        }
        catch (MalformedURLException e) {
            throw new ConfigFileException(XQEMessageKeys.CFG_FileLoadError, (Throwable)e, fullFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractXQEXMLConfiguration loadConfiguration(URL url, boolean allowReload) {
        AbstractXQEXMLConfiguration xmlConfiguration;
        Lock lock = this.rwLock.writeLock();
        try {
            lock.lockInterruptibly();
            try {
                xmlConfiguration = allowReload ? new XQEPeriodicallyReloadableXMLConfigurationWithLogs(url) : new XQEXMLConfiguration(url);
            }
            finally {
                lock.unlock();
            }
        }
        catch (ConfigurationException e) {
            throw new ConfigFileException(XQEMessageKeys.CFG_FileLoadError, (Throwable)e, url.toExternalForm());
        }
        catch (InterruptedException ie) {
            throw new ConfigMutexLockException(XQEMessageKeys.CFG_MutexLockFailure_INTERNAL, (Throwable)ie);
        }
        if (LOG.isLoggable(Level.CONFIG)) {
            LOG.config(String.format("loadConfiguration(%s, %s)", url, allowReload));
        }
        return xmlConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public XQEConfiguration(ServiceEnumeration type, Properties properties) {
        AbstractXQEXMLConfiguration custConfiguration;
        this.serviceType = type;
        this.configDirectory = properties.getProperty(CONFIG_DIRECTORY_KEY, DEFAULT_CONFIGURATION_DIRECTORY);
        this.datasetsFileDirectory = properties.getProperty(DATASETS_FILE_DIRECTORY_KEY, DEFAULT_DATASETS_FILE_DIRECTORY);
        this.binDirectory = properties.getProperty(BIN_DIRECTORY_KEY, ".");
        this.xqeExtLibDirectory = properties.getProperty(EXTLIB_DIRECTORY_KEY, DEFAULT_EXTLIB_DIRECTORY);
        this.configuration = new CompositeConfiguration();
        URL defaultConfigUrl = this.getDefaultConfigResourceURL(type, properties);
        URL customizedConfigUrl = this.getCustomizedConfigResourceURL(type, properties);
        URL devConfigUrl = this.getDevelopmentConfigResourceURL(type, properties);
        URL customizedDSSConfigUrl = this.getCustomizedDSSConfigResourceURL(type, properties);
        URL dssConfigUrl = this.getDSSConfigResourceURL(type, properties);
        URL logConfigUrl = this.getLoggingConfigResourceURL(type, properties);
        StringBuilder componentsConfig = new StringBuilder(type.name().toLowerCase());
        componentsConfig.append(COMPONENTS_CONFIG_FILE_SUFFIX);
        URL componentsConfigUrl = this.locateConfigurationResource(properties, componentsConfig.toString());
        boolean allowReload = true;
        if (devConfigUrl != null) {
            AbstractXQEXMLConfiguration devConfiguration = this.loadConfiguration(devConfigUrl, false);
            this.configuration.addConfiguration((Configuration)devConfiguration);
        }
        if (logConfigUrl != null) {
            AbstractXQEXMLConfiguration loggingConfiguration = this.loadConfiguration(logConfigUrl, true);
            this.configuration.addConfiguration((Configuration)loggingConfiguration);
            this.individualConfigurations[ConfigEnum.XQE_DIAGNOSTIC_LOGGING_CONFIG.ordinal()] = loggingConfiguration;
        }
        if (customizedDSSConfigUrl != null) {
            custConfiguration = this.loadConfiguration(customizedDSSConfigUrl, false);
            this.configuration.addConfiguration((Configuration)custConfiguration);
        }
        if (dssConfigUrl != null) {
            custConfiguration = this.loadConfiguration(dssConfigUrl, false);
            this.configuration.addConfiguration((Configuration)custConfiguration);
        }
        if (customizedConfigUrl != null) {
            custConfiguration = this.loadConfiguration(customizedConfigUrl, false);
            this.configuration.addConfiguration((Configuration)custConfiguration);
        }
        if (defaultConfigUrl != null) {
            AbstractXQEXMLConfiguration defaultConfiguration = this.loadConfiguration(defaultConfigUrl, false);
            this.configuration.addConfiguration((Configuration)defaultConfiguration);
        } else if (type == ServiceEnumeration.XQE) {
            throw new ConfigFileException(XQEMessageKeys.CFG_FileExistError, null, "xqe.config.xml");
        }
        if (componentsConfigUrl != null) {
            custConfiguration = this.loadConfiguration(componentsConfigUrl, false);
            this.configuration.addConfiguration((Configuration)custConfiguration);
        }
        if (this.configuration.getNumberOfConfigurations() < 2) {
            XMLConfiguration dummyConfiguration = new XMLConfiguration();
            this.configuration.addConfiguration((Configuration)dummyConfiguration);
        }
        this.dominantConfiguration = (XMLConfiguration)this.configuration.getConfiguration(0);
        if (devConfigUrl != null) {
            this.update(properties, false);
        } else {
            this.update(properties, true);
        }
        String xqeConfiguration = "XQEConfiguration.";
        Properties systemProperties = System.getProperties();
        for (Object property : systemProperties.keySet()) {
            String key = (String)property;
            if (!key.startsWith("XQEConfiguration.")) continue;
            String xqeConfigurationKey = key.substring("XQEConfiguration.".length());
            this.dominantConfiguration.setProperty(xqeConfigurationKey, (Object)System.getProperty(key));
        }
        String tempDirectory = properties.getProperty(TEMP_DIRECTORY_KEY, DEFAULT_TEMP_DIRECTORY);
        tempDirectory = XQEConfiguration.interpretProperty(TEMP_DIRECTORY_CONFIG_FILE_KEY, (Configuration)this.configuration, tempDirectory);
        tempDirectory = FilenameUtils.concat((String)FileUtil.normalizePath(tempDirectory), (String)SERVICE_SUBFOLDER_NAME);
        if (this.xqeTempDirectory == null) {
            this.xqeTempDirectory = new File(tempDirectory);
        }
        String dataDir = properties.getProperty(DATA_DIRECTORY_KEY, DEFAULT_DATA_DIRECTORY);
        dataDir = XQEConfiguration.interpretProperty(DATA_DIRECTORY_CONFIG_FILE_KEY, (Configuration)this.configuration, dataDir);
        this.dataDirectory = FileUtil.normalizePath(dataDir);
        String fileAppender = properties.getProperty(LOG_FILE_APPENDER_KEY, "");
        this.xqeLogsFileAppender = XQEConfiguration.interpretProperty(LOG_FILE_APPENDER_KEY_CONFIG_FILE_KEY, (Configuration)this.configuration, fileAppender);
        this.dominantConfiguration.setProperty(TEMP_DIRECTORY_KEY, (Object)tempDirectory);
        this.dominantConfiguration.setProperty(DATA_DIRECTORY_KEY, (Object)this.dataDirectory);
        this.xqeDataDirectory = new File(new File(this.dataDirectory), SERVICE_SUBFOLDER_NAME);
        Environment.setCognosTempPath(this.xqeTempDirectory.getAbsolutePath());
        Environment.setCognosDataPath(this.xqeDataDirectory.getAbsolutePath());
        if (this.inStandaloneMode()) {
            this.xqeDataDirectory.mkdirs();
            this.xqeTempDirectory.mkdirs();
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (this.xqeLogsDirectory == null) {
                String logsDirectory = properties.getProperty(LOGS_DIRECTORY_KEY, DEFAULT_LOGS_DIRECTORY);
                logsDirectory = XQEConfiguration.interpretProperty("general.logsFolder[@value]", (Configuration)this.configuration, logsDirectory);
                this.xqeLogsDirectory = new File(new File(logsDirectory), SERVICE_SUBFOLDER_NAME);
                this.xqeLogsDirectory.mkdirs();
            }
        }
    }

    private static String interpretProperty(String key, Configuration configuration, String defaultValue) {
        String value = configuration.getString(key);
        if (value == null || value.contains("${")) {
            return defaultValue;
        }
        return value;
    }

    private URL locateConfigurationResource(Properties properties, String resourceName) {
        String dirName = properties.getProperty(CONFIG_DIRECTORY_KEY, DEFAULT_CONFIGURATION_DIRECTORY);
        File dir = new File(dirName);
        ResourceLocator.IResourceMatcher[] paths = new ResourceLocator.IResourceMatcher[]{new ResourceLocator.ClassResourceMatcher(this.getClass(), "/META-INF/xqe/configuration/"), new ResourceLocator.DirectoryResourceMatcher(dir)};
        return ResourceLocator.findURL(resourceName, paths);
    }

    private URL getDefaultConfigResourceURL(ServiceEnumeration type, Properties properties) {
        String suffix = properties.getProperty(CONFIG_FILE_SUFFIX_KEY, DEFAULT_CONFIG_FILE_SUFFIX);
        String base = String.format(STRING_STRING, type.name().toLowerCase(), suffix);
        return this.locateConfigurationResource(properties, base);
    }

    private URL getCustomizedConfigResourceURL(ServiceEnumeration type, Properties properties) {
        String base = String.format(STRING_STRING, type.name().toLowerCase(), CUSTOM_CONFIG_FILE_SUFFIX);
        return this.locateConfigurationResource(properties, base);
    }

    private URL getDevelopmentConfigResourceURL(ServiceEnumeration type, Properties properties) {
        String base = String.format(STRING_STRING, type.name().toLowerCase(), DEV_CONFIG_FILE_SUFFIX);
        return this.locateConfigurationResource(properties, base);
    }

    private URL getCustomizedDSSConfigResourceURL(ServiceEnumeration type, Properties properties) {
        String base = String.format(STRING_STRING, type.name().toLowerCase(), CUSTOM_DSS_CONFIG_FILE_SUFFIX);
        return this.locateConfigurationResource(properties, base);
    }

    private URL getDSSConfigResourceURL(ServiceEnumeration type, Properties properties) {
        String base = String.format(STRING_STRING, type.name().toLowerCase(), DSS_CONFIG_FILE_SUFFIX);
        return this.locateConfigurationResource(properties, base);
    }

    private URL getLoggingConfigResourceURL(ServiceEnumeration type, Properties properties) {
        String base = properties.getProperty(LOG_CONFIG_FILE_NAME_KEY, LOG_CONFIG_FILE_NAME);
        return this.locateConfigurationResource(properties, base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XQESubConfiguration getChildren(String key) {
        XQESubConfiguration subConfiguration = null;
        try {
            this.rwLock.readLock().lockInterruptibly();
            try {
                List children = null;
                for (int i = 0; i < this.configuration.getNumberOfConfigurations(); ++i) {
                    XMLConfiguration xmlcfg;
                    Configuration cfg = this.configuration.getConfiguration(i);
                    if (!(cfg instanceof XMLConfiguration) || (children = (xmlcfg = (XMLConfiguration)cfg).configurationsAt(key)) == null || children.isEmpty()) continue;
                    XQESubConfiguration xQESubConfiguration = subConfiguration = new XQESubConfiguration(this.serviceType, children);
                    return xQESubConfiguration;
                }
                if (children != null) {
                    XQESubConfiguration xQESubConfiguration = new XQESubConfiguration(this.serviceType, children);
                    return xQESubConfiguration;
                }
                XQESubConfiguration xQESubConfiguration = null;
                return xQESubConfiguration;
            }
            finally {
                this.rwLock.readLock().unlock();
            }
        }
        catch (InterruptedException ie) {
            throw new ConfigMutexLockException(XQEMessageKeys.CFG_MutexLockFailure_INTERNAL, (Throwable)ie);
        }
    }

    public void addConfiguration(XMLConfiguration config) {
        this.configuration.addConfiguration((Configuration)config);
    }

    public XQESubConfiguration getConfigForXQEODPComponent(String providerName) {
        XQESubConfiguration config = this.getChildren("components.component");
        while (config.hasNext()) {
            config.next();
            String name = config.getString(XML_ATTRIBUTE_NAME, "");
            if (!name.equals(providerName)) continue;
            XQESubConfiguration subConfig = config.getChildren(".");
            return subConfig;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBooleanProperty(String key, boolean defaultValue) {
        this.rwLock.readLock().lock();
        try {
            boolean bl = this.configuration.getBoolean(key, defaultValue);
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getBooleanProperty(String key, Boolean defaultValue) {
        this.rwLock.readLock().lock();
        try {
            Boolean bl = this.configuration.getBoolean(key, defaultValue);
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByteProperty(String key, byte defaultValue) {
        this.rwLock.readLock().lock();
        try {
            byte by = this.configuration.getByte(key, defaultValue);
            return by;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Byte getByteProperty(String key, Byte defaultValue) {
        this.rwLock.readLock().lock();
        try {
            Byte by = this.configuration.getByte(key, defaultValue);
            return by;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShortProperty(String key, short defaultValue) {
        this.rwLock.readLock().lock();
        try {
            short s = this.configuration.getShort(key, defaultValue);
            return s;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Short getShortProperty(String key, Short defaultValue) {
        this.rwLock.readLock().lock();
        try {
            Short s = this.configuration.getShort(key, defaultValue);
            return s;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIntProperty(String key, int defaultValue) {
        this.rwLock.readLock().lock();
        try {
            int n = this.configuration.getInt(key, defaultValue);
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getIntegerProperty(String key, Integer defaultValue) {
        this.rwLock.readLock().lock();
        try {
            Integer n = this.configuration.getInteger(key, defaultValue);
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLongProperty(String key, long defaultValue) {
        this.rwLock.readLock().lock();
        try {
            long l = this.configuration.getLong(key, defaultValue);
            return l;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getLongProperty(String key, Long defaultValue) {
        this.rwLock.readLock().lock();
        try {
            Long l = this.configuration.getLong(key, defaultValue);
            return l;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloatProperty(String key, float defaultValue) {
        this.rwLock.readLock().lock();
        try {
            float f = this.configuration.getFloat(key, defaultValue);
            return f;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getFloatProperty(String key, Float defaultValue) {
        this.rwLock.readLock().lock();
        try {
            Float f = this.configuration.getFloat(key, defaultValue);
            return f;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDoubleProperty(String key, double defaultValue) {
        this.rwLock.readLock().lock();
        try {
            double d = this.configuration.getDouble(key, defaultValue);
            return d;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getDoubleProperty(String key, Double defaultValue) {
        this.rwLock.readLock().lock();
        try {
            Double d = this.configuration.getDouble(key, defaultValue);
            return d;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringProperty(String key, String defaultValue) {
        this.rwLock.readLock().lock();
        try {
            String string = this.configuration.getString(key, defaultValue);
            return string;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getStringArrayProperty(String key, String[] defaultValue) {
        this.rwLock.readLock().lock();
        try {
            String[] value = this.configuration.getStringArray(key);
            if (null == value) {
                String[] stringArray = defaultValue;
                return stringArray;
            }
            String[] stringArray = value;
            return stringArray;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPropertyValue(String key, Object defaultValue) {
        this.rwLock.readLock().lock();
        try {
            Object value = this.configuration.getProperty(key);
            if (null == value) {
                Object object = defaultValue;
                return object;
            }
            Object object = value;
            return object;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private void setPropertyValue(String key, Object value) {
        try {
            this.rwLock.writeLock().lockInterruptibly();
            try {
                this.dominantConfiguration.setProperty(key, value);
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        }
        catch (InterruptedException ie) {
            throw new ConfigMutexLockException(XQEMessageKeys.CFG_MutexLockFailure_INTERNAL, (Throwable)ie);
        }
    }

    public void setProperty(String key, int value) {
        this.setPropertyValue(key, XQEIntegerPool.getInteger(value));
    }

    public void setProperty(String key, double value) {
        this.setPropertyValue(key, new Double(value));
    }

    public void setProperty(String key, long value) {
        this.setPropertyValue(key, new Long(value));
    }

    public void setProperty(String key, boolean value) {
        this.setPropertyValue(key, new Boolean(value));
    }

    public void setProperty(String key, String value) {
        this.setPropertyValue(key, value);
    }

    public String getXqeDataDirectory() {
        return this.xqeDataDirectory.getAbsolutePath();
    }

    public String getXqeTempDirectory() {
        return this.xqeTempDirectory.getAbsolutePath();
    }

    public String getXqeLogsDirectory() {
        return this.xqeLogsDirectory.getAbsolutePath();
    }

    public String getXqeLogsFileAppender() {
        return this.xqeLogsFileAppender;
    }

    public String getBinDirectory() {
        return this.binDirectory;
    }

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    public String getExtLibDirectory() {
        return this.xqeExtLibDirectory;
    }

    public String getDatasetDirectory() {
        return this.dataDirectory + SLASH + DATASETS;
    }

    public String getMoserDirectory() {
        return this.dataDirectory + SLASH + MOSER;
    }

    public String getConfigDirectory() {
        return this.configDirectory;
    }

    public String getDatasetsFileDirectory() {
        return this.datasetsFileDirectory;
    }

    public void saveConfiguration() throws ConfigFileException {
        try {
            this.dominantConfiguration.save();
        }
        catch (ConfigurationException e) {
            throw new ConfigFileException(XQEMessageKeys.CFG_FileSaveError, (Throwable)e, this.dominantConfiguration.getFileName());
        }
    }

    public ConfigurationChangeListener registerConfigurationListener(XQEConfigurationListener l) {
        if (this.configuration == null) {
            return null;
        }
        ConfigurationChangeListener listener = new ConfigurationChangeListener(l);
        this.dominantConfiguration.addConfigurationListener((ConfigurationListener)listener);
        return listener;
    }

    public void unregisterConfigurationListener(ConfigurationChangeListener l) {
        if (l != null) {
            this.dominantConfiguration.removeConfigurationListener((ConfigurationListener)l);
        }
    }

    public ConfigurationChangeListener registerXQEConfigurationListener(XQEConfigurationListener xqeConfigurationListener, ConfigEnum configEnum) {
        ConfigurationChangeListener configurationChangeListener;
        AbstractXQEXMLConfiguration individualConfiguration = this.individualConfigurations[configEnum.ordinal()];
        if (null == individualConfiguration) {
            configurationChangeListener = null;
        } else {
            configurationChangeListener = new ConfigurationChangeListener(xqeConfigurationListener);
            individualConfiguration.addConfigurationListener(configurationChangeListener);
        }
        return configurationChangeListener;
    }

    public boolean unregisterConfigurationListener(ConfigurationChangeListener configurationChangeListener, ConfigEnum configEnum) {
        AbstractXQEXMLConfiguration individualConfiguration = this.individualConfigurations[configEnum.ordinal()];
        boolean unregistered = null != individualConfiguration ? individualConfiguration.removeConfigurationListener(configurationChangeListener) : false;
        return unregistered;
    }

    protected void lockWrite() {
        try {
            this.rwLock.writeLock().lockInterruptibly();
        }
        catch (InterruptedException ie) {
            throw new ConfigMutexLockException(XQEMessageKeys.CFG_MutexLockFailure_INTERNAL, (Throwable)ie);
        }
    }

    protected void releaseWrite() {
        this.rwLock.writeLock().unlock();
    }

    protected void lockRead() {
        try {
            this.rwLock.readLock().lockInterruptibly();
        }
        catch (InterruptedException ie) {
            throw new ConfigMutexLockException(XQEMessageKeys.CFG_MutexLockFailure_INTERNAL, (Throwable)ie);
        }
    }

    protected void releaseRead() {
        this.rwLock.readLock().unlock();
    }

    public void clearPropertyValue(String key) {
        try {
            this.rwLock.writeLock().lockInterruptibly();
            try {
                this.configuration.clearProperty(key);
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        }
        catch (InterruptedException ie) {
            throw new ConfigMutexLockException(XQEMessageKeys.CFG_MutexLockFailure_INTERNAL, (Throwable)ie);
        }
    }

    public void debugPrint() {
        try {
            for (int i = 0; i < this.configuration.getNumberOfConfigurations(); ++i) {
                if (!(this.configuration.getConfiguration(i) instanceof XMLConfiguration)) continue;
                XMLConfiguration c = (XMLConfiguration)this.configuration.getConfiguration(i);
                c.save((OutputStream)XQEDebugLog.out);
            }
        }
        catch (Exception e) {
            XQEDebugLog.err.printStackTrace(e);
        }
    }

    public AbstractConfiguration getConfigForTesting() {
        return this.configuration;
    }

    public boolean isCryptoEnabled() {
        return this.getBooleanProperty(JCAMCRYPTO_ENABLED, true);
    }

    public boolean isFunctionPoolEnabled() {
        return true;
    }

    public boolean isXQEMBeanServer() {
        return this.inStandaloneMode() && this.getStringProperty("XQEMBeanServer", XML_VALUE_TRUE).equals(XML_VALUE_TRUE);
    }

    public boolean isBigSQL() {
        return false;
    }

    public void update(ICCLConfiguration cclConfig) {
        Properties properties = CommonClassesFactory.createPropertiesForXQEConfiguration(cclConfig);
        this.update(properties);
    }

    public void update(Properties properties) {
        this.update(properties, true);
        this.determineGenerateCommentsInNativeSQLValue();
    }

    private void determineGenerateCommentsInNativeSQLValue() {
        if (this.getBooleanProperty(GENERATE_COMMENTS_IN_NATIVE_SQL_PORTAL, false)) {
            this.hasGenerateCommentsInNativeSQLFlippedPortal = true;
        }
        if (this.hasGenerateCommentsInNativeSQLFlippedPortal || null == this.getPropertyValue(GENERATE_COMMENTS_IN_NATIVE_SQL, null)) {
            this.setProperty(GENERATE_COMMENTS_IN_NATIVE_SQL, this.getBooleanProperty(GENERATE_COMMENTS_IN_NATIVE_SQL_PORTAL, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Properties properties, boolean override) {
        try {
            this.rwLock.writeLock().lockInterruptibly();
            try {
                for (Map.Entry<Object, Object> property : properties.entrySet()) {
                    String key = null;
                    String value = null;
                    if (property.getKey() instanceof String) {
                        key = (String)property.getKey();
                    }
                    if (property.getValue() instanceof String) {
                        value = (String)property.getValue();
                    }
                    if (!override && this.dominantConfiguration.containsKey(key)) continue;
                    this.dominantConfiguration.setProperty(key, (Object)value);
                }
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        }
        catch (InterruptedException ie) {
            throw new ConfigMutexLockException(XQEMessageKeys.CFG_MutexLockFailure_INTERNAL, (Throwable)ie);
        }
    }

    public static String getParameterValueFromCCLConfig(String nestingParameterName, String nestedParameterName, String defaultValue) {
        try {
            Namespace ns;
            String nsPrefix;
            String actualPrefix;
            XPath xpath;
            List nodeList;
            XQECCLConfigurationFactory.getInstance().init();
            Element element = XQECCLConfigurationFactory.getInstance().getValueElement(nestingParameterName, false);
            String parameterValue = null != element ? ((nodeList = CollectionCast.uncheckedCast((xpath = DocumentHelper.createXPath((String)((actualPrefix = null != (nsPrefix = (ns = element.getNamespace()).getPrefix()) && nsPrefix.length() > 0 ? nsPrefix + ':' : "") + "parameter[@name=\"" + nestedParameterName + "\"]/" + actualPrefix + "value"))).selectNodes((Object)element))).size() == 1 ? ((Node)nodeList.get(0)).getText() : defaultValue) : defaultValue;
            return parameterValue;
        }
        catch (CCLConfigurationException e) {
            return defaultValue;
        }
    }

    public static String getParameterValueFromCCLConfig(String parameterName, String defaultValue) {
        try {
            XQECCLConfigurationFactory.getInstance().init();
            String parameterValue = XQECCLConfigurationFactory.getInstance().getValue(parameterName, false);
            if (null == parameterValue || parameterValue.isEmpty()) {
                parameterValue = defaultValue;
            }
            return parameterValue;
        }
        catch (CCLConfigurationException e) {
            return defaultValue;
        }
    }

    public void loadParameterAccessCoordinator() {
        if (this.pac != null) {
            return;
        }
        this.pac = new ParameterAccessCoordinator();
        XQESubConfiguration config = this.getChildren("ParameterMaps.map");
        while (config != null && config.hasNext()) {
            config.next();
            String mapName = config.getString(XML_ATTRIBUTE_NAME, "");
            if (mapName.equals("")) continue;
            String mapPriority = config.getString(XML_ATTRIBUTE_PRIORITY, "");
            int mapPri = Integer.parseInt(mapPriority);
            ParameterMapsApp map = new ParameterMapsApp(mapName, mapPri);
            XQESubConfiguration entries = config.getChildren("entry");
            while (entries.hasNext()) {
                entries.next();
                String entryName = entries.getString(XML_ATTRIBUTE_NAME, "");
                String entryValue = entries.getString(XML_ATTRIBUTE_VALUE, "");
                map.set(mapName, entryName, entryValue);
            }
            this.pac.addParameterMap(map);
        }
    }

    public ParameterAccessCoordinator getParameterAccessCoordinator() {
        return this.pac;
    }

    public boolean isParallelismEnabled() {
        return this.getBooleanProperty("queryExecution.parallelism[@enabled]", false);
    }

    public int getMaxDop() {
        int dop = this.getIntProperty("queryExecution.parallelism.maxDop[@value]", 1);
        if (dop == 0) {
            dop = Runtime.getRuntime().availableProcessors();
        }
        return dop;
    }

    public boolean isBurstPrefetchEnabled() {
        return this.getBooleanProperty("queryExecution.burstPrefetch[@enabled]", false);
    }

    public XQESubConfiguration getLoggingAppenders() {
        String key = "diagnostics." + (Object)((Object)this.serviceType) + APPENDER_ELEMENT;
        return this.getChildren(key);
    }

    public String getDefaultLoggingLevel() {
        return this.getStringProperty(DEFAULT_LEVEL_PROPERTY, "error");
    }

    public String getDefaultLoggingAppender() {
        return this.getStringProperty(DEFAULT_APPENDER_PROPERTY, "file");
    }

    public boolean getLoggingEnabled() {
        return this.getBooleanProperty(DIAG_ENABLED_PROPERTY, true);
    }

    public XQESubConfiguration getLoggingComponents() {
        String key = "diagnostics." + (Object)((Object)this.serviceType) + COMPONENT_ELEMENT;
        return this.getChildren(key);
    }

    public void registerTimerTasks(Timer timer) {
        for (AbstractXQEXMLConfiguration config : this.individualConfigurations) {
            if (null == config) continue;
            config.registerTimerTask(timer);
        }
    }

    public void unregisterTimerTasks() {
        for (AbstractXQEXMLConfiguration config : this.individualConfigurations) {
            if (null == config) continue;
            config.unregisterTimerTask();
        }
    }

    public boolean connectionAttributesEnabled() {
        return this.getBooleanProperty("queryExecution.setConnectionAttributes[@enabled]", false);
    }

    public boolean inStandaloneMode() {
        return this.getBooleanProperty(STANDALONE_MODE, true);
    }

    static {
        ConfigurationInterpolator.registerGlobalLookup((String)ENV, (StrLookup)new EnvironmentVariableStrLookup(ENV));
        DEFAULT_USE_NATIVE_TM1_ENGINE = Boolean.FALSE;
        DEFAULT_ALLOW_DATABASE_ONLY_PA = Boolean.FALSE;
    }

    public class ConfigurationChangeListener
    implements ConfigurationListener {
        XQEConfigurationListener listener = null;

        public ConfigurationChangeListener(XQEConfigurationListener l) {
            this.listener = l;
        }

        public void configurationChanged(ConfigurationEvent event) {
            XQEConfigurationEvent e = new XQEConfigurationEvent(event);
            this.listener.configurationChanged(e);
        }
    }

    public static enum ConfigEnum {
        XQE_DIAGNOSTIC_LOGGING_CONFIG;

    }
}

