/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.config;

import com.cognos.xqe.config.AbstractXQEXMLConfiguration;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.commons.configuration.tree.ConfigurationNode;

public class XQEPeriodicallyReloadableXMLConfiguration
extends AbstractXQEXMLConfiguration {
    private static final long serialVersionUID = -1592172339134113508L;
    public static final long DEFAULT_RELOAD_TIME = 30000L;
    final long refreshInterval;
    private static final long DELAY = 0L;
    private final XQEFileChangedReloadingStrategy xqeFileChangedReloadingStrategy;
    private final AtomicReference<TimerTask> currentTimerTask = new AtomicReference<Object>(null);
    private static final String RELOAD = "reload[@enabled]";

    public XQEPeriodicallyReloadableXMLConfiguration(String fileName) throws ConfigurationException {
        super(fileName);
        boolean allowReload = this.getBoolean(RELOAD, true);
        this.refreshInterval = this.determineRefreshInterval();
        if (allowReload && this.refreshInterval > 0L) {
            this.xqeFileChangedReloadingStrategy = new XQEFileChangedReloadingStrategy();
            this.setReloadingStrategy((ReloadingStrategy)this.xqeFileChangedReloadingStrategy);
        } else {
            this.xqeFileChangedReloadingStrategy = null;
        }
    }

    public XQEPeriodicallyReloadableXMLConfiguration(URL url) throws ConfigurationException {
        super(url);
        boolean allowReload = this.getBoolean(RELOAD, true);
        this.refreshInterval = this.determineRefreshInterval();
        if (allowReload && this.refreshInterval > 0L) {
            this.xqeFileChangedReloadingStrategy = new XQEFileChangedReloadingStrategy();
            this.setReloadingStrategy((ReloadingStrategy)this.xqeFileChangedReloadingStrategy);
        } else {
            this.xqeFileChangedReloadingStrategy = null;
        }
    }

    public Object getProperty(String key) {
        List nodes = this.fetchNodeList(key);
        if (nodes.size() == 0) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (ConfigurationNode node : nodes) {
            if (node.getValue() == null) continue;
            list.add(node.getValue());
        }
        if (list.size() < 1) {
            return null;
        }
        return list.size() == 1 ? list.get(0) : list;
    }

    public void reload() {
    }

    protected void doReload() {
        super.reload();
    }

    @Override
    public TimerTask registerTimerTask(Timer timer) {
        ConfigReloadTimerTask newTask;
        ConfigReloadTimerTask registeredTimerTask = null;
        if (this.isEnabled() && this.currentTimerTask.compareAndSet(null, newTask = new ConfigReloadTimerTask())) {
            timer.scheduleAtFixedRate((TimerTask)newTask, 0L, this.refreshInterval);
            registeredTimerTask = newTask;
        }
        return registeredTimerTask;
    }

    @Override
    public TimerTask unregisterTimerTask() {
        TimerTask unregisteredTimerTask;
        block1: {
            while (!this.currentTimerTask.compareAndSet(unregisteredTimerTask = this.currentTimerTask.get(), null)) {
            }
            if (null == unregisteredTimerTask) break block1;
            unregisteredTimerTask.cancel();
        }
        return unregisteredTimerTask;
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    public boolean isEnabled() {
        return null != this.xqeFileChangedReloadingStrategy;
    }

    private long determineRefreshInterval() {
        long result;
        try {
            result = this.getLong("reload[@refreshInterval]", 30000L);
        }
        catch (ConversionException ignored) {
            result = 30000L;
        }
        return result;
    }

    protected void handleConfigReloadTimerTaskThrowable(Throwable throwable) {
    }

    private static class XQEFileChangedReloadingStrategy
    extends FileChangedReloadingStrategy {
        XQEFileChangedReloadingStrategy() {
            this.setRefreshDelay(0L);
        }

        public boolean hasChanged() {
            return super.hasChanged();
        }

        public boolean reloadingRequired() {
            return true;
        }
    }

    private class ConfigReloadTimerTask
    extends TimerTask {
        private ConfigReloadTimerTask() {
        }

        @Override
        public void run() {
            try {
                if (XQEPeriodicallyReloadableXMLConfiguration.this.xqeFileChangedReloadingStrategy.hasChanged()) {
                    XQEPeriodicallyReloadableXMLConfiguration.this.doReload();
                    XQEPeriodicallyReloadableXMLConfiguration.this.xqeFileChangedReloadingStrategy.reloadingPerformed();
                }
            }
            catch (Throwable throwable) {
                XQEPeriodicallyReloadableXMLConfiguration.this.handleConfigReloadTimerTaskThrowable(throwable);
            }
        }
    }
}

