/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.cubingservices;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.xqe.bibushandler.IHomicide;
import com.cognos.xqe.bibushandler.XQEHomicide;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationFactory;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.NullFormatService;
import com.cognos.xqe.format.XQEFormatService;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPConfiguration;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPConfigurationDefaultProperties;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.ConfigurationValues;
import java.lang.reflect.Field;
import java.util.Properties;

public final class CommonClassesFactory {
    private static final String QUERY_PLANNING_TRACE = "qsQueryPlanningTrace";

    public static XQEConfiguration createXQEConfiguration(ServiceEnumeration type, Properties properties) {
        return new XQEConfiguration(type, properties);
    }

    public static XQELogger createXQELogger(String logger) {
        return XQELog.getLogger(ServiceEnumeration.XQE, "XQE", logger, LogLevel.TRACE);
    }

    public static IHomicide createIHomicide() {
        return new XQEHomicide();
    }

    public static Properties createPropertiesForXQEConfiguration(ICCLConfiguration cclConfiguration) {
        if (cclConfiguration != null) {
            return CommonClassesFactory.createPropertiesFromCCLConfiguration(cclConfiguration, true);
        }
        ICCLConfiguration cclConfig = XQECCLConfigurationFactory.getInstance();
        try {
            cclConfig.init();
        }
        catch (CCLConfigurationException e) {
            throw new XQERuntimeException(e);
        }
        return CommonClassesFactory.createPropertiesFromCCLConfiguration(cclConfig, true);
    }

    public static FormatService createFormatService() {
        if (XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE).isBigSQL()) {
            return new NullFormatService();
        }
        return new XQEFormatService();
    }

    public static Properties createPropertiesFromCCLConfiguration(ICCLConfiguration cclConfiguration, boolean bLogProperties) {
        Properties properties = new Properties();
        CommonClassesFactory.setEffectivePath(properties, cclConfiguration, "tempDirectory", CommonClassesFactory.getValueFromCCLConfiguration(cclConfiguration, "temp", "../temp"));
        CommonClassesFactory.setEffectivePath(properties, cclConfiguration, "dataDirectory", CommonClassesFactory.getValueFromCCLConfiguration(cclConfiguration, "data", "../data"));
        CommonClassesFactory.setEffectivePath(properties, cclConfiguration, "configDirectory", "../configuration");
        CommonClassesFactory.setEffectivePath(properties, cclConfiguration, "binDirectory", ".");
        CommonClassesFactory.setEffectivePath(properties, cclConfiguration, "logsDirectory", "../logs");
        CommonClassesFactory.setEffectivePath(properties, cclConfiguration, "datasetsFileDirectory", "../data/datasets");
        CommonClassesFactory.setEffectivePath(properties, cclConfiguration, "extLibDirectory", "../v5dataserver/lib/ext");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qsDumpModelToFile", "metadataService.dumpModel");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qsCheckSuppressQueryHintForTMR", "queryExecution.checkSuppressQueryHintForTMR[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qsLoadHierarchyNamedSets", "queryExecution.loadHierarchyNamedSets[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qsIdleConnectionTimeout", "providers.defaultIdleConnectionTimeout");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qsMetricsEnabled", "metrics[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qsQueryExecutionTrace", "queryExecution[@traceEnabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, QUERY_PLANNING_TRACE, "queryPlanning[@traceEnabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, QUERY_PLANNING_TRACE, "queryPlanning.traceLevels.whyTransformationApplied[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qsInitialJVMHeapSize", "jvm.qsInitialJVMHeapSize");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qsJVMHeapSizeLimit", "jvm.qsJVMHeapSizeLimit");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qsAdditionalJVMArguments", "jvm.qsAdditionalJVMArguments", "");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qsDisableVerboseGCLogging", "jvm.qsDisableVerboseGCLogging");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qsVerboseGCLogLimit", "jvm.qsVerboseGCLogLimit");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qsGCPolicy", "jvm.qsGCPolicy");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qsInitialJVMNurserySize", "jvm.qsInitialJVMNurserySize");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qsJVMNurserySizeLimit", "jvm.qsJVMNurserySizeLimit");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qsGenerateCommentsInNativeSQL", "queryPlanning.qsGenerateCommentsInNativeSQL");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qsPushCalculationsToInnerQuery", "queryPlanning.qsPushCalculationsToInnerQuery[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qsPushFiltersToInnerQuery", "queryPlanning.qsPushFiltersToInnerQuery[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qsManualCubeStart", "rolap.qsManualCubeStart");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qsROLAPMemberCacheAliasRoot", "rolap.qsROLAPMemberCacheAliasRoot");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qsMultiDimensionalQuerySizeLimit", "rolap.qsMultiDimensionalQuerySizeLimit");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qsROLAPCubeAdministrationCommandTimeout", "rolap.qsROLAPCubeAdministrationCommandTimeout");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qsResultSetCacheQueryTimeThreshold", "rolap.qsResultSetCacheQueryTimeThreshold");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qsROLAPCubeConfigurations", "rolap.cubeconfigurations", "<crn:value xmlns:crn=\"http://developer.cognos.com/schemas/crconfig/1/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"SOAP-ENC:Array\"><value xsi:type=\"SOAP-ENC:Array\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" SOAP-ENC:arrayType=\"cm:baseROLAPCubeConfiguration[0]\"/></crn:value>");
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsPushdownSetFunctionsToRelational", Boolean.toString(true));
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsPushdownMinimumSetSize", Long.toString(10000L));
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsPushdownDisabledCubes", "");
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsMaxValidationThreads", Integer.toString(ROLAPConfigurationDefaultProperties.DEFAULT_MAX_VALIDATION_THREADS));
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsAdvisorMaxNumberWorkloadQueriesConsidered", Integer.toString(100));
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsAdvisorMaxNumberInMemoryAggregates", Integer.toString(50));
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsAdvisorMaxNumberInDBAggregates", Integer.toString(25));
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsAdvisorEnableTestFeatures", Boolean.toString(false));
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsAdvisorConsolidateAggregatesMore", Boolean.toString(false));
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsEnablePrimingQuery", Boolean.toString(false));
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsPrimingQueryThreshold", Integer.toString(0));
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsAdvisorExcludeNonAdditiveMeasures", Boolean.toString(false));
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsAdvisorSessionTimeoutInMs", Long.toString(5000L));
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsAutomaticAggregateOptimizationStartTime", "");
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsAutomaticAggregateOptimizationMaxConcurrentCubeTasks", Integer.toString(1));
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsAdvisorMaxNumberOfInMemoryAggregateCells", Long.toString(300000000L));
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsSecurityMaxCachedMembers", Integer.toString(1000000));
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsCubeStartDelayOnRecovery", Integer.toString(300));
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsVirtualCubeMergeNonExistentValuesAsErrors", Boolean.toString(false));
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsAllowSecuredHierarchyMemberRollup", Boolean.toString(false));
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsReturnCalculatedMemberLUN", Boolean.toString(false));
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsDetermineMultiLevelsInAggregateSet", Boolean.toString(true));
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsEnableAggregationRulesVirtualCube", Boolean.toString(true));
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsPrimingReportNamePrefix", "");
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsMaxCrossjoinOrderOfMagnitude", Integer.toString(8));
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsMaxCrossjoinInteractiveOrderOfMagnitude", Integer.toString(5));
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsExpressionCacheEnabled", Boolean.toString(true));
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qsUseEnhancedTM1FormatParser", "formatting.useEnhancedTM1FormatParser[@value]", Boolean.toString(true));
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsUseNativeTM1Engine", Boolean.toString(XQEConfiguration.DEFAULT_USE_NATIVE_TM1_ENGINE));
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsAllowDatabaseOnlyForPA", Boolean.toString(XQEConfiguration.DEFAULT_ALLOW_DATABASE_ONLY_PA));
        CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, "qsEnableAddPeriodToDateLastChild", Boolean.toString(true));
        CommonClassesFactory.autoLoadProperties(cclConfiguration, properties);
        CommonClassesFactory.loadAdvancedPropertiesForXQEConfig(cclConfiguration, properties);
        if (bLogProperties) {
            ROLAPConfiguration.logAdvancedSettings(properties);
        }
        return properties;
    }

    private static void autoLoadProperties(ICCLConfiguration cclConfiguration, Properties properties) {
        Field[] fields;
        for (Field field : fields = ConfigurationValues.class.getDeclaredFields()) {
            if ((field.getModifiers() & 8) <= 0 || !field.getType().equals(String.class)) continue;
            try {
                String propertyName = field.get(null).toString();
                CommonClassesFactory.setUpPropertySameKey(cclConfiguration, properties, propertyName, null);
            }
            catch (IllegalArgumentException e) {
                XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "InitTerm", LogLevel.ERROR).log(LogLevel.ERROR, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "InitTerm", LogLevel.ERROR).log(LogLevel.ERROR, (Throwable)e);
            }
        }
    }

    private static void loadAdvancedPropertiesForXQEConfig(ICCLConfiguration cclConfiguration, Properties properties) {
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.general.hooks", "general.hooks[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.general.logsFolder", "general.logsFolder[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.general.tempDirectory", "general.tempDirectory[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.general.dataDirectory", "general.dataDirectory[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.general.cacheQueryPlans", "general.cacheQueryPlans");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.general.rsapi.returnDataItemNameInPartialDataset", "general.rsapi.returnDataItemNameInPartialDataset[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.general.queryReuse.enabled", "general.queryReuse[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.general.queryReuse.size", "general.queryReuse[@size]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.general.queryReuse.retention.maxAge", "general.queryReuse.retention[@maxAge]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.general.queryReuse.retention.maxIdle", "general.queryReuse.retention[@maxIdle]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.general.queryReuse.data.threshold", "general.queryReuse.data[@threshold]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.general.queryReuse.data.maxMemory", "general.queryReuse.data[@maxMemory]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.general.queryReuse.allowReuseOfParameterizedQueries", "general.queryReuse.allowReuseOfParameterizedQueries[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.general.cacheResultSets.enabled", "general.cacheResultSets[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.general.cacheResultSets.data.threshold", "general.cacheResultSets[@threshold]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.general.cacheResultSets.data.maxMemory", "general.cacheResultSets[@maxMemory]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.network.rmiRegistry", "network.rmiRegistry[@port]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.network.jmxRemote", "network.jmxRemote[@port]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.network.xqeService", "network.xqeService[@port]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.network.bufferSize", "network.bufferSize[@size]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.network.dispatcherCallback", "network.dispatcherCallback[@port]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.ma4j.suppressPromptFilterItemRef", "ma4j.suppressPromptFilterItemRef[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.ma4j.replaceInvalidXmlCharacterEnabled", "ma4j.replaceInvalidXmlCharacter[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.ma4j.replaceInvalidXmlCharacterValue", "ma4j.replaceInvalidXmlCharacter[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryPlanning.AllowAutoexistsWithSlicer", "queryPlanning.AllowAutoexistsWithSlicer[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryPlanning.keepHeaderFooterWithoutMeasures", "queryPlanning.keepHeaderFooterWithoutMeasures[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryPlanning.notes", "queryPlanning.notes[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryPlanning.includeMacroExpansionInXqeLogs", "queryPlanning.includeMacroExpansionInXqeLogs[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryPlanning.NativeCommentMacro", "queryPlanning.NativeCommentMacro[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryPlanning.strictDBFunctionReturnType", "queryPlanning.strictDBFunctionReturnType[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryPlanning.primingQuery", "queryPlanning.primingQuery[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryPlanning.primingQuery.RO", "queryPlanning.primingQuery.RO[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryPlanning.formatMissingValuesInListReports", "queryPlanning.formatMissingValuesInListReports[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryPlanning.shortenIdentifierName", "queryPlanning.shortenIdentifierName[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryPlanning.localFormattingOnCastOperator", "queryPlanning.localFormattingOnCastOperator[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryPlanning.generateSubqueryForCalcs", "queryPlanning.generateSubqueryForCalcs[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryPlanning.processNullConsumersAfterJoin", "queryPlanning.processNullConsumersAfterJoin[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryPlanning.enableTM1_101CompatibilityMode", "queryPlanning.enableTM1_101CompatibilityMode[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.MDXEngineCellCache.StorageSizePerCube", "queryExecution.MDXEngineCellCache.StorageSizePerCube[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.MDXEngineCellCache.LimitThreshold", "queryExecution.MDXEngineCellCache.LimitThreshold[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.MDXEngineCellCache.MaintenanceTimeInterval", "queryExecution.MDXEngineCellCache.MaintenanceTimeInterval[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.PrimingQuery.primingThreshold", "queryExecution.PrimingQuery.primingThreshold[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.burstPrefetch", "queryExecution.burstPrefetch[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.burstPrefetch.maxResultSetPrefetch", "queryExecution.burstPrefetch.maxResultSetPrefetch[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.burstPrefetch.minThreads", "queryExecution.burstPrefetch.minThreads[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.burstPrefetch.maxThreads", "queryExecution.burstPrefetch.maxThreads[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.burstPrefetch.maxMemoryPerResultSet", "queryExecution.burstPrefetch.maxMemoryPerResultSet[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.setConnectionAttributes", "queryExecution.setConnectionAttributes[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.hierarchyUseFillerMember", "queryExecution.hierarchyUseFillerMember[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.OData.lazyLoading", "queryExecution.OData.lazyLoading[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.OData.responseLimit", "queryExecution.OData.responseLimit[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.JSON.flatteningPolicy", "queryExecution.JSON.flatteningPolicy[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.dataset.parquet.blockSize", "dataset.parquet.blockSize[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.dataset.parquet.pageSize", "dataset.parquet.pageSize[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.dataset.parquet.compressionCodec", "dataset.parquet.compression[@codec]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.dataset.parquet.parquetVersion", "dataset.parquet.parquetVersion[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.flintServer", "queryExecution.flintServer[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.flintServer.restartOnConfChange", "queryExecution.flintServer.restartOnConfChange[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.flintServer.host", "queryExecution.flintServer.host[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.flintServer.port", "queryExecution.flintServer.port[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.flintServer.minHeap", "queryExecution.flintServer.memory[@minHeap]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.flintServer.maxHeap", "queryExecution.flintServer.memory[@maxHeap]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.flintServer.maxDirect", "queryExecution.flintServer.memory[@maxDirect]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.flintServer.sparkThreads", "queryExecution.flintServer.sparkThreads[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.flintServer.minThriftWorkers", "queryExecution.flintServer.thriftWorkers[@min]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.flintServer.maxThriftWorkers", "queryExecution.flintServer.thriftWorkers[@max]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.flintServer.extraJavaOptions", "queryExecution.flintServer.extraJavaOptions[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.flintServer.extraFlintConf", "queryExecution.flintServer.extraFlintConf");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.flintServer.logicalDataSourceName", "queryExecution.flintServer.logicalDataSourceName[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.flintServer.queryTimeoutInterval", "queryExecution.flintServer.queryTimeoutInterval[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.flintServer.cache.sqlEnabled", "queryExecution.flintServer.cache[@sqlEnabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.flintServer.executeToSerializedFile", "queryExecution.flintServer.executeToSerializedFile[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.flintServer.datasetIdleSeconds", "queryExecution.flintServer.datasetIdleSeconds[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.flintServer.managedDatasetsLimit", "queryExecution.flintServer.managedDatasetsLimit[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.useProviderCrossJoinThreshold", "queryExecution.useProviderCrossJoinThreshold[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.prettyPrintNativeSQL", "queryExecution.prettyPrintNativeSQL[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "UDA.CONVERT_TIMESTAMP_LITERAL_TO_DATE_LITERAL", "queryExecution.convertOracleTimestamp[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.flintServer.maxRowsRetrieved", "ibmcognos.flint.maxRowsRetrieved");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.maxRowsLocalProcessing", "queryExecution.maxRowsLocalProcessing[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.Cancel.CancelIterationInterval", "Cancel.CancelIterationInterval[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.Cancel.CancelMaximumCheckIterations", "Cancel.CancelMaximumCheckIterations[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.RESTTimeout", "queryExecution.RESTTimeout[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.RESTDefaultTimeout", "queryExecution.RESTDefaultTimeout[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.RESTDefaultPredictTimeout", "queryExecution.RESTDefaultPredictTimeout[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.RESTMaxTimeout", "queryExecution.RESTMaxTimeout[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.RESTWorkloadManagement", "queryExecution.RESTWorkloadManagement[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.RESTWorkloadManagementMaxRequestLoad", "queryExecution.RESTWorkloadManagement.maxRequestLoad[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.queryExecution.RESTWorkloadManagementMaxPermits", "queryExecution.RESTWorkloadManagement.maxPermits[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.memory.managedPercent", "memory.managedPercent[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.memory.maximum", "memory.maximum[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.health", "health[@enabled]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.health.minSuccessRate", "health.minSuccessRate[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.health.minOverallRequests", "health.minOverallRequests[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.health.minSuccessRateMinute", "health.minSuccessRateMinute[@value]");
        CommonClassesFactory.setUpProperty(cclConfiguration, properties, "qs.health.maxConsecutiveTimesSuccessRateMinuteFailures", "health.maxConsecutiveTimesSuccessRateMinuteFailures[@value]");
    }

    private static void setUpProperty(ICCLConfiguration cfg, Properties props, String extKey, String intKey, String defVal) {
        String val = CommonClassesFactory.getValueFromCCLConfiguration(cfg, extKey);
        if (val == null) {
            val = defVal;
        }
        if (val != null) {
            props.setProperty(intKey, val);
        } else {
            props.remove(intKey);
        }
    }

    private static void setUpProperty(ICCLConfiguration cfg, Properties props, String extKey, String intKey) {
        String val = CommonClassesFactory.getValueFromCCLConfiguration(cfg, extKey);
        if (val != null) {
            props.setProperty(intKey, val);
        }
    }

    private static void setUpPropertySameKey(ICCLConfiguration cfg, Properties props, String key, String defVal) {
        CommonClassesFactory.setUpProperty(cfg, props, key, key, defVal);
    }

    private static String overrideAdvancedSettingsKey(String originalKey) {
        if (originalKey.equals("qsUseEnhancedTM1FormatParser")) {
            return "formatting.useEnhancedTM1FormatParser[@value]";
        }
        return originalKey;
    }

    private static String getValueFromCCLConfiguration(ICCLConfiguration cclConfiguration, String key, String defaultValue) {
        String value = CommonClassesFactory.getValueFromCCLConfiguration(cclConfiguration, key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private static String getValueFromCCLConfiguration(ICCLConfiguration cclConfiguration, String key) {
        String value = null;
        try {
            value = cclConfiguration.getValue(key, true);
            if (value.length() == 0) {
                value = null;
            }
        }
        catch (CCLConfigurationException e) {
            value = null;
        }
        return value;
    }

    private static void setEffectivePath(Properties properties, ICCLConfiguration cclConfiguration, String key, String nonEffectivePath) {
        properties.setProperty(key, cclConfiguration.resolveEffectivePath(nonEffectivePath));
    }
}

