/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data;

import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.runtree.XDataContext;
import com.ibm.icu.text.Collator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;

public abstract class DataType
implements IDataType,
Serializable {
    static final long serialVersionUID = 1419413984124906437L;
    private static final String SPACE_CHAR = " ";
    private static final String UNDERSCORE_CHAR = "_";
    private byte type;
    private boolean nullable;
    private DataSubType subType;

    protected DataType(byte dType, DataSubType dSubType) {
        this.type = dType;
        this.subType = dSubType;
    }

    @Override
    public final byte getCCLTypeCode() {
        return this.type;
    }

    @Override
    public int getJDBCType() {
        return 1111;
    }

    @Override
    public IDataType getBaseDataType() {
        return this;
    }

    @Override
    public final DataSubType getSubType() {
        return this.subType;
    }

    @Override
    public String getSubTypeName() {
        return this.subType.getDataSubTypeName();
    }

    @Override
    public String getSQLTypeName() {
        return this.getTypeName().toUpperCase();
    }

    @Override
    public String getSQLText() {
        return this.getSQLTypeName();
    }

    @Override
    public String getCapabilitiesKey() {
        return StringUtils.replace((String)this.getTypeName(), (String)SPACE_CHAR, (String)UNDERSCORE_CHAR);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataType) {
            return this.type == ((DataType)obj).type;
        }
        return false;
    }

    @Override
    public boolean exactlyEquivalent(Object obj) {
        return this.equals(obj);
    }

    public int hashCode() {
        return this.type;
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public int getMaxLength() {
        return this.getLength();
    }

    @Override
    public int getCCLLength() {
        return this.getLength();
    }

    @Override
    public boolean hasPrecision() {
        return false;
    }

    @Override
    public boolean hasScale() {
        return false;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean isNullable) {
        this.nullable = isNullable;
    }

    public String toString() {
        return this.getTypeName();
    }

    @Override
    public int sizeOf() {
        return -1;
    }

    @Override
    public boolean isBoolean() {
        return DataTypeCode.isBoolean(this.type);
    }

    @Override
    public boolean isBinary() {
        return DataTypeCode.isBinary(this.type);
    }

    @Override
    public boolean isInteger() {
        return DataTypeCode.isInteger(this.type);
    }

    @Override
    public boolean isDouble() {
        return this.type == 11;
    }

    @Override
    public boolean isExactNumeric() {
        return DataTypeCode.isExactNumeric(this.type);
    }

    @Override
    public boolean isDecimal() {
        return this.type == 12;
    }

    @Override
    public boolean isFloatingPointDecimal() {
        return this.type == 12 && this.getPrecision() == 0;
    }

    @Override
    public boolean isFixedPointDecimal() {
        return this.type == 12 && this.getPrecision() > 0;
    }

    @Override
    public boolean isApproximateNumeric() {
        return this.type == 10 || this.type == 11;
    }

    @Override
    public boolean isNumeric() {
        return this.isExactNumeric() || this.isApproximateNumeric();
    }

    @Override
    public boolean isDate() {
        return this.type == 57;
    }

    @Override
    public boolean isTime() {
        return DataTypeCode.isTime(this.type);
    }

    @Override
    public boolean isTimestamp() {
        return DataTypeCode.isTimestamp(this.type);
    }

    @Override
    public boolean isDatetime() {
        return this.isDate() || this.isTime() || this.isTimestamp();
    }

    @Override
    public boolean isTimeZoneBearing() {
        return DataTypeCode.isTimeZoneBearing(this.type);
    }

    @Override
    public boolean isInterval() {
        return DataTypeCode.isInterval(this.type);
    }

    @Override
    public boolean isBlob() {
        return DataTypeCode.isBlob(this.type);
    }

    @Override
    public boolean isClob() {
        return DataTypeCode.isClob(this.type);
    }

    @Override
    public boolean isNullType() {
        return DataTypeCode.isNullType(this.type);
    }

    @Override
    public boolean isXML() {
        return DataTypeCode.isXMLType(this.type);
    }

    @Override
    public boolean isJSON() {
        return DataTypeCode.isJSONType(this.type);
    }

    public boolean isRowType() {
        return DataTypeCode.isRowType(this.type);
    }

    @Override
    public boolean isMultiset() {
        return DataTypeCode.isMultisetType(this.type);
    }

    @Override
    public boolean isArray() {
        return DataTypeCode.isArrayType(this.type);
    }

    @Override
    public boolean isVariant() {
        return DataTypeCode.isVariantType(this.type);
    }

    @Override
    public boolean isPeriod() {
        return DataTypeCode.isPeriodType(this.type);
    }

    @Override
    public String toModelType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isTextType() {
        return false;
    }

    @Override
    public IValue createValue(Collator collator) {
        return this.createValue();
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        throw new UnsupportedOperationException();
    }
}

