/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data;

import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.DecimalType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntervalDayTimeType;
import com.cognos.xqe.data.types.IntervalQualifier;
import com.cognos.xqe.data.types.IntervalType;
import com.cognos.xqe.data.types.IntervalYearMonthType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.data.types.NullType;
import com.cognos.xqe.data.types.TextType;
import com.cognos.xqe.data.types.UnknownType;
import com.cognos.xqe.data.types.VariantType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;

public final class DataTypeComparator {
    private static final boolean[][] SQL2003CASTMATRIX = new boolean[][]{{true, true, true, false, false, false, false, true, false, true, false, false, false}, {true, true, true, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, true, true, true, true, false, false}, {false, false, true, true, false, true, false, false, false, false, false, false, false}, {false, false, true, false, true, true, false, false, false, false, false, false, false}, {false, false, true, true, true, true, false, false, false, false, false, false, false}, {false, false, true, false, false, false, true, true, false, false, false, false, false}, {true, false, true, false, false, false, true, true, false, false, false, false, false}, {false, false, true, false, false, false, false, false, true, true, false, false, false}, {true, false, true, false, false, false, false, false, true, true, false, false, false}, {false, false, true, false, false, false, false, false, false, false, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false}};
    private static final int SQL2003_EN = 0;
    private static final int SQL2003_AN = 1;
    private static final int SQL2003_C = 2;
    private static final int SQL2003_D = 3;
    private static final int SQL2003_T = 4;
    private static final int SQL2003_TS = 5;
    private static final int SQL2003_YM = 6;
    private static final int SQL2003_YMS = 7;
    private static final int SQL2003_DT = 8;
    private static final int SQL2003_DTS = 9;
    private static final int SQL2003_BO = 10;
    private static final int SQL2003_BL = 11;
    private static final int SQL2003_OTHER = 12;
    private static final int PRIME = 31;
    private static final int[] DATA_TYPE_PRECEDENCE_ORDER = new int[]{1, 23, 2, 3, 4, 5, 6, 7, 8, 9, 12, 11, 10, 14, 13, 57, 15, 59, 60, 34, 25, 43};

    private DataTypeComparator() {
    }

    public static boolean isComparableTo(IDataType lhs, IDataType rhs) {
        byte rTypeCode;
        boolean valid = false;
        byte lTypeCode = lhs.getCCLTypeCode();
        if (lTypeCode == (rTypeCode = rhs.getCCLTypeCode()) && lhs.getSubType() == rhs.getSubType()) {
            return true;
        }
        if (lTypeCode == 107 || rTypeCode == 107) {
            return true;
        }
        switch (lTypeCode) {
            case 1: 
            case 25: 
            case 26: 
            case 45: 
            case 55: 
            case 56: {
                if (rhs.getSubType() != DataSubType.TEXTTYPE) break;
                valid = true;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                if (rhs.getSubType() != DataSubType.NUMERICTYPE) break;
                valid = true;
                break;
            }
            case 17: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                if (rTypeCode != lTypeCode) break;
                valid = true;
                break;
            }
            case 18: 
            case 22: 
            case 23: 
            case 46: {
                valid = false;
                break;
            }
            case 30: 
            case 32: 
            case 34: {
                if (rhs.getSubType() != DataSubType.METADATATYPE) break;
                valid = true;
                break;
            }
            default: {
                if (rTypeCode != lTypeCode) break;
                valid = true;
            }
        }
        return valid;
    }

    private static int getSQL2003CastTableIndex(IDataType dataType) {
        if (dataType.isExactNumeric()) {
            return 0;
        }
        if (dataType.isApproximateNumeric()) {
            return 1;
        }
        if (dataType.isTextType() || dataType.getCCLTypeCode() == 46) {
            return 2;
        }
        if (dataType.isDate()) {
            return 3;
        }
        if (dataType.isTime()) {
            return 4;
        }
        if (dataType.isTimestamp()) {
            return 5;
        }
        if (dataType.isInterval()) {
            IntervalQualifier iq = ((IntervalType)dataType).getQualifier();
            switch (iq) {
                case INTERVAL_YEAR_TO_MONTH: {
                    return 6;
                }
                case INTERVAL_YEAR: 
                case INTERVAL_MONTH: {
                    return 7;
                }
                case INTERVAL_DAY: 
                case INTERVAL_HOUR: 
                case INTERVAL_MINUTE: 
                case INTERVAL_SECOND: {
                    return 9;
                }
            }
            return 8;
        }
        if (dataType.getSubType() == DataSubType.BOOLEANTYPE) {
            return 10;
        }
        if (dataType.isBlob()) {
            return 11;
        }
        return 12;
    }

    public static boolean isValidCast(IDataType sourceType, IDataType targetType) {
        if (sourceType.getCCLTypeCode() == targetType.getCCLTypeCode()) {
            return true;
        }
        return SQL2003CASTMATRIX[DataTypeComparator.getSQL2003CastTableIndex(sourceType)][DataTypeComparator.getSQL2003CastTableIndex(targetType)];
    }

    public static boolean areCompatibleDataTypes(IDataType dt1, IDataType dt2) {
        if (dt1 == null || dt2 == null) {
            return true;
        }
        if (dt1 == NullType.NULLTYPE || dt2 == NullType.NULLTYPE) {
            return true;
        }
        if (dt1.getCCLTypeCode() == dt2.getCCLTypeCode()) {
            return true;
        }
        if (dt1 == UnknownType.UNKNOWNTYPE || dt2 == UnknownType.UNKNOWNTYPE) {
            return false;
        }
        if (dt1.isTextType() && dt2.isTextType()) {
            return true;
        }
        if (dt1.isNumeric() && dt2.isNumeric()) {
            return true;
        }
        if (dt1.getSubType() == dt2.getSubType()) {
            return true;
        }
        if (dt1.isDate()) {
            return dt2.isTimestamp();
        }
        if (dt1.isTimestamp()) {
            return dt2.isDate();
        }
        return false;
    }

    public static IDataType getCompatibleType(IDataType lhs, IDataType rhs) {
        IDataType result = null;
        if (lhs == null || rhs == null) {
            if (lhs == null) {
                return rhs;
            }
            return lhs;
        }
        byte lTypeCode = lhs.getCCLTypeCode();
        byte rTypeCode = rhs.getCCLTypeCode();
        if (lTypeCode == 107 || rTypeCode == 107) {
            if (lTypeCode == 107) {
                return rhs;
            }
            return lhs;
        }
        if (lTypeCode == 0 || rTypeCode == 0) {
            if (lTypeCode == 0) {
                return rhs;
            }
            return lhs;
        }
        if (lTypeCode == 22 || rTypeCode == 22) {
            if (lTypeCode == 22) {
                return lhs;
            }
            return rhs;
        }
        if (lTypeCode == 1) {
            if (lhs.getLength() == rhs.getLength()) {
                return lhs;
            }
            return DataTypeFactory.getStringType();
        }
        if (rTypeCode == 1) {
            if (lhs.getLength() == rhs.getLength()) {
                return rhs;
            }
            return DataTypeFactory.getStringType();
        }
        if (!lhs.isTextType() && rhs.isTextType()) {
            IDataType temp = lhs;
            lhs = rhs;
            rhs = temp;
            lTypeCode = lhs.getCCLTypeCode();
            rTypeCode = rhs.getCCLTypeCode();
        }
        switch (lTypeCode) {
            case 45: 
            case 55: 
            case 56: {
                if (lTypeCode == rTypeCode) {
                    if (lhs.getLength() == rhs.getLength()) {
                        result = lhs;
                        break;
                    }
                    if (lhs.getPrecision() < 0 || rhs.getPrecision() < 0) {
                        if (lTypeCode == 45) {
                            result = DataTypeFactory.getVarcharType();
                            break;
                        }
                        result = DataTypeFactory.getNVarcharType();
                        break;
                    }
                    if (lTypeCode == 45) {
                        result = DataTypeFactory.getVarcharType(Math.max(lhs.getPrecision(), rhs.getPrecision()));
                        break;
                    }
                    result = DataTypeFactory.getNVarcharType(Math.max(lhs.getPrecision(), rhs.getPrecision()));
                    break;
                }
                if (rhs.getSubType() == DataSubType.TEXTTYPE) {
                    if (rTypeCode == 45 || rTypeCode == 56 || rTypeCode == 55) {
                        result = DataTypeFactory.getNVarcharType(Math.max(lhs.getPrecision(), rhs.getPrecision()));
                        break;
                    }
                    result = DataTypeFactory.getStringType();
                    break;
                }
                if (rTypeCode == 46 || rhs.getSubType() == DataSubType.DATETIMETYPE) {
                    result = rhs;
                    break;
                }
                result = lhs;
                break;
            }
            case 11: {
                if (rhs.isFloatingPointDecimal()) {
                    result = rhs;
                    break;
                }
                if (rhs.getSubType() != DataSubType.NUMERICTYPE) break;
                result = lhs;
                break;
            }
            case 12: {
                if (lhs.isFloatingPointDecimal()) {
                    result = lhs;
                    break;
                }
                if (rhs.isFloatingPointDecimal()) {
                    result = rhs;
                    break;
                }
                if (rhs.getSubType() != DataSubType.NUMERICTYPE) break;
                if (rhs.isInteger()) {
                    if (lhs.getPrecision() - lhs.getScale() < rhs.getPrecision()) {
                        result = DataTypeFactory.getDecimalType(Math.max(lhs.getPrecision(), rhs.getPrecision()) + lhs.getScale(), lhs.getScale());
                        break;
                    }
                    result = lhs;
                    break;
                }
                if (rTypeCode == 12) {
                    if (lhs.getPrecision() != rhs.getPrecision() || lhs.getScale() != rhs.getScale()) {
                        int precision = Math.max(lhs.getScale(), rhs.getScale()) + Math.max(lhs.getPrecision() - lhs.getScale(), rhs.getPrecision() - rhs.getScale());
                        result = DataTypeFactory.getDecimalType(Math.min(precision, 256), Math.max(lhs.getScale(), rhs.getScale()));
                        break;
                    }
                    result = lhs;
                    break;
                }
                if (rTypeCode == 10) {
                    result = DataTypeFactory.getDoubleType();
                    break;
                }
                if (rTypeCode == 11) {
                    result = rhs;
                    break;
                }
                result = lhs;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                if (rhs.isFloatingPointDecimal()) {
                    result = rhs;
                    break;
                }
                if (rhs.getSubType() != DataSubType.NUMERICTYPE) break;
                if (lhs.isInteger() && rTypeCode == 12) {
                    if (rhs.getPrecision() - rhs.getScale() < lhs.getPrecision()) {
                        result = DataTypeFactory.getDecimalType(Math.max(lhs.getPrecision(), rhs.getPrecision()) + rhs.getScale(), rhs.getScale());
                        break;
                    }
                    result = rhs;
                    break;
                }
                if (lTypeCode < rTypeCode) {
                    result = rhs;
                    break;
                }
                result = lhs;
                break;
            }
            case 57: {
                if (lTypeCode == rTypeCode) {
                    result = lhs;
                    break;
                }
                if (rTypeCode != 59) break;
                result = rhs;
                break;
            }
            case 59: {
                if (lTypeCode == rTypeCode) {
                    result = lhs;
                    break;
                }
                if (rTypeCode != 57) break;
                result = lhs;
                break;
            }
            case 58: {
                if (lTypeCode != rTypeCode) break;
                result = lhs;
                break;
            }
            case 17: {
                int precision;
                if (lTypeCode != rTypeCode) break;
                IntervalType lIntervalType = (IntervalYearMonthType)lhs;
                IntervalYearMonthType rIntervalType = (IntervalYearMonthType)rhs;
                if (lIntervalType.getQualifier() == rIntervalType.getQualifier() && rIntervalType.getLeadingPrecision() >= lIntervalType.getLeadingPrecision()) {
                    return rhs;
                }
                IntervalYearMonthType oDataType = DataTypeFactory.getIntervalYearMonthType(IntervalQualifier.INTERVAL_YEAR_TO_MONTH);
                int leftPrecision = lIntervalType.getLeadingPrecision();
                int rightPrecision = rIntervalType.getLeadingPrecision();
                if (lIntervalType.getQualifier() == IntervalQualifier.INTERVAL_MONTH || lIntervalType.getQualifier() == IntervalQualifier.INTERVAL_YEAR_TO_MONTH) {
                    leftPrecision = leftPrecision > 2 ? --leftPrecision : 1;
                }
                if (rIntervalType.getQualifier() == IntervalQualifier.INTERVAL_MONTH || rIntervalType.getQualifier() == IntervalQualifier.INTERVAL_YEAR_TO_MONTH) {
                    rightPrecision = rightPrecision > 2 ? --rightPrecision : 1;
                }
                if ((precision = Math.max(leftPrecision, rightPrecision)) != 9) {
                    ++precision;
                }
                oDataType.setLeadingPrecision(precision);
                result = oDataType;
                break;
            }
            case 60: {
                IntervalQualifier rQualifier;
                if (lTypeCode != rTypeCode) break;
                IntervalType lIntervalType = (IntervalDayTimeType)lhs;
                IntervalDayTimeType rIntervalType = (IntervalDayTimeType)rhs;
                IntervalDayTimeType oDataType = DataTypeFactory.getIntervalDayTimeType(IntervalQualifier.INTERVAL_DAY_TO_SECOND);
                IntervalQualifier lQualifier = lIntervalType.getQualifier();
                if (lQualifier == (rQualifier = rIntervalType.getQualifier())) {
                    oDataType.setQualifier(lQualifier);
                    int precision = Math.max(rIntervalType.getLeadingPrecision(), lIntervalType.getLeadingPrecision());
                    if (precision != 9) {
                        ++precision;
                    }
                    oDataType.setLeadingPrecision(precision);
                } else {
                    oDataType.setLeadingPrecision(9);
                }
                if (lQualifier == IntervalQualifier.INTERVAL_DAY_TO_SECOND || lQualifier == IntervalQualifier.INTERVAL_HOUR_TO_SECOND || lQualifier == IntervalQualifier.INTERVAL_MINUTE_TO_SECOND || lQualifier == IntervalQualifier.INTERVAL_SECOND) {
                    if (rQualifier == IntervalQualifier.INTERVAL_DAY_TO_SECOND || rQualifier == IntervalQualifier.INTERVAL_HOUR_TO_SECOND || rQualifier == IntervalQualifier.INTERVAL_MINUTE_TO_SECOND || rQualifier == IntervalQualifier.INTERVAL_SECOND) {
                        oDataType.setFractionalSecondsPrecision(Math.max(lIntervalType.getLeadingPrecision(), rIntervalType.getLeadingPrecision()));
                    } else {
                        oDataType.setFractionalSecondsPrecision(((IntervalDayTimeType)lIntervalType).getFractionalSecondsPrecision());
                    }
                } else if (rQualifier == IntervalQualifier.INTERVAL_DAY_TO_SECOND || rQualifier == IntervalQualifier.INTERVAL_HOUR_TO_SECOND || rQualifier == IntervalQualifier.INTERVAL_MINUTE_TO_SECOND || rQualifier == IntervalQualifier.INTERVAL_SECOND) {
                    oDataType.setFractionalSecondsPrecision(rIntervalType.getFractionalSecondsPrecision());
                } else {
                    oDataType.setFractionalSecondsPrecision(-1);
                }
                result = oDataType;
                break;
            }
            case 18: 
            case 23: 
            case 24: {
                if (lTypeCode != rTypeCode) break;
                result = lhs;
                break;
            }
            case 46: {
                if (lTypeCode != rTypeCode && rhs.getSubType() != DataSubType.TEXTTYPE) break;
                result = lhs;
                break;
            }
            case 26: {
                if (lTypeCode == rTypeCode) {
                    result = lhs;
                    break;
                }
                if (rhs.getSubType() != DataSubType.TEXTTYPE) break;
                result = DataTypeFactory.getVarcharType();
                break;
            }
            default: {
                result = lTypeCode == rTypeCode ? lhs : null;
            }
        }
        return result;
    }

    public static int hashRowValue(RowValue row, boolean useFastHash) {
        int hashCode = row.getHashCode();
        if (hashCode == 0) {
            hashCode = DataTypeComparator.hashValueArray(row.getColumns(), useFastHash);
        }
        return hashCode;
    }

    public static int hashRowValue(RowValue row, int[] columns, boolean useFastHash) {
        IValue[] values = row.getColumns();
        int hashkey = 1;
        if (useFastHash) {
            for (int i = 0; i < columns.length; ++i) {
                IValue v = values[columns[i]];
                hashkey = 31 * hashkey + v.fastHash();
            }
        } else {
            for (int i = 0; i < columns.length; ++i) {
                IValue v = values[columns[i]];
                hashkey = 31 * hashkey + v.hashCode();
            }
        }
        return hashkey;
    }

    public static int hashValueArray(IValue[] values, boolean useFastHash) {
        int hashkey = 1;
        if (useFastHash) {
            for (IValue value : values) {
                hashkey = 31 * hashkey + value.fastHash();
            }
        } else {
            for (IValue value : values) {
                hashkey = 31 * hashkey + value.hashCode();
            }
        }
        return hashkey;
    }

    public static IDataType getDataTypeWithHigherPrecedence(IDataType ldt, IDataType rdt) {
        int lCCLdt = ldt.getCCLTypeCode();
        if (ldt instanceof MemberType) {
            lCCLdt = 43;
        }
        int rCCLdt = rdt.getCCLTypeCode();
        if (rdt instanceof MemberType) {
            rCCLdt = 43;
        }
        for (int type : DATA_TYPE_PRECEDENCE_ORDER) {
            if (type == lCCLdt) {
                return rdt;
            }
            if (type != rCCLdt) continue;
            return ldt;
        }
        return ldt;
    }

    public static IDataType getMoreRestrictiveDataType(String pName, IDataType existingDT, IDataType newDT) {
        if (existingDT == null || existingDT instanceof TextType || existingDT instanceof VariantType) {
            return newDT;
        }
        if (newDT instanceof TextType || newDT instanceof VariantType) {
            return existingDT;
        }
        if (existingDT == newDT) {
            return existingDT;
        }
        if (!DataTypeComparator.isComparableTo(existingDT, newDT)) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_PromptWithConflictingDataTypes, (Object)pName, (Object)existingDT.toString(), (Object)newDT.toString());
        }
        if (existingDT == DataTypeComparator.getDataTypeWithHigherPrecedence(existingDT, newDT)) {
            return newDT;
        }
        return existingDT;
    }

    public static boolean requiresPromotionForComparison(IDataType ldt, IDataType rdt) {
        if (ldt == null || rdt == null) {
            return false;
        }
        if (ldt.getCCLTypeCode() == 12 && ((DecimalType)ldt).getPrecision() <= 18 && (rdt.getCCLTypeCode() == 10 || rdt.getCCLTypeCode() == 11)) {
            return true;
        }
        if (rdt.getCCLTypeCode() == 12 && ((DecimalType)rdt).getPrecision() <= 18 && (ldt.getCCLTypeCode() == 10 || ldt.getCCLTypeCode() == 11)) {
            return false;
        }
        if (ldt.getCCLTypeCode() == rdt.getCCLTypeCode()) {
            return false;
        }
        if (ldt.getSubType() == DataSubType.NUMERICTYPE && rdt.getSubType() == DataSubType.NUMERICTYPE) {
            return ldt.getCCLTypeCode() < rdt.getCCLTypeCode();
        }
        return false;
    }
}

