/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.collators;

import com.cognos.xqe.data.collators.CollatorPool;
import com.cognos.xqe.data.collators.CollatorPoolFactory;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.ibm.icu.text.CollationKey;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RawCollationKey;
import com.ibm.icu.util.VersionInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class WrapperCollator
extends Collator
implements Serializable {
    private static final long serialVersionUID = -7372060232638001907L;
    private Collator stateCollator = null;
    CollatorPoolFactory collatorFactory;
    private Object collatorKey;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject((Object)this.collatorFactory);
        out.writeObject(this.collatorKey);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.collatorKey = in.readObject();
        this.collatorFactory = (CollatorPoolFactory)((Object)in.readObject());
        this.stateCollator = new DummyCollator(this.collatorFactory, this.collatorKey);
    }

    public WrapperCollator(CollatorPoolFactory factory, Object key) {
        this.collatorFactory = factory;
        this.stateCollator = new DummyCollator(factory, key);
    }

    public synchronized void setStrength(int strengthLevel) {
        this.stateCollator.setStrength(strengthLevel);
    }

    public synchronized int getStrength() {
        return this.stateCollator.getStrength();
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public synchronized Collator cloneAsThawed() {
        throw new UnsupportedOperationException();
    }

    public synchronized int compare(Object arg0, Object arg1) {
        return this.stateCollator.compare(arg0, arg1);
    }

    public synchronized int compare(String arg0, String arg1) {
        return this.stateCollator.compare(arg0, arg1);
    }

    public synchronized boolean equals(String arg0, String arg1) {
        return this.stateCollator.equals(arg0, arg1);
    }

    public synchronized Collator freeze() {
        Collator frozenCollator = this.stateCollator.freeze();
        return new WrapperCollator(this.collatorFactory, frozenCollator);
    }

    public synchronized CollationKey getCollationKey(String arg0) {
        return this.stateCollator.getCollationKey(arg0);
    }

    public synchronized int getDecomposition() {
        return this.stateCollator.getDecomposition();
    }

    public synchronized RawCollationKey getRawCollationKey(String arg0, RawCollationKey arg1) {
        return this.stateCollator.getRawCollationKey(arg0, arg1);
    }

    public synchronized int[] getReorderCodes() {
        return this.stateCollator.getReorderCodes();
    }

    public synchronized VersionInfo getUCAVersion() {
        return this.stateCollator.getUCAVersion();
    }

    public synchronized int getVariableTop() {
        return this.stateCollator.getVariableTop();
    }

    public synchronized VersionInfo getVersion() {
        return this.stateCollator.getVersion();
    }

    public synchronized int setVariableTop(String arg0) {
        return this.stateCollator.setVariableTop(arg0);
    }

    public synchronized void setVariableTop(int arg0) {
        this.stateCollator.setVariableTop(arg0);
    }

    public synchronized boolean isFrozen() {
        return this.stateCollator.isFrozen();
    }

    protected synchronized Collator getCollatorImpl() {
        if (this.stateCollator instanceof DummyCollator) {
            return null;
        }
        return this.stateCollator;
    }

    private class DummyCollator
    extends Collator
    implements Serializable {
        private static final long serialVersionUID = 6447001720121811738L;
        private Object key;
        private int strengthLevel = 2;

        DummyCollator(CollatorPoolFactory afactory, Object akey) {
            this.key = akey;
            this.setStrengthLevelFromKey(this.key);
        }

        private void setStrengthLevelFromKey(Object bkey) {
            String name = bkey.toString();
            String[] parts = name.split("\\:");
            if (parts.length > 1) {
                CollatorPoolFactory.CollatorWeight[] weights = CollatorPoolFactory.CollatorWeight.values();
                for (int i = 0; i < weights.length; ++i) {
                    if (!weights[i].abbreviation.equalsIgnoreCase(parts[1])) continue;
                    this.strengthLevel = weights[i].weight;
                    break;
                }
            }
        }

        private void makeCollator() {
            try {
                if (WrapperCollator.this.stateCollator == this) {
                    WrapperCollator.this.stateCollator = CollatorPool.borrowCollatorImpl(this.key);
                }
            }
            catch (Exception e) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_LocaleCollatorCreation, this.key.toString());
            }
        }

        public int[] getReorderCodes() {
            this.makeCollator();
            return WrapperCollator.this.stateCollator.getReorderCodes();
        }

        public int getStrength() {
            return this.strengthLevel;
        }

        public boolean isFrozen() {
            this.makeCollator();
            return WrapperCollator.this.stateCollator.isFrozen();
        }

        public void setStrength(int astrLevel) {
            this.strengthLevel = astrLevel;
        }

        public Object clone() {
            return new DummyCollator(null, this.key);
        }

        public Collator cloneAsThawed() {
            return new DummyCollator(null, this.key);
        }

        public int compare(Object arg0, Object arg1) {
            this.makeCollator();
            return WrapperCollator.this.stateCollator.compare(arg0, arg1);
        }

        public int compare(String arg0, String arg1) {
            this.makeCollator();
            return WrapperCollator.this.stateCollator.compare(arg0, arg1);
        }

        public boolean equals(String arg0, String arg1) {
            this.makeCollator();
            return WrapperCollator.this.stateCollator.equals(arg0, arg1);
        }

        public Collator freeze() {
            return this;
        }

        public CollationKey getCollationKey(String arg0) {
            this.makeCollator();
            return WrapperCollator.this.stateCollator.getCollationKey(arg0);
        }

        public RawCollationKey getRawCollationKey(String arg0, RawCollationKey arg1) {
            this.makeCollator();
            return WrapperCollator.this.stateCollator.getRawCollationKey(arg0, arg1);
        }

        public VersionInfo getUCAVersion() {
            this.makeCollator();
            return WrapperCollator.this.stateCollator.getUCAVersion();
        }

        public int getVariableTop() {
            this.makeCollator();
            return WrapperCollator.this.stateCollator.getVariableTop();
        }

        public VersionInfo getVersion() {
            this.makeCollator();
            return WrapperCollator.this.stateCollator.getVersion();
        }

        public int setVariableTop(String arg0) {
            this.makeCollator();
            return WrapperCollator.this.stateCollator.setVariableTop(arg0);
        }

        public void setVariableTop(int arg0) {
            this.makeCollator();
            WrapperCollator.this.stateCollator.setVariableTop(arg0);
        }
    }
}

