/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.json;

import com.cognos.xqe.authentication.AuthenticationHelper;
import com.cognos.xqe.data.json.JSONReader;
import com.cognos.xqe.data.json.JSONUtil;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Map;
import net.minidev.json.JSONObject;

public abstract class AbstractJSONReader
implements JSONReader {
    AbstractJSONReader() {
    }

    AbstractJSONReader(AbstractConnection connection, IValue content, String pathExpr) throws IOException {
        InputStream iStream = null;
        byte cclTypeCode = content.getDataType().getCCLTypeCode();
        if (cclTypeCode == 45 || cclTypeCode == 114) {
            iStream = new ByteArrayInputStream(content.toString().getBytes());
        } else if (cclTypeCode == 105 && ((Value)content).getObject() instanceof ByteArrayInputStream) {
            iStream = (ByteArrayInputStream)((Value)content).getObject();
        } else {
            URLConnection urlConnection;
            if (cclTypeCode == 48) {
                urlConnection = AuthenticationHelper.createSimpleURLConnection(content.toString());
            } else {
                JSONObject properties = (JSONObject)((Value)content).getObject();
                urlConnection = AuthenticationHelper.createURLConnection(connection, (Map<String, Object>)properties);
            }
            iStream = JSONUtil.getInputStream(urlConnection);
        }
        this.initialize(iStream, pathExpr);
    }

    public AbstractJSONReader(URLConnection connection, String pathExpr) throws IOException {
        this.initialize(JSONUtil.getInputStream(connection), pathExpr);
    }

    protected abstract void initialize(InputStream var1, String var2);

    @Override
    public void remove() {
    }

    @Override
    public void release() {
    }
}

