/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.json;

import com.cognos.xqe.authentication.AuthenticationHelper;
import com.cognos.xqe.data.json.JSONReader;
import com.cognos.xqe.data.json.JSONUtil;
import com.cognos.xqe.data.json.PagingReader;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import com.cognos.xqe.exception.XQERuntimeException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import net.minidev.json.JSONObject;

public class GoogleReader
implements JSONReader {
    private static final String WWW_GOOGLEAPIS_COM = "www.googleapis.com";
    private static final String MAPS_GOOGLEAPIS_COM = "maps.googleapis.com";
    private static final String MAPS_API_PLACE = "/maps/api/place";
    private static final String MAPS_API_PLACE_DETAILS = "/maps/api/place/details";
    private static final String PLUS_V1 = "/plus/v1";
    private static final String YOUTUBE_V3 = "/youtube/v3";
    private JSONReader reader;

    GoogleReader(AbstractConnection connection, Map<String, Object> properties, String pathExpr) throws IOException {
        String connectionURL = (String)properties.get("URL");
        URL url = new URL(connectionURL);
        String host = url.getHost();
        String path = url.getPath();
        if (host.equals(WWW_GOOGLEAPIS_COM) && (path.startsWith(YOUTUBE_V3) || path.startsWith(PLUS_V1))) {
            this.reader = new PagingReader(connection, properties, pathExpr, "items", "pageToken", "nextPageToken");
        } else if (host.equals(MAPS_GOOGLEAPIS_COM) && path.startsWith(MAPS_API_PLACE) && !path.startsWith(MAPS_API_PLACE_DETAILS)) {
            this.reader = new GooglePlacesReader(connection, properties, pathExpr);
        }
    }

    @Override
    public boolean hasNext() {
        return this.reader.hasNext();
    }

    @Override
    public JSONObject next() {
        return (JSONObject)this.reader.next();
    }

    @Override
    public void release() {
        this.reader.release();
    }

    protected static boolean contains(String[] array, String value) {
        for (int i = 0; i < array.length; ++i) {
            if (!value.contains(array[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void remove() {
    }

    private class GooglePlacesReader
    extends PagingReader {
        private static final String STATUS = "status";
        private static final String INVALID_REQUEST = "INVALID_REQUEST";
        private static final int MAX_TRIES = 5;
        private static final int SLEEP_TIME = 5000;
        private int tries;

        GooglePlacesReader(AbstractConnection connection, Map<String, Object> properties, String path) throws IOException {
            super(connection, properties, path, "results", "pagetoken", "next_page_token");
            this.tries = 5;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void getContent(String url) {
            HttpURLConnection urlConnection = null;
            try {
                this.tries = 5;
                while (this.tries-- > 0) {
                    this.properties.put("URL", url);
                    urlConnection = (HttpURLConnection)AuthenticationHelper.createURLConnection(this.connection, this.properties);
                    InputStream iStream = urlConnection.getInputStream();
                    JsonFactory factory = new JsonFactory();
                    if (this.parser != null) {
                        this.parser.close();
                    }
                    this.parser = factory.createParser(iStream);
                    this.parser.enable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
                    JsonToken token = this.parser.nextToken();
                    this.pageToken = null;
                    while (null != token) {
                        token = this.parser.nextToken();
                        if (token != JsonToken.FIELD_NAME) continue;
                        String name = this.parser.getCurrentName();
                        if (name.equals(this.nextPageKey)) {
                            this.parser.nextToken();
                            this.pageToken = (String)JSONUtil.parseValue(this.parser);
                            continue;
                        }
                        if (!name.equals(this.dataKey)) continue;
                        this.parser.nextToken();
                        break;
                    }
                    if ((token = this.parser.nextToken()) == JsonToken.START_OBJECT) return;
                    if (token == JsonToken.END_ARRAY) {
                        this.parser.nextToken();
                        if (this.parser.getCurrentName().equals(STATUS)) {
                            this.parser.nextToken();
                            String status = (String)JSONUtil.parseValue(this.parser);
                            if (status.equals("OK") || status.equals("ZERO_RESULTS")) return;
                            if (!status.equals(INVALID_REQUEST) || this.tries == 0) {
                                throw new IOException(status);
                            }
                        }
                    }
                    this.parser.close();
                    Thread.sleep(5000L);
                }
                return;
            }
            catch (IOException e) {
                try {
                    if (urlConnection == null) throw e;
                    if (urlConnection.getResponseCode() == 401) {
                        throw new LogonFailureException(LogonFailureException.SubCodeEnum.UNAUTHORIZED, (String)null);
                    }
                    InputStream eStream = urlConnection.getErrorStream();
                    String error = JSONUtil.readResponse(eStream);
                    e.initCause(new IOException(error));
                    throw e;
                }
                catch (IOException e1) {
                    throw new XQERuntimeException(e1);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

