/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.json;

import com.cognos.xqe.authentication.AuthenticationHelper;
import com.cognos.xqe.authentication.AuthenticationType;
import com.cognos.xqe.bibushandler.datasource.DataSourceConnection;
import com.cognos.xqe.data.json.JSONReader;
import com.cognos.xqe.data.json.JSONReaderFactory;
import com.cognos.xqe.data.model.IUsernamePasswordSignon;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.ConnectionUtil;
import java.io.IOException;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public class JSONAssemblyHelper {
    private static final String SCHEMA_KEY = "$schema";
    private static final String SCHEMA_URL = "http://developer.cognos.com/schemas/assembly.json";
    private static final String NAMESPACE = "namespace";
    private static final String BASE = "base";
    private static final String DATASETS = "datasets";
    private static final String NAME = "name";
    private static final String RESOURCE = "resource";
    private static final String PARAMETERS = "parameters";
    private static final String PATH = "path";
    private static final String SCHEMA = "schema";
    private static final String METHOD = "method";
    private static final String DATA = "data";
    private static final String GET = "GET";
    private static final String MIME_TYPE = "mime_type";
    private static final String MAX_PARSED_OBJECTS = "max_parsed_objects";
    private static final String NUMS_AS_STRINGS = "nums_as_strings";
    private static final String NUMS_AS_DOUBLES = "nums_as_doubles";
    private static final String QUESTION_MARK = "?";
    private static final String AMPERSAND = "&";
    private static final Integer DEFAULT_OBJECTS_TO_PROCESS = 10;
    private static final Integer MAX_OBJECTS_TO_PROCESS = 100;
    private static final String FALSE_STR = "false";
    private static final String TRUE_STR = "true";
    private JSONObject jArtifact;
    private Map<String, JSONObject> datasetMap = new HashMap<String, JSONObject>();

    public static JSONAssemblyHelper getJSONAssemblyHelper(DataSourceConnection conn) {
        URLConnection connection;
        IUsernamePasswordSignon signon = (IUsernamePasswordSignon)conn.getSignon();
        Map<String, Object> properties = ConnectionUtil.extractKeyValuePairs(conn.getConnectionString(signon));
        String authType = (String)properties.get("AUTHENTICATION_TYPE");
        AuthenticationType authenticationType = AuthenticationType.getType(authType);
        String userName = null;
        String password = null;
        if (signon != null) {
            userName = signon.getUserName();
            password = signon.getPassword().decrypt();
        }
        try {
            connection = AuthenticationHelper.createURLConnection(conn.getDataSource().getCMDataSourceName(), userName, password, authenticationType, properties);
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
        return new JSONAssemblyHelper(connection, properties);
    }

    public JSONAssemblyHelper(URLConnection connection, Map<String, Object> properties) {
        JSONReader reader = JSONReaderFactory.create(connection, properties, "$");
        if (reader.hasNext()) {
            this.jArtifact = (JSONObject)reader.next();
        }
        JSONArray datasets = this.getDatasets();
        for (int i = 0; i < datasets.size(); ++i) {
            JSONObject dataset = (JSONObject)datasets.get(i);
            this.datasetMap.put(this.getDatasetName(dataset), dataset);
        }
        reader.release();
    }

    public String getNamespace() {
        return (String)this.jArtifact.get((Object)NAMESPACE);
    }

    public String getBaseURL() {
        return (String)this.jArtifact.get((Object)BASE);
    }

    public JSONObject getDataset(String name) {
        return this.datasetMap.get(name);
    }

    public JSONArray getDatasets() {
        return (JSONArray)this.jArtifact.get((Object)DATASETS);
    }

    public String getDatasetName(JSONObject dataset) {
        return (String)dataset.get((Object)NAME);
    }

    public Object getDatasetSchema(JSONObject dataset) {
        return dataset.get((Object)SCHEMA);
    }

    public String getDatasetURL(JSONObject dataset) {
        StringBuilder sBuilder = new StringBuilder();
        String baseURL = this.getBaseURL();
        String resource = this.getDatasetResource(dataset);
        String[] parameters = this.getDatasetParameters(dataset);
        if (baseURL != null) {
            sBuilder.append(baseURL);
        }
        sBuilder.append(resource);
        if (parameters != null) {
            sBuilder.append(QUESTION_MARK).append(parameters[0]);
            for (int j = 1; j < parameters.length; ++j) {
                sBuilder.append(AMPERSAND).append(parameters[j]);
            }
        }
        return sBuilder.toString();
    }

    public String getDatasetResource(JSONObject dataset) {
        return (String)dataset.get((Object)RESOURCE);
    }

    public String[] getDatasetParameters(JSONObject dataset) {
        JSONArray parameters = (JSONArray)dataset.get((Object)PARAMETERS);
        if (parameters == null) {
            return null;
        }
        return (String[])parameters.toArray((Object[])new String[parameters.size()]);
    }

    public String getDatasetPathExpression(JSONObject dataset, String defaultValue) {
        String pathExpr = (String)dataset.get((Object)PATH);
        if (pathExpr == null) {
            pathExpr = defaultValue;
        }
        return pathExpr;
    }

    public String getDatasetMimeType(JSONObject dataset) {
        String type = (String)dataset.get((Object)MIME_TYPE);
        if (type == null) {
            type = "application/json";
        }
        return type;
    }

    public String getRequestMethod(JSONObject dataset) {
        String type = (String)dataset.get((Object)METHOD);
        if (type == null) {
            type = GET;
        }
        return type;
    }

    public String getData(JSONObject dataset) {
        Object data = dataset.get((Object)DATA);
        if (data instanceof String) {
            return (String)data;
        }
        if (data instanceof JSONObject) {
            return ((JSONObject)data).toJSONString();
        }
        return null;
    }

    public int getMaxObjectsToParse(JSONObject dataset) {
        Object objsToParse = dataset.get((Object)MAX_PARSED_OBJECTS);
        if (objsToParse instanceof Integer) {
            int objs = (Integer)objsToParse;
            if (objs > 0 && objs <= MAX_OBJECTS_TO_PROCESS) {
                return objs;
            }
        } else if (objsToParse instanceof String) {
            try {
                int objs = Integer.parseInt((String)objsToParse);
                if (objs > 0 && objs <= MAX_OBJECTS_TO_PROCESS) {
                    return objs;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return DEFAULT_OBJECTS_TO_PROCESS;
    }

    public boolean getNumbersAsStrings(JSONObject dataset) {
        Object numbersAsStringsOption = dataset.get((Object)NUMS_AS_STRINGS);
        if (numbersAsStringsOption instanceof Boolean) {
            return (Boolean)numbersAsStringsOption;
        }
        if (numbersAsStringsOption instanceof String) {
            if (FALSE_STR.equalsIgnoreCase(numbersAsStringsOption.toString())) {
                return false;
            }
            if (TRUE_STR.equalsIgnoreCase(numbersAsStringsOption.toString())) {
                return true;
            }
        }
        return false;
    }

    public boolean getNumbersAsDoubles(JSONObject dataset) {
        Object numbersAsDoublesOption = dataset.get((Object)NUMS_AS_DOUBLES);
        if (numbersAsDoublesOption instanceof Boolean) {
            return (Boolean)numbersAsDoublesOption;
        }
        if (numbersAsDoublesOption instanceof String) {
            if (FALSE_STR.equalsIgnoreCase(numbersAsDoublesOption.toString())) {
                return false;
            }
            if (TRUE_STR.equalsIgnoreCase(numbersAsDoublesOption.toString())) {
                return true;
            }
        }
        return false;
    }

    public void getProperties(String name, Map<String, Object> properties) {
        JSONObject dataset = this.getDataset(name);
        properties.put("URL", this.getDatasetURL(dataset));
        properties.put("PATH", this.getDatasetPathExpression(dataset, "$"));
        properties.put("METHOD", this.getRequestMethod(dataset));
        properties.put("MIME_TYPE", this.getDatasetMimeType(dataset));
        properties.put("DATA", this.getData(dataset));
        properties.put("MAX_PARSED_OBJECTS", this.getMaxObjectsToParse(dataset));
        properties.put("NUMS_AS_STRINGS", this.getNumbersAsStrings(dataset));
        properties.put("NUMS_AS_DOUBLES", this.getNumbersAsDoubles(dataset));
    }
}

