/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.json;

import com.cognos.xqe.data.json.BasicJSONReader;
import com.cognos.xqe.data.json.CloudantReader;
import com.cognos.xqe.data.json.FacebookReader;
import com.cognos.xqe.data.json.GoogleReader;
import com.cognos.xqe.data.json.JSONReader;
import com.cognos.xqe.data.json.StreamingJSONReader;
import com.cognos.xqe.data.json.TwitterReader;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.util.Map;
import net.minidev.json.JSONObject;

public class JSONReaderFactory {
    static final String SIMPLE_PATH_EXPR = "\\$(\\.[A-Za-z0-9]*)*";

    public static JSONReader create(AbstractConnection connection, IValue content, String pathExpr) {
        JSONReader reader = null;
        try {
            if (content.getDataType().getCCLTypeCode() == 105 && ((Value)content).getObject() instanceof JSONObject) {
                JSONObject properties = (JSONObject)((Value)content).getObject();
                String subType = (String)properties.get("SUBTYPE");
                if (subType.equals("Cloudant") || subType.equals("CouchDB")) {
                    reader = new CloudantReader(connection, (Map<String, Object>)properties, pathExpr);
                } else if (subType.equals("Facebook")) {
                    reader = new FacebookReader(connection, (Map<String, Object>)properties, pathExpr);
                } else if (subType.equals("Twitter")) {
                    reader = new TwitterReader(connection, (Map<String, Object>)properties, pathExpr);
                } else if (subType.equals("GoogleAnalytics") || subType.equals("GooglePlaces") || subType.equals("Google+")) {
                    reader = new GoogleReader(connection, (Map<String, Object>)properties, pathExpr);
                }
            }
            if (reader == null) {
                reader = pathExpr.matches(SIMPLE_PATH_EXPR) ? new StreamingJSONReader(connection, content, pathExpr) : new BasicJSONReader(connection, content, pathExpr);
            }
        }
        catch (MalformedURLException e) {
            throw new XQERuntimeException(e);
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
        return reader;
    }

    public static JSONReader create(URLConnection connection, Map<String, Object> properties, String pathExpr) {
        JSONReader reader = null;
        try {
            String host = connection.getURL().getHost();
            String subType = (String)properties.get("SUBTYPE");
            reader = subType.equals("Cloudant") || subType.equals("CouchDB") ? new CloudantReader(connection, pathExpr) : (pathExpr.matches(SIMPLE_PATH_EXPR) ? new StreamingJSONReader(connection, pathExpr) : new BasicJSONReader(connection, pathExpr));
        }
        catch (MalformedURLException e) {
            throw new XQERuntimeException(e);
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
        return reader;
    }
}

