/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.model;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.bibushandler.datasource.DataSourceCapabilities;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.CapabilitiesKey;
import com.cognos.xqe.data.model.CapabilitiesKeyParts;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.usage.UsageTrackingService;
import com.cognos.xqe.util.usage.indicators.IUsageIndicator;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorCategory;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.Flat3Map;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.dom4j.Attribute;
import org.dom4j.Element;

public abstract class AbstractDataSource
implements IDataSource,
IXQEPersist {
    public static final String DUMMY_FLAG = "isDummy";
    public static final String STRING_PROPERTY_NAME = "name";
    public static final String STRING_PROPERTY_TYPE = "type";
    public static final String STRING_PROPERTY_METADATA_PROPERTIES = "metadataProperties";
    protected static final XQELogger LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Connection", LogLevel.INFO);
    private String name;
    protected String type;
    private Map<String, Object> metadataProperties;
    private IDataSourceCapabilities capabilities = null;

    protected AbstractDataSource(String theName, String theType, Map<String, Object> theMetadataProperties) {
        this.name = theName;
        this.type = theType;
        this.metadataProperties = theMetadataProperties != null ? new HashMap<String, Object>(theMetadataProperties) : new Flat3Map();
    }

    public final boolean isCapabilitySupported(String key) {
        return this.getCapabilities().isSupported(key);
    }

    @Override
    public final IDataSourceCapabilities createCapabilities(CapabilitiesKeyParts parts, HashMap<String, AbstractConfiguration> configs) {
        this.capabilities = new DataSourceCapabilities(this, parts, configs);
        return this.capabilities;
    }

    @Override
    public final IDataSourceCapabilities getCapabilities() {
        if (null == this.capabilities) {
            this.capabilities = new DataSourceCapabilities(this);
        }
        return this.capabilities;
    }

    @Override
    public final void setCapabilities(IDataSourceCapabilities theCapabilities) {
        this.capabilities = theCapabilities;
    }

    @Override
    public final CapabilitiesKey getCapabilitiesKey() {
        if (null == this.capabilities) {
            return null;
        }
        return this.capabilities.getKey();
    }

    @Override
    public final Map<String, Object> getMetadataProperties() {
        return this.metadataProperties;
    }

    @Override
    public final void setMetadataProperties(Map<String, Object> theMetadataProperties) {
        this.metadataProperties = theMetadataProperties;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public String getCMDataSourceName() {
        return this.name;
    }

    @Override
    public void setCMDataSourceName(String theName) {
        this.name = theName;
    }

    @Override
    public final String getType() {
        if (null == this.type) {
            this.type = this.resolveInterfaceType();
            if (this.type.equals("DO")) {
                this.type = "EB";
            }
            if (null != this.type) {
                IUsageIndicator ind = UsageTrackingService.getIndicator(UsageIndicatorType.ONCE_PER_REPORT_INDICATOR, UsageIndicatorCategory.DATA_SOURCE_TYPE, this.type);
                ind.increment();
            }
        }
        return this.type;
    }

    public void setType(String newType) {
        this.type = newType;
    }

    @Override
    public final boolean isRelational() {
        return "relational".equals(this.metadataProperties.get("queryType"));
    }

    @Override
    public void setIsRelational() {
        this.metadataProperties.put("queryType", "relational");
    }

    @Override
    public boolean isROLAP() {
        return DataSourceTypeEnum.isROLAP(this.type);
    }

    private String resolveInterfaceType() {
        String connectionString = this.getDataSourceConnection().getConnectionString(null);
        return DataSourceTypeEnum.getInterfaceTypeFromConnectionString(connectionString);
    }

    @Override
    public void persist(XQEPersistContext ctx, String optionalName) {
        this.asXML();
        if (ctx.beginElement(this, optionalName, -1)) {
            this.persistProperties(ctx);
            ctx.endElement();
        }
    }

    public void persistProperties(XQEPersistContext ctx) {
        this.persistAttributeProperties(ctx);
        this.persistElementProperties(ctx);
    }

    public void persistAttributeProperties(XQEPersistContext ctx) {
        if (this.type != null) {
            ctx.property(STRING_PROPERTY_TYPE, this.type);
        }
    }

    public void persistElementProperties(XQEPersistContext ctx) {
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
        this.restoreAttributes(ctx, node);
        this.restoreChildren(ctx, node);
    }

    public void restoreAttributes(XQERestoreContext ctx, Element node) {
        int size = node.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = node.attribute(i);
            this.restoreAttributeProperty(ctx, att, node);
        }
    }

    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(STRING_PROPERTY_NAME)) {
            Object value = ctx.attributeValue(att);
            this.name = (String)value;
        } else if (attname.equals(STRING_PROPERTY_TYPE)) {
            Object value = ctx.attributeValue(att);
            this.type = (String)value;
        }
    }

    protected void restoreChildren(XQERestoreContext ctx, Element node) {
        PlanningEnvironment env = ctx.getPlanningEnvironment();
        List childList = node.elements();
        int nChildren = childList.size();
        for (int i = 0; i < nChildren; ++i) {
            Element child = (Element)childList.get(i);
            this.restoreElementProperty(ctx, child, node);
        }
    }

    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
    }
}

