/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.model;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.data.model.DataSourceException;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMAttribute;
import org.dom4j.dom.DOMElement;

public class ConnectionNotFoundException
extends DataSourceException {
    static final long serialVersionUID = 71832953243L;
    private String searchPath = null;
    private String connectionName = null;

    public ConnectionNotFoundException(IDataSource theDataSource) {
        super(theDataSource, XQEMessageKeys.DS_ConnectionNotFound);
    }

    public ConnectionNotFoundException(IDataSource theDataSource, String theSearchPath, String theConnection) {
        super(theDataSource, XQEMessageKeys.DS_ConnectionNotFound1, theConnection);
        this.searchPath = theSearchPath;
        this.connectionName = theConnection;
    }

    public ConnectionNotFoundException(IDataSource theDataSource, String theSearchPath) {
        super(theDataSource, XQEMessageKeys.DS_ConnectionNotFound);
        this.searchPath = theSearchPath;
    }

    @Override
    public String getFaultCode() {
        return "CQE-804";
    }

    @Override
    public String getFaultString() {
        if (this.connectionName != null) {
            return XQEMessages.getMessage(XQEMessageKeys.DS_ConnectionNotFound1, XQEMessages.getCurrProductLocale(), this.connectionName);
        }
        return XQEMessages.getMessage(XQEMessageKeys.DS_ConnectionNotFound, XQEMessages.getCurrProductLocale());
    }

    @Override
    protected Element getFaultConnection() {
        if (this.searchPath == null && this.connectionName == null) {
            return super.getFaultConnection();
        }
        DOMElement faultConnection = new DOMElement(new QName("faultConnection"));
        if (this.connectionName != null) {
            DOMElement nameElement = new DOMElement(new QName("name"));
            DOMAttribute nameValue = new DOMAttribute(new QName("value"), this.connectionName);
            nameElement.add((Attribute)nameValue);
            faultConnection.add((Element)nameElement);
        }
        if (this.searchPath != null) {
            DOMElement searchPathElement = new DOMElement(new QName("searchPath"));
            DOMAttribute value = new DOMAttribute(new QName("value"), this.searchPath);
            searchPathElement.add((Attribute)value);
            faultConnection.add((Element)searchPathElement);
        }
        return faultConnection;
    }

    @Override
    public BIBusEnvelope getFaultEnvelope() {
        Element dsElement;
        BIBusEnvelope faultEnvelope = new BIBusEnvelope();
        Element faultElement = faultEnvelope.createFaultElement(this.getFaultCode(), this.getFaultString());
        Element faultConnection = this.getFaultConnection();
        if (faultConnection != null) {
            faultElement.add(faultConnection);
        }
        if (this.getDataSource() != null && (dsElement = this.getDataSource().asXML()) != null) {
            faultElement.add(dsElement);
        }
        return faultEnvelope;
    }
}

