/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.model;

import com.cognos.xqe.data.model.DataSourceException;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMAttribute;
import org.dom4j.dom.DOMElement;

public class SignonNotFoundException
extends DataSourceException {
    static final long serialVersionUID = 89123498573284L;
    private String searchPath = null;
    private String name = null;

    public SignonNotFoundException(IDataSource theDataSource, String theName, String theSearchPath) {
        super(theDataSource, XQEMessageKeys.DS_SignonNotFound);
        this.searchPath = theSearchPath;
        this.name = theName;
    }

    @Override
    public String getFaultCode() {
        return "CQE-805";
    }

    @Override
    public String getFaultString() {
        if (this.name != null) {
            return XQEMessages.getMessage(XQEMessageKeys.DS_SignonNotFoundWithName, XQEMessages.getCurrProductLocale(), this.name);
        }
        return XQEMessages.getMessage(XQEMessageKeys.DS_SignonNotFound, XQEMessages.getCurrProductLocale());
    }

    @Override
    protected Element getFaultSignon() {
        DOMElement faultSignon = new DOMElement(new QName("faultSignon"));
        DOMElement nameElement = new DOMElement(new QName("name"));
        DOMAttribute value = new DOMAttribute(new QName("value"), this.name);
        nameElement.add((Attribute)value);
        faultSignon.add((Element)nameElement);
        DOMElement searchPathElement = new DOMElement(new QName("searchPath"));
        value = new DOMAttribute(new QName("value"), this.searchPath);
        searchPathElement.add((Attribute)value);
        faultSignon.add((Element)searchPathElement);
        return faultSignon;
    }
}

