/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.IDataProvider;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.pool.connection.DefaultExpirationPolicy;
import com.cognos.xqe.pool.connection.IExpirationPolicy;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.resource.ReleasableResourceTracker;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public abstract class DataProviderBase
implements IDataProvider {
    public static final boolean DEFAULT_CONNECTION_POOLING_DISABLED = false;
    public static final boolean DEFAULT_CONTEXTUAL_CONNECTION_POOLING_DISABLED = false;
    public static final int DEFAULT_CONNECTION_EXPIRATION_CHECK_PERIOD = 30000;
    public static final int DEFAULT_CONNECTION_MAX_NUMBER = -1;
    public static final int DEFAULT_CONNECTION_MAX_CONCURRENT_USE = 1;
    public static final int DEFAULT_CONNECTION_EXPIRATION_THRESHOLD = 300;
    public static final int DEFAULT_CONNECTION_LIFETIME_THRESHOLD = 0;
    public static final long DEFAULT_CUBE_UPDATE_CHECK_PERIOD = 10000L;
    private static final boolean DEFAULT_RESULTSET_CACHE_ENABLED = false;
    private static final int DEFAULT_RESULTSET_CACHE_MAX_LIFE = 1800000;
    private static final int DEFAULT_RESULTSET_CACHE_MAX_IDLE = 300000;
    private static final int DEFAULT_RESULTSET_CACHE_MAX_OBJS = 100000;
    private static final long DEFAULT_RESULTSET_CACHE_MAX_RETAINED_SIZE = -1L;
    private static final int DEFAULT_RESULTSET_CACHE_CHECK_PERIOD = 5000;
    public static final int DEFAULT_CONNECTION_ATTEMPT_TIMEOUT = -1;
    public static final int DEFAULT_CONNECTION_ATTEMPT_CHECKPERIOD = 60000;
    public static final long DEFAULT_CONNECTION_SELECTION_TIMEOUT = 0L;
    public static final long DEFAULT_CONNECTION_ESTABLISHED_TIMEOUT = 30000L;
    public static final boolean DEFAULT_CONNECTION_ASYNC_USAGE = false;
    private static XQELogger ERROR_LOGGER = null;
    private final XQELogger mProviderConfigLogger;
    private ReleasableResourceTracker mTracker = new ReleasableResourceTracker();
    private static final String THE_VALUE_STR = "The value \"";
    private static final String IS_NOT_VALID_STR = "\" is not valid.  Please provide ";
    private static final String FOR_CONFIG_STR = "\" for configuration property \"";
    private final Properties mProperties = new Properties(this.getDefaultProperties(DEFAULT_PROPERTIES));
    private final String mProviderInstanceName;
    private static final Properties DEFAULT_PROPERTIES = DataProviderBase.makeDefaultProperties();

    public static String getDefaultConnectionExpirationThreshold() {
        int idleTimeout = 1000 * XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE).getIntProperty("providers.defaultIdleConnectionTimeout", 300);
        return Integer.toString(idleTimeout);
    }

    public DataProviderBase(String instanceName, Properties properties) {
        this.mProperties.putAll((Map<?, ?>)properties);
        this.mProviderInstanceName = instanceName;
        this.mProviderConfigLogger = XQELog.getLogger(ServiceEnumeration.XQEODP, instanceName, "Provider.Configuration", LogLevel.WARN);
    }

    protected Properties getDefaultProperties(Properties properties) {
        return properties;
    }

    protected static Properties makeDefaultProperties() {
        Properties properties = new Properties();
        properties.setProperty("connectionPoolingDisabled", Boolean.toString(false));
        properties.setProperty("connectionContextualPoolingDisabled", Boolean.toString(false));
        properties.setProperty("connectionExpirationThreshold", DataProviderBase.getDefaultConnectionExpirationThreshold());
        properties.setProperty("connectionExpirationCheckPeriod", Integer.toString(30000));
        properties.setProperty("connectionLifetimeThreshold", Long.toString(0L));
        properties.setProperty("connectionMaxNumber", Integer.toString(-1));
        properties.setProperty("connectionMaxConcurrentUse", Integer.toString(1));
        properties.setProperty("resultSetCacheEnabled", Boolean.toString(false));
        properties.setProperty("resultSetCacheMaxObjects", Integer.toString(100000));
        properties.setProperty("resultSetCacheMaxRetainedSize", Long.toString(-1L));
        properties.setProperty("resultSetCacheMaxLifeTime", Integer.toString(1800000));
        properties.setProperty("resultSetCacheMaxIdleTime", Integer.toString(300000));
        properties.setProperty("resultSetCacheCheckPeriod", Integer.toString(5000));
        properties.setProperty("connectionAttemptTimeout", Integer.toString(-1));
        properties.setProperty("connectionAttemptCheckPeriod", Integer.toString(60000));
        properties.setProperty("connectionSelectionTimeout", Long.toString(0L));
        properties.setProperty("cubeUpdateCheckPeriod", Long.toString(10000L));
        properties.setProperty("connectionEstablishedTimeout", Long.toString(30000L));
        properties.setProperty("connectToTM1wAsyncTimeout", Boolean.toString(false));
        return properties;
    }

    @Override
    public String getProperty(String propertyName) {
        return this.mProperties.getProperty(propertyName);
    }

    public int getIntegerProperty(String propertyName, int defaultValue, boolean allowNegativeValue) {
        String strValue = this.getProperty(propertyName);
        try {
            int value = Integer.valueOf(strValue);
            if (!allowNegativeValue && value < 0) {
                if (this.mProviderConfigLogger.isOn(LogLevel.WARN)) {
                    StringBuilder sb = new StringBuilder(THE_VALUE_STR).append(value).append(FOR_CONFIG_STR).append(propertyName).append("\" is not valid.  Please provide a non-negative integer value.");
                    this.mProviderConfigLogger.log(LogLevel.WARN, sb.toString());
                }
                return defaultValue;
            }
            return value;
        }
        catch (NumberFormatException e) {
            if (this.mProviderConfigLogger.isOn(LogLevel.WARN)) {
                StringBuilder sb = new StringBuilder(THE_VALUE_STR).append(strValue).append(FOR_CONFIG_STR).append(propertyName).append(IS_NOT_VALID_STR);
                if (allowNegativeValue) {
                    sb.append("an integer value.\n");
                } else {
                    sb.append("a non-negative integer value.\n");
                }
                this.mProviderConfigLogger.log(LogLevel.WARN, sb.toString(), (Throwable)e);
            }
            return defaultValue;
        }
    }

    public long getLongProperty(String propertyName, long defaultValue, boolean allowNegativeValue) {
        String strValue = this.getProperty(propertyName);
        try {
            long value = Long.valueOf(strValue);
            if (!allowNegativeValue && value < 0L) {
                if (this.mProviderConfigLogger.isOn(LogLevel.WARN)) {
                    StringBuilder sb = new StringBuilder(THE_VALUE_STR).append(value).append(FOR_CONFIG_STR).append(propertyName).append("\" is not valid.  Please provide a non-negative long value.");
                    this.mProviderConfigLogger.log(LogLevel.WARN, sb.toString());
                }
                return defaultValue;
            }
            return value;
        }
        catch (NumberFormatException e) {
            if (this.mProviderConfigLogger.isOn(LogLevel.WARN)) {
                StringBuilder sb = new StringBuilder(THE_VALUE_STR).append(strValue).append(FOR_CONFIG_STR).append(propertyName).append(IS_NOT_VALID_STR);
                if (allowNegativeValue) {
                    sb.append("a long value.\n");
                } else {
                    sb.append("a non-negative long value.\n");
                }
                this.mProviderConfigLogger.log(LogLevel.WARN, sb.toString(), (Throwable)e);
            }
            return defaultValue;
        }
    }

    public Properties getProperties() {
        return this.mProperties;
    }

    @Override
    public String getProviderInstanceName() {
        return this.mProviderInstanceName;
    }

    @Override
    public String cognosUNToNativeUN(String providerType, IHierarchy hierarchy, String cognosUN) {
        return cognosUN;
    }

    @Override
    public String nativeUNToCognosUN(String providerType, String nativeUN) {
        return nativeUN;
    }

    @Override
    public final ReleasableResourceTracker getResourceTracker() {
        return this.mTracker;
    }

    @Override
    public final void release() {
        this.mTracker.reportAndCleanup(false);
        try {
            this.releaseImpl();
        }
        catch (Throwable e) {
            this.logException(e);
        }
    }

    private synchronized void logException(Throwable e) {
        if (ERROR_LOGGER == null) {
            ERROR_LOGGER = XQELog.getLogger(ServiceEnumeration.XQEODP, "XQEODP", "Resources", LogLevel.ERROR);
        }
        ERROR_LOGGER.log(e);
    }

    protected abstract void releaseImpl();

    @Override
    public void resolveDataSourceCapabilities(IExecutionEnvironment executionEnv, IDataSource dataSource, Locale designLocale) {
    }

    @Override
    public IExpirationPolicy getConnectionExpirationPolicy() {
        int connectionExpirationThreshold = Integer.valueOf(this.getProperty("connectionExpirationThreshold"));
        long connectionLifetimeThreshold = Long.valueOf(this.getProperty("connectionLifetimeThreshold"));
        return new DefaultExpirationPolicy(connectionLifetimeThreshold, connectionExpirationThreshold);
    }
}

