/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers;

import com.cognos.xqe.cache.ICaching;
import com.cognos.xqe.data.providers.DataProviderBase;
import com.cognos.xqe.query.engine.TransformationEngine;
import com.cognos.xqe.resultsets.md.CacheHints;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.util.LinkedStack;
import com.cognos.xqe.util.resource.ReleasableResourceTracker;
import java.util.Locale;

public abstract class ProviderResultSetBase
extends XResultSetBase
implements ICaching {
    private final Locale mFormatLocale;

    public ProviderResultSetBase(DataProviderBase provider, XDataContext xDataContext, Locale formatLocale, Integer nodeId) {
        super(xDataContext, nodeId, new ReleasableResourceTracker());
        if (null == provider) {
            throw new IllegalArgumentException("provider was null");
        }
        this.mFormatLocale = formatLocale;
        ReleasableResourceTracker tracker = this.getResourceTracker();
        ReleasableResourceTracker parentTracker = provider.getResourceTracker();
        parentTracker.addNestedTracker(tracker);
        tracker.addInstance(this, Thread.currentThread().getStackTrace());
    }

    private static Integer getNodeID(XDataContext xDataContext) {
        Integer nodeId = null;
        if (null != xDataContext) {
            nodeId = xDataContext.getNodeId();
        }
        if (null == nodeId) {
            nodeId = TransformationEngine.DUMMY_NODEID;
        }
        return nodeId;
    }

    public ProviderResultSetBase(DataProviderBase provider, XDataContext xDataContext, Locale formatLocale) {
        this(provider, xDataContext, formatLocale, ProviderResultSetBase.getNodeID(xDataContext));
    }

    public final Locale getFormatLocale() {
        return this.mFormatLocale;
    }

    @Override
    protected void releaseImpl() {
        ReleasableResourceTracker tracker = this.getResourceTracker();
        tracker.removeInstance(this);
        tracker.reportAndCleanup(true);
        tracker.removeFromNestingTracker();
    }

    @Override
    public boolean isCaching() {
        return false;
    }

    public void optimizeCache(LinkedStack<CacheHints> hints) {
    }
}

