/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers;

import com.cognos.xqe.data.model.AbstractDataSource;
import com.cognos.xqe.data.model.DataSourceException;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.providers.SimpleDataSourceConnection;
import com.cognos.xqe.exception.XQESOAPFaultException;
import java.util.Map;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public final class SimpleDataSource
extends AbstractDataSource {
    private final IDataSourceConnection connection;

    public SimpleDataSource(String theName, String theType, IDataSourceConnection theConnection, Map<String, Object> theMetadataProperties) {
        super(theName, theType, theMetadataProperties);
        if (null == theConnection) {
            throw new IllegalArgumentException("theConnection");
        }
        this.connection = theConnection;
        if (LOGGER.isOn()) {
            LOGGER.log("Create new " + this.toString());
        }
    }

    @Override
    public Element asXML() {
        Element dataSourceElement = DocumentHelper.createElement((String)"dataSource");
        Element nameElement = dataSourceElement.addElement("name");
        nameElement.addAttribute("value", this.getName());
        Element typeElement = dataSourceElement.addElement("type");
        typeElement.addAttribute("value", this.getType());
        dataSourceElement.add(this.connection.asXML());
        return dataSourceElement;
    }

    @Override
    public IDataSourceConnection getDataSourceConnection() throws DataSourceException, XQESOAPFaultException {
        return this.connection;
    }

    public static IDataSource newInstance(String theName, String theType, String theConnectionString, Map<String, Object> theMetadataProperties, IDataSourceConnectionSignon theSignon) {
        SimpleDataSourceConnection connection = new SimpleDataSourceConnection(theConnectionString, theSignon);
        return new SimpleDataSource(theName, theType, connection, theMetadataProperties);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SimpleDataSource[connection=").append(this.getDataSourceConnection().toString());
        buffer.append(", metadataProps=").append(this.getMetadataProperties().toString());
        buffer.append("]");
        return buffer.toString();
    }
}

