/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers;

import com.cognos.xqe.bibushandler.Commands;
import com.cognos.xqe.data.model.DataSourceException;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionCommandBlock;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.providers.connection.ConnectionStringBuilder;
import com.cognos.xqe.exception.XQESOAPFaultException;
import java.util.HashMap;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public final class SimpleDataSourceConnection
implements IDataSourceConnection {
    private final String connectionString;
    private String isolationLevel = null;
    private final IDataSourceConnectionSignon signon;
    private final String namespaceID;
    private String userGroups;
    HashMap<String, Object> connectionParameters = new HashMap();

    public SimpleDataSourceConnection(String theConnectionString, IDataSourceConnectionSignon theSignon) {
        this.connectionString = theConnectionString;
        this.signon = theSignon;
        this.namespaceID = null;
        this.userGroups = null;
    }

    public SimpleDataSourceConnection(String theConnectionString, IDataSourceConnectionSignon theSignon, String namespace) {
        this.connectionString = theConnectionString;
        this.signon = theSignon;
        this.namespaceID = namespace;
        this.userGroups = null;
    }

    @Override
    public String getConnectionString(IDataSourceConnectionSignon dataSourceConnectionSignon) {
        return ConnectionStringBuilder.substituteSignonInConnectionString(this.connectionString, dataSourceConnectionSignon);
    }

    @Override
    public IDataSourceConnectionSignon getSignon() throws DataSourceException, XQESOAPFaultException {
        return this.signon;
    }

    @Override
    public Object getConnectionParameter(String key) {
        return this.connectionParameters.get(key);
    }

    @Override
    public String getConnectionString() {
        return this.getConnectionString(this.signon);
    }

    @Override
    public void setConnectionParameter(String key, Object value) {
        this.connectionParameters.put(key, value);
    }

    public void setIsolationLevel(String isoLevel) {
        this.isolationLevel = isoLevel;
    }

    @Override
    public List<IDataSourceConnectionCommandBlock> getCommandBlock(Commands key) {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getIsolationLevel() {
        return this.isolationLevel;
    }

    @Override
    public String getApiToken() {
        return null;
    }

    @Override
    public String getSearchPath() {
        return null;
    }

    @Override
    public String getNamespace() {
        return this.namespaceID;
    }

    @Override
    public Element asXML() {
        Element connectionElement = DocumentHelper.createElement((String)"connection");
        Element nameElement = connectionElement.addElement("name");
        nameElement.addAttribute("value", "SimpleDataSourceConnection");
        if (null != this.getSignon()) {
            connectionElement.add(this.getSignon().asXML());
        }
        return connectionElement;
    }

    @Override
    public boolean hasResolvedSignon() {
        return false;
    }

    @Override
    public void invalidateResolvedSignon() {
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SimpleDataSourceConnection[name=").append(this.getName());
        buffer.append(", connectionString=").append(this.getConnectionString(null));
        buffer.append(", namespace=").append(this.getNamespace());
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public String getUserGroups() {
        return this.userGroups;
    }

    @Override
    public void setUserGroups(String newUserGroups) {
        this.userGroups = newUserGroups;
    }

    @Override
    public boolean isModelConnection() {
        return false;
    }

    @Override
    public String getEncryptedSignon() {
        return null;
    }

    @Override
    public String getDBUserNameFromConnectionElementOrCredential() {
        return null;
    }
}

