/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.analytics;

import com.cognos.xqe.data.providers.analytics.IForecastProvider;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;

public class ForecastProviderAdaptor
implements IForecastProvider {
    Class providerClass = null;
    Object providerInstance = null;
    Method cancelMethod;
    Method prepareMethod;
    Method executeMethod = null;

    public ForecastProviderAdaptor(Class fProviderClass) {
        this.providerClass = fProviderClass;
        try {
            this.providerInstance = this.providerClass.newInstance();
        }
        catch (IllegalAccessException e1) {
            throw new XQERuntimeException(XQEMessageKeys.PRE_InstantiationError, (Throwable)e1, this.providerClass.getName());
        }
        catch (InstantiationException e1) {
            throw new XQERuntimeException(XQEMessageKeys.PRE_InstantiationError, (Throwable)e1, this.providerClass.getName());
        }
        try {
            this.cancelMethod = this.providerClass.getMethod("cancel", new Class[0]);
        }
        catch (SecurityException e) {
            this.cancelMethod = null;
        }
        catch (NoSuchMethodException e) {
            this.cancelMethod = null;
        }
        try {
            this.prepareMethod = this.providerClass.getMethod("prepare", String.class);
        }
        catch (SecurityException e) {
            this.prepareMethod = null;
        }
        catch (NoSuchMethodException e) {
            this.prepareMethod = null;
        }
        try {
            this.executeMethod = this.providerClass.getMethod("execute", Collection.class, Collection.class, Collection.class);
        }
        catch (SecurityException e) {
            throw new XQERuntimeException(XQEMessageKeys.PRE_ExecuteMethodCallError, (Throwable)e, this.providerClass.getName());
        }
        catch (NoSuchMethodException e) {
            throw new XQERuntimeException(XQEMessageKeys.PRE_ExecuteMethodCallError, (Throwable)e, this.providerClass.getName());
        }
    }

    @Override
    public void cancel() {
        if (this.cancelMethod != null) {
            try {
                this.cancelMethod.invoke(this.providerInstance, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new XQERuntimeException(XQEMessageKeys.PRE_CancelMethodCallError, (Throwable)e, this.providerClass.getName());
            }
            catch (IllegalAccessException e) {
                throw new XQERuntimeException(XQEMessageKeys.PRE_CancelMethodCallError, (Throwable)e, this.providerClass.getName());
            }
            catch (InvocationTargetException e) {
                throw new XQERuntimeException(XQEMessageKeys.PRE_CancelMethodCallError, (Throwable)e, this.providerClass.getName());
            }
        }
    }

    @Override
    public boolean prepare(String modelParameters) {
        if (this.prepareMethod != null) {
            try {
                Boolean result = (Boolean)this.prepareMethod.invoke(this.providerInstance, modelParameters);
                return result;
            }
            catch (IllegalArgumentException e) {
                throw new XQERuntimeException(XQEMessageKeys.PRE_PrepareMethodCallError, (Throwable)e, this.providerClass.getName());
            }
            catch (IllegalAccessException e) {
                throw new XQERuntimeException(XQEMessageKeys.PRE_PrepareMethodCallError, (Throwable)e, this.providerClass.getName());
            }
            catch (InvocationTargetException e) {
                throw new XQERuntimeException(XQEMessageKeys.PRE_PrepareMethodCallError, (Throwable)e, this.providerClass.getName());
            }
        }
        return false;
    }

    @Override
    public Collection execute(Collection<Double> historicalTimePeriods, Collection<Double> historicalValues, Collection<Double> forecastTimePeriods) {
        try {
            return (Collection)this.executeMethod.invoke(this.providerInstance, historicalTimePeriods, historicalValues, forecastTimePeriods);
        }
        catch (IllegalArgumentException e) {
            throw new XQERuntimeException(XQEMessageKeys.PRE_ExecuteMethodCallError, (Throwable)e, this.providerClass.getName());
        }
        catch (IllegalAccessException e) {
            throw new XQERuntimeException(XQEMessageKeys.PRE_ExecuteMethodCallError, (Throwable)e, this.providerClass.getName());
        }
        catch (InvocationTargetException e) {
            throw new XQERuntimeException(XQEMessageKeys.PRE_ExecuteMethodCallError, (Throwable)e, this.providerClass.getName());
        }
    }
}

