/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.analytics;

import com.cognos.xqe.data.providers.analytics.ForecastTypeParser;
import com.cognos.xqe.data.providers.analytics.IForecastProvider;
import com.cognos.xqe.data.providers.analytics.IForecastSeriesSet;
import com.cognos.xqe.data.providers.analytics.IHistorySeriesSet;
import com.cognos.xqe.data.providers.analytics.ITimeSeriesModel;
import com.cognos.xqe.data.providers.analytics.ITimeseriesException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogInvocationHandler;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class LibForecast
implements IForecastProvider {
    private static final String DOT = ".";
    private static final String TIME_SERIES_PACKAGE = "com.ibm.infosphere.timeseries";
    private static final String HISTORY_SERIES_CLASS = "HistorySeriesSet";
    private static final String FORECAST_SERIES_CLASS = "ForecastSeriesSet";
    private static final String TIME_SERIES_MODEL_CLASS = "TimeSeriesModel";
    private static final String TIME_SERIES_ALGORITHM_ENUM_CLASS = "TimeSeriesModel$Algorithm";
    private static final int SYSTEMDETERMINED_PDQ_VALUE = -1;
    static Class timeSeriesModelClass = null;
    static Class historySeriesClass = null;
    static Class forecastSeriesClass = null;
    static Class forecastAlgorithEnumClass = null;
    static Method algorithmEnumValueOf = null;
    static Boolean classesInitialized = false;
    Vector<Double> historicalValues;
    Vector<Double> historicalTimes;
    Vector<Double> forecastTimes;
    TSAlgorithmType algorithm = TSAlgorithmType.AUTOMATICALLY_PICKED;
    Collection<Object> algorithmProperties = null;

    @Override
    public void cancel() {
    }

    @Override
    public boolean prepare(String modelParameters) {
        Map<String, Collection<Object>> parsedType = ForecastTypeParser.parse(modelParameters);
        for (String propertyName : parsedType.keySet()) {
            TSAlgorithmType algorithmValue = TSAlgorithmType.get(propertyName);
            if (algorithmValue == TSAlgorithmType.UNKNOWN) continue;
            this.algorithm = algorithmValue;
            this.algorithmProperties = parsedType.get(propertyName);
        }
        return true;
    }

    @Override
    public Collection execute(Collection<Double> fHistoricalTimePeriods, Collection<Double> fHistoricalValues, Collection<Double> fForecastTimePeriods) {
        Vector outputVector;
        block5: {
            this.historicalValues = LibForecast.extractVector(fHistoricalValues);
            this.historicalTimes = LibForecast.extractVector(fHistoricalTimePeriods);
            this.forecastTimes = LibForecast.extractVector(fForecastTimePeriods);
            outputVector = null;
            try {
                this.prepareClassAccess();
                IHistorySeriesSet historySeries = (IHistorySeriesSet)LogInvocationHandler.createObjectWithProxy(historySeriesClass, new Object[]{this.historicalTimes});
                historySeries.addTimeSeriesData("", this.historicalValues);
                ITimeSeriesModel tsModel = (ITimeSeriesModel)LogInvocationHandler.createObjectWithProxy(timeSeriesModelClass, new Object[]{historySeries});
                Vector<Double> futureTimes = new Vector<Double>(this.forecastTimes);
                futureTimes.removeAll(this.historicalTimes);
                tsModel.setForecastTimes(futureTimes);
                Vector<Double> fittedTimes = new Vector<Double>(this.historicalTimes);
                tsModel.setFittingTimes(fittedTimes);
                if (this.algorithm != TSAlgorithmType.AUTOMATICALLY_PICKED) {
                    tsModel.disableAllAlgorithms();
                    tsModel.enableAlgorithm(this.algorithm.getLibraryEnum());
                    if (this.algorithm == TSAlgorithmType.ARIMA && this.algorithmProperties != null) {
                        this.setARIMAProperties(tsModel);
                    }
                }
                tsModel.forecast();
                outputVector = this.convertToOutputVector(tsModel);
            }
            catch (RuntimeException e) {
                if (!(e instanceof LogInvocationHandler.InvocationException)) {
                    throw e;
                }
                LogInvocationHandler.InvocationException invocationError = (LogInvocationHandler.InvocationException)e;
                if (!(invocationError.getTarget() instanceof ITimeseriesException)) break block5;
                ITimeseriesException tsError = (ITimeseriesException)invocationError.getTarget();
                this.throwTimeseriesError(tsError);
            }
        }
        return outputVector;
    }

    private void setARIMAProperties(ITimeSeriesModel tsModel) {
        int p = -1;
        int d = -1;
        int q = -1;
        int vP = -1;
        int vD = -1;
        int vQ = -1;
        Collection<Object> pdqCollection = null;
        Collection vPDQCollection = null;
        Iterator<Object> propIt = this.algorithmProperties.iterator();
        if (propIt.hasNext()) {
            Object arg = propIt.next();
            if (arg instanceof Collection) {
                pdqCollection = (Collection)arg;
                if (propIt.hasNext()) {
                    vPDQCollection = (Collection)propIt.next();
                }
            } else {
                pdqCollection = this.algorithmProperties;
            }
        }
        if (pdqCollection != null) {
            Iterator<Object> pdqIt = pdqCollection.iterator();
            p = this.readARIMASubmodelIndex(pdqIt);
            d = this.readARIMASubmodelIndex(pdqIt);
            q = this.readARIMASubmodelIndex(pdqIt);
        }
        if (vPDQCollection != null) {
            Iterator<Object> vPDQIt = vPDQCollection.iterator();
            vP = this.readARIMASubmodelIndex(vPDQIt);
            vD = this.readARIMASubmodelIndex(vPDQIt);
            vQ = this.readARIMASubmodelIndex(vPDQIt);
        }
        tsModel.setARIMAParameters("", p, d, q, vP, vD, vQ);
    }

    private int readARIMASubmodelIndex(Iterator<Object> pdqIt) {
        if (!pdqIt.hasNext()) {
            return -1;
        }
        Object indexValue = pdqIt.next();
        if (!(indexValue instanceof Integer)) {
            throw new XQERuntimeException(XQEMessageKeys.PRE_NonIntegerARIMAIndex);
        }
        return (Integer)indexValue;
    }

    private void throwTimeseriesError(ITimeseriesException tsError) {
        String tsMessage = "TimeSeriesLibrary message id: " + tsError.getMessageID();
        if (tsError.getMessageParameters() != null && tsError.getMessageParameters().size() > 0) {
            tsMessage = tsMessage + " parameters {";
            for (int iParam = 0; iParam < tsError.getMessageParameters().size(); ++iParam) {
                if (iParam != 0) {
                    tsMessage = tsMessage + ",";
                }
                tsMessage = tsMessage + tsError.getMessageParameters();
            }
            tsMessage = tsMessage + "}";
        }
        throw new RuntimeException(tsMessage);
    }

    static Vector<Double> extractVector(Collection<Double> collection) {
        if (collection instanceof Vector) {
            return (Vector)collection;
        }
        return new Vector<Double>(collection);
    }

    private Vector<Double> createEmptyForecastResult() {
        Vector<Double> forecastResultRows = new Vector<Double>(this.forecastTimes.size());
        for (int i = 0; i < this.forecastTimes.size(); ++i) {
            forecastResultRows.add(null);
        }
        return forecastResultRows;
    }

    private Vector convertToOutputVector(ITimeSeriesModel tsModel) {
        Enum bestAlgorithm = tsModel.getBestAlgorithm("");
        IForecastSeriesSet horizonForecastSeries = tsModel.getOutputseries(bestAlgorithm);
        IForecastSeriesSet fittedForecastSeries = tsModel.getFittedseries(bestAlgorithm);
        if (horizonForecastSeries == null && fittedForecastSeries == null) {
            return this.createEmptyForecastResult();
        }
        Vector<Double[]> forecastResultRows = new Vector<Double[]>(this.forecastTimes.size());
        this.addModelValuesToResult(fittedForecastSeries, forecastResultRows);
        this.addModelValuesToResult(horizonForecastSeries, forecastResultRows);
        return forecastResultRows;
    }

    private void addModelValuesToResult(IForecastSeriesSet outputForecastSeries, Vector<Double[]> forecastResultRows) {
        Vector outputForecastValues = outputForecastSeries.getTimeSeriesData("");
        Vector<Double> outputForecastErrors = outputForecastSeries.getStandardErrors("");
        for (int vectorResultIndex = 0; vectorResultIndex < outputForecastValues.size(); ++vectorResultIndex) {
            Double forecastValue = (Double)outputForecastValues.get(vectorResultIndex);
            Double forecastError = outputForecastErrors.get(vectorResultIndex);
            forecastResultRows.add(new Double[]{forecastValue, forecastError});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareClassAccess() throws XQERuntimeException {
        if (classesInitialized.booleanValue()) {
            return;
        }
        try {
            Boolean bl = classesInitialized;
            synchronized (bl) {
                if (!classesInitialized.booleanValue()) {
                    classesInitialized = true;
                    URL timeSeriesModelJarPath = new File(".." + File.separator + "webapps" + File.separator + "p2pd" + File.separator + "WEB-INF" + File.separator + "lib" + File.separator + "TimeSeriesModel.jar").toURL();
                    URL[] urls = new URL[]{timeSeriesModelJarPath};
                    URLClassLoader timeSeriesModelLoader = new URLClassLoader(urls);
                    timeSeriesModelClass = Class.forName("com.ibm.infosphere.timeseries.TimeSeriesModel", true, timeSeriesModelLoader);
                    historySeriesClass = Class.forName("com.ibm.infosphere.timeseries.HistorySeriesSet", true, timeSeriesModelLoader);
                    forecastSeriesClass = Class.forName("com.ibm.infosphere.timeseries.ForecastSeriesSet", true, timeSeriesModelLoader);
                    forecastAlgorithEnumClass = Class.forName("com.ibm.infosphere.timeseries.TimeSeriesModel$Algorithm", true, timeSeriesModelLoader);
                    LogInvocationHandler.initProxyInterfaces(forecastSeriesClass);
                    algorithmEnumValueOf = forecastAlgorithEnumClass.getMethod("valueOf", String.class);
                }
            }
        }
        catch (MalformedURLException e) {
            throw new XQERuntimeException(XQEMessageKeys.PRE_NoTimeSeriesModelJar, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new XQERuntimeException(XQEMessageKeys.PRE_CannotLoadTSClasses, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new XQERuntimeException(XQEMessageKeys.PRE_CannotLoadTSClasses, (Throwable)e);
        }
    }

    public static enum TSAlgorithmType {
        ARIMA("ARIMA"),
        EXP_GROWTH("Growth", "EXPONENTIAL_GROWTH"),
        EXPSMOOTHING("ExponentialSmoothing", "EXPONENTIAL_SMOOTHING"),
        LINEAR_REGRESSION("LinearRegression", "LINEAR_REGRESSION"),
        SEASONAL_TREND_DECOMPOSITION("SeasonalTrend", "SEASONAL_TREND_DECOMPOSITION"),
        AUTOMATICALLY_PICKED("Automatic", ""),
        UNKNOWN("", "");

        private String name;
        private String libName;
        private Enum libraryEnum = null;

        private TSAlgorithmType(String fname) {
            this.name = fname;
            this.libName = fname;
        }

        private TSAlgorithmType(String fname, String flibName) {
            this.name = fname;
            this.libName = flibName;
        }

        public String getName() {
            return this.name;
        }

        public synchronized Enum getLibraryEnum() {
            if (this.libraryEnum == null) {
                try {
                    this.libraryEnum = (Enum)algorithmEnumValueOf.invoke(null, this.libName);
                }
                catch (Exception e) {
                    throw new XQERuntimeException(XQEMessageKeys.PRE_UnsupportedAlgorithm, (Throwable)e);
                }
            }
            return this.libraryEnum;
        }

        public static TSAlgorithmType get(String name) {
            if (name == null) {
                return AUTOMATICALLY_PICKED;
            }
            if (name.equalsIgnoreCase(ARIMA.getName())) {
                return ARIMA;
            }
            if (name.equalsIgnoreCase(EXP_GROWTH.getName())) {
                return EXP_GROWTH;
            }
            if (name.equalsIgnoreCase(EXPSMOOTHING.getName())) {
                return EXPSMOOTHING;
            }
            if (name.equalsIgnoreCase(LINEAR_REGRESSION.getName())) {
                return LINEAR_REGRESSION;
            }
            if (name.equalsIgnoreCase(SEASONAL_TREND_DECOMPOSITION.getName())) {
                return SEASONAL_TREND_DECOMPOSITION;
            }
            if (name.equalsIgnoreCase(AUTOMATICALLY_PICKED.getName())) {
                return AUTOMATICALLY_PICKED;
            }
            return UNKNOWN;
        }
    }
}

