/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.analytics;

import com.cognos.xqe.data.providers.analytics.IForecastProvider;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;

public class LocalForecastAsRank
implements IForecastProvider {
    protected RankType rankType = RankType.Olympic;

    @Override
    public void cancel() {
        throw new XQERuntimeException(XQEMessageKeys.GEN_MethodNotImplemented_INTERNAL, this.getClass().getName() + ".cancel()");
    }

    @Override
    public boolean prepare(String modelParameters) {
        if (modelParameters.compareToIgnoreCase(".LocalForecastAsRank") != 0 && modelParameters.compareToIgnoreCase("com.cognos.xqe.data.providers.analytics.LocalForecastAsRank") != 0) {
            throw new XQERuntimeException(XQEMessageKeys.PRE_UnsupportedAlgorithm);
        }
        return true;
    }

    @Override
    public Collection execute(Collection<Double> fHistoricalTimePeriods, Collection<Double> fHistoricalValues, Collection<Double> fForecastTimePeriods) {
        TreeMap<Double, Integer> sortedValues2OccuranceNumber = new TreeMap<Double, Integer>();
        TreeMap<Double, Double> time2Value = new TreeMap<Double, Double>();
        Iterator<Double> valueIt = fHistoricalValues.iterator();
        Iterator<Double> timeIt = fHistoricalTimePeriods.iterator();
        while (valueIt.hasNext()) {
            Double thisValue = valueIt.next();
            Double thisTime = timeIt.next();
            if (thisValue == null || thisTime == null) continue;
            if (sortedValues2OccuranceNumber.get(thisValue) == null) {
                sortedValues2OccuranceNumber.put(thisValue, 1);
            } else {
                sortedValues2OccuranceNumber.put(thisValue, (Integer)sortedValues2OccuranceNumber.get(thisValue) + 1);
            }
            time2Value.put(thisTime, thisValue);
        }
        TreeMap<Double, Double> rankValues = new TreeMap<Double, Double>();
        Double[] sortedValues = sortedValues2OccuranceNumber.keySet().toArray(new Double[sortedValues2OccuranceNumber.size()]);
        double rank = 1.0;
        for (int i = sortedValues.length - 1; i >= 0; --i) {
            Double thisValue = sortedValues[i];
            rankValues.put(thisValue, rank);
            rank += (double)((Integer)sortedValues2OccuranceNumber.get(thisValue)).intValue();
        }
        ArrayList<Double> forecastResultRows = new ArrayList<Double>(fForecastTimePeriods.size());
        for (Double thisTime : fForecastTimePeriods) {
            Double relValue = (Double)time2Value.get(thisTime);
            if (relValue == null) {
                forecastResultRows.add(rank);
                if (this.rankType != RankType.Serial) continue;
                rank += 1.0;
                continue;
            }
            forecastResultRows.add((Double)rankValues.get(relValue));
        }
        return forecastResultRows;
    }

    static enum RankType {
        Olympic,
        Serial;

    }
}

