/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.analytics;

import com.cognos.xqe.data.providers.analytics.ForecastProviderAdaptor;
import com.cognos.xqe.data.providers.analytics.IForecastProvider;
import com.cognos.xqe.data.providers.analytics.LibForecast;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import java.util.HashMap;

public class TimeSeriesManager {
    static HashMap<String, Class> name2ForecastProviderClass = new HashMap();
    private static final String DOT = ".";

    public static IForecastProvider getForecastProvider(String modelClassName) {
        if (modelClassName == null || modelClassName.trim().indexOf(DOT) != 0) {
            return new LibForecast();
        }
        return TimeSeriesManager.getLoadedForecastProvider(modelClassName);
    }

    private static IForecastProvider getLoadedForecastProvider(String modelClassName) {
        Class providerClass;
        try {
            providerClass = TimeSeriesManager.getForecastProviderClass(modelClassName);
        }
        catch (ClassNotFoundException e1) {
            throw new XQERuntimeException(XQEMessageKeys.PRE_CannotLoadProvider, (Throwable)e1, modelClassName);
        }
        try {
            Class<?>[] interfaces;
            for (Class<?> i : interfaces = providerClass.getInterfaces()) {
                if (i != IForecastProvider.class) continue;
                Class forecastClass = providerClass;
                return (IForecastProvider)forecastClass.newInstance();
            }
            return new ForecastProviderAdaptor(providerClass);
        }
        catch (IllegalAccessException e) {
            throw new XQERuntimeException(XQEMessageKeys.PRE_CannotLoadProvider, (Throwable)e, modelClassName);
        }
        catch (InstantiationException e) {
            throw new XQERuntimeException(XQEMessageKeys.PRE_CannotLoadProvider, (Throwable)e, modelClassName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class getForecastProviderClass(String className) throws ClassNotFoundException {
        HashMap<String, Class> hashMap = name2ForecastProviderClass;
        synchronized (hashMap) {
            if (className.indexOf(DOT) == 0) {
                className = IForecastProvider.class.getPackage().getName() + className;
            }
            if (name2ForecastProviderClass.get(className) != null) {
                return name2ForecastProviderClass.get(className);
            }
            Class<?> providerClass = Class.forName(className);
            name2ForecastProviderClass.put(className, providerClass);
            return providerClass;
        }
    }
}

